/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vaquaclient;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.plaf.PanelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentedControlBuilder {
    @NotNull
    public static final String TEXTURED = "textured";
    @NotNull
    public static final String SEPARATED = "separated";
    @NotNull
    public static final String TEXTURED_SEPARATED = "texturedSeparated";
    @NotNull
    public static final String ROUND_RECT = "roundRect";
    @NotNull
    public static final String GRADIENT = "gradient";
    @NotNull
    public static final String LARGE = "large";
    @NotNull
    public static final String REGULAR = "regular";
    @NotNull
    public static final String SMALL = "small";
    @NotNull
    public static final String MINI = "mini";
    @NotNull
    private final String buttonType;
    private final boolean isExclusive;
    @Nullable
    private final String controlSize;
    @NotNull
    private final List<AbstractButton> buttons = new ArrayList<AbstractButton>();
    private boolean isClosed;
    private final int defaultSeparation;

    public SegmentedControlBuilder(@Nullable String string, boolean bl, @Nullable String string2, int n) {
        this.buttonType = this.getButtonStyle(string);
        this.isExclusive = bl;
        this.controlSize = string2 != null ? string2 : REGULAR;
        this.defaultSeparation = Math.max(0, n);
    }

    @NotNull
    private String getButtonStyle(@Nullable String string) {
        if (string == null) {
            return "segmented";
        }
        if (string.equals(TEXTURED)) {
            return "segmentedTextured";
        }
        if (string.equals(SEPARATED)) {
            return "segmentedSeparated";
        }
        if (string.equals(TEXTURED_SEPARATED)) {
            return "segmentedTexturedSeparated";
        }
        if (string.equals(ROUND_RECT)) {
            return "segmentedRoundRect";
        }
        if (string.equals(GRADIENT)) {
            return "segmentedGradient";
        }
        throw new IllegalArgumentException("Unrecognized segmented control style: " + string);
    }

    public void add(@NotNull JButton jButton) {
        if (this.isExclusive) {
            throw new IllegalStateException("Only toggle buttons are supported in an exclusive control");
        }
        if (this.isClosed) {
            throw new IllegalStateException("Builder has been closed");
        }
        this.buttons.remove(jButton);
        this.buttons.add(jButton);
        jButton.putClientProperty("JButton.buttonType", this.buttonType);
        jButton.putClientProperty("JComponent.sizeVariant", this.controlSize);
    }

    public void add(@NotNull JToggleButton jToggleButton) {
        if (this.isClosed) {
            throw new IllegalStateException("Builder has been closed");
        }
        this.buttons.remove(jToggleButton);
        this.buttons.add(jToggleButton);
        jToggleButton.putClientProperty("JButton.buttonType", this.buttonType);
        jToggleButton.putClientProperty("JComponent.sizeVariant", this.controlSize);
    }

    @NotNull
    public JPanel build() {
        if (this.isClosed) {
            throw new IllegalStateException("Builder has been closed");
        }
        this.isClosed = true;
        return new SegmentedControl(this.buttons, this.isExclusive, this.defaultSeparation);
    }

    private static class SegmentedControl
    extends JPanel {
        @NotNull
        private final List<AbstractButton> buttons;
        @Nullable
        private final ButtonGroup group;
        private final int defaultSeparation;
        private boolean isSegmented;

        public SegmentedControl(@NotNull List<AbstractButton> list, boolean bl, int n) {
            this.buttons = list;
            if (bl && list.size() > 1) {
                this.group = new ButtonGroup();
                for (AbstractButton abstractButton : list) {
                    this.group.add(abstractButton);
                }
            } else {
                this.group = null;
            }
            this.defaultSeparation = n;
            this.setLayout(new BoxLayout(this, 0));
            this.isSegmented = this.isSegmentedSupported();
            this.installButtons();
            this.addPropertyChangeListener("UI", this::updateForUI);
            this.addPropertyChangeListener("componentOrientation", this::updateForComponentOrientation);
            this.setOpaque(false);
        }

        private void updateForUI(@Nullable PropertyChangeEvent propertyChangeEvent) {
            boolean bl = this.isSegmentedSupported();
            if (bl != this.isSegmented) {
                this.isSegmented = bl;
                this.installButtons();
            }
        }

        private void updateForComponentOrientation(@Nullable PropertyChangeEvent propertyChangeEvent) {
            this.isSegmented = this.isSegmentedSupported();
            this.installButtons();
        }

        /*
         * WARNING - void declaration
         */
        private void installButtons() {
            int n;
            int n2;
            this.removeAll();
            List<AbstractButton> list = this.buttons;
            if (!this.getComponentOrientation().isLeftToRight()) {
                list = new ArrayList<AbstractButton>(list);
                Collections.reverse(list);
            }
            if ((n2 = list.size()) == 1) {
                AbstractButton abstractButton = list.get(0);
                abstractButton.putClientProperty("JButton.segmentPosition", "only");
            } else {
                for (int i = 0; i < n2; ++i) {
                    void object;
                    AbstractButton abstractButton = list.get(i);
                    String string = "middle";
                    if (i == 0) {
                        String string2 = "first";
                    } else if (i == n2 - 1) {
                        String string3 = "last";
                    }
                    abstractButton.putClientProperty("JButton.segmentPosition", object);
                }
            }
            if (this.group != null && (n = this.getSelectedCount(list)) == 0) {
                list.get(0).setSelected(true);
            }
            boolean bl = true;
            for (AbstractButton abstractButton : list) {
                if (!bl && !this.isSegmented) {
                    this.add(Box.createHorizontalStrut(this.defaultSeparation));
                }
                bl = false;
                this.add(abstractButton);
            }
            this.revalidate();
            this.repaint();
        }

        private int getSelectedCount(@NotNull List<AbstractButton> list) {
            int n = 0;
            for (AbstractButton abstractButton : list) {
                if (!abstractButton.isSelected()) continue;
                ++n;
            }
            return n;
        }

        private boolean isSegmentedSupported() {
            PanelUI panelUI = this.getUI();
            if (panelUI != null) {
                String string = panelUI.getClass().getName();
                return string.startsWith("com.apple.laf.") || string.startsWith("org.violetlib.aqua.");
            }
            return false;
        }
    }
}

