/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.RendererDescriptions;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public abstract class RendererDescriptionsBase
implements RendererDescriptions {
    @Override
    @NotNull
    public RendererDescription getButtonRendererDescription(@NotNull ButtonConfiguration buttonConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = this.toCanonicalButtonStyle(buttonConfiguration.getButtonWidget());
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            ToolBarItemWellConfiguration toolBarItemWellConfiguration = new ToolBarItemWellConfiguration(buttonConfiguration.getState(), true);
            return this.getToolBarItemWellRendererDescription(toolBarItemWellConfiguration);
        }
        AquaUIPainter.Size size = buttonConfiguration.getSize();
        int n = JNRPlatformUtils.getPlatformVersion();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR && n < 101100) {
            buttonWidget = AquaUIPainter.ButtonWidget.BUTTON_ROUND;
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            switch (size) {
                case LARGE: {
                    return new BasicRendererDescription(-5.0f, -1.0f, 10.0f, 1.0f);
                }
                case REGULAR: {
                    return new BasicRendererDescription(-6.0f, 0.0f, 12.0f, 2.0f);
                }
                case SMALL: {
                    if (n >= 101600) {
                        return new BasicRendererDescription(-4.0f, 0.0f, 10.0f, 2.0f);
                    }
                    return new BasicRendererDescription(-5.0f, -1.0f, 10.0f, 3.0f);
                }
                case MINI: {
                    if (n >= 101600) {
                        return new BasicRendererDescription(-1.0f, -1.0f, 2.0f, 2.0f);
                    }
                    return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            return new BasicRendererDescription(-2.0f, -2.0f, 4.0f, 4.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, n < 101200 ? 3.0f : 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return n < 101200 ? new BasicRendererDescription(0.0f, -0.5f, 1.0f, 0.0f) : new BasicRendererDescription(-0.49f, 0.0f, 1.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
            return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -4.0f, 0.0f, 10.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -2.0f, 0.0f, 8.0f);
                }
                case MINI: {
                    BasicRendererDescription basicRendererDescription = new BasicRendererDescription(0.0f, -1.0f, 0.0f, 3.0f);
                    BasicRendererDescription basicRendererDescription2 = new BasicRendererDescription(0.0f, -0.5f, 0.0f, 3.0f);
                    return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription2);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        int n = JNRPlatformUtils.getPlatformVersion();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return this.createVertical(0.0f, 1.0f);
                    }
                    case SMALL: {
                        return this.createVertical(0.49f, 2.0f);
                    }
                    case MINI: {
                        return this.createVertical(-0.51f, 5.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_SEGMENTED_INSET: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return this.createVertical(-1.0f, 4.0f);
                    }
                    case SMALL: {
                        return this.createVertical(-1.0f, 5.0f);
                    }
                    case MINI: {
                        return this.createVertical(-1.0f, 6.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return n >= 101100 ? this.createVertical(-1.49f, 3.0f) : this.createVertical(-1.0f, 2.0f);
                    }
                    case SMALL: {
                        float f = -0.49f;
                        if (segmentedButtonWidget.isToolbar()) {
                            f = -1.49f;
                        } else if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED) {
                            f = -0.1f;
                        }
                        return n >= 101100 ? this.createVertical(f, 4.0f) : this.createVertical(-1.0f, 4.0f);
                    }
                    case MINI: {
                        return new MultiResolutionRendererDescription(this.createVertical(n >= 101100 ? 0.0f : -1.0f, 5.0f), this.createVertical(0.0f, n >= 101100 ? 5.0f : 4.5f));
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return this.createVertical(0.0f, 2.0f);
                    }
                    case SMALL: {
                        return this.createVertical(0.0f, 3.0f);
                    }
                    case MINI: {
                        return this.createVertical(0.0f, 4.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected RendererDescription adjustSegmentedRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        boolean bl;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        boolean bl2 = segmentedButtonWidget.isSeparated();
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        boolean bl3 = position == AquaUIPainter.Position.FIRST || position == AquaUIPainter.Position.ONLY;
        boolean bl4 = position == AquaUIPainter.Position.LAST || position == AquaUIPainter.Position.ONLY;
        boolean bl5 = !bl2 && (position == AquaUIPainter.Position.MIDDLE || position == AquaUIPainter.Position.LAST);
        boolean bl6 = bl = !bl2 && (position == AquaUIPainter.Position.FIRST || position == AquaUIPainter.Position.MIDDLE);
        if (bl3) {
            f2 += f4;
            f += f5;
        }
        if (bl4) {
            f += f6;
        }
        if (bl5 && segmentedButtonConfiguration.getLeftDividerState() == SegmentedButtonConfiguration.DividerState.NONE) {
            f2 -= 1.0f;
            f += 1.0f;
        }
        if (bl && segmentedButtonConfiguration.getRightDividerState() == SegmentedButtonConfiguration.DividerState.NONE) {
            f += 1.0f;
        }
        try {
            return JNRUtils.adjustRendererDescription(rendererDescription, f2, f3, f, f7);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + segmentedButtonConfiguration);
            return rendererDescription;
        }
    }

    @Override
    @Nullable
    public RendererDescription getBasicPopupButtonRendererDescription(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        return this.getPopupButtonRendererDescription(popupButtonConfiguration);
    }

    @Override
    @NotNull
    public RendererDescription getPopupButtonRendererDescription(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        boolean bl;
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        AquaUIPainter.Size size = popupButtonConfiguration.getSize();
        boolean bl2 = popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl3 = bl = popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((bl2 || bl) && size == AquaUIPainter.Size.MINI) {
            size = AquaUIPainter.Size.SMALL;
        }
        switch (popupButtonWidget) {
            case BUTTON_POP_UP: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(-2.0f, 0.0f, 5.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(-1.0f, 0.0f, 3.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_UP_CELL: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, -3.0f, 0.0f, 3.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 1.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(-1.0f, -1.0f, 3.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_UP_SQUARE: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(-1.0f, -1.0f, 3.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_DOWN: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 1.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 1.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_DOWN_CELL: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_DOWN_SQUARE: {
                switch (size) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, -1.0f, 1.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_DOWN_BEVEL: {
                return new BasicRendererDescription(-2.0f, -2.0f, 4.0f, 4.0f);
            }
            case BUTTON_POP_UP_ROUND_RECT: 
            case BUTTON_POP_DOWN_ROUND_RECT: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
            }
            case BUTTON_POP_UP_RECESSED: 
            case BUTTON_POP_DOWN_RECESSED: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
            }
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_DOWN_GRADIENT: {
                return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getToolBarItemWellRendererDescription(@NotNull ToolBarItemWellConfiguration toolBarItemWellConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getTitleBarRendererDescription(@NotNull TitleBarConfiguration titleBarConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderRendererDescription(@NotNull SliderConfiguration sliderConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderTrackRendererDescription(@NotNull SliderConfiguration sliderConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderTickMarkRendererDescription(@NotNull SliderConfiguration sliderConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderThumbRendererDescription(@NotNull SliderConfiguration sliderConfiguration) {
        AquaUIPainter.Size size = sliderConfiguration.getSize();
        if (sliderConfiguration.isHorizontal() || sliderConfiguration.isVertical()) {
            if (!sliderConfiguration.hasTickMarks()) {
                float f = 0.0f;
                if (AquaUIPainterBase.internalGetSliderRenderingVersion() == 2 && size == AquaUIPainter.Size.REGULAR) {
                    f = 4.0f;
                }
                float f2 = -1.0f;
                float f3 = sliderConfiguration.isHorizontal() ? JNRUtils.size2D(size, -0.5f, 0.0f, 0.0f) : JNRUtils.size2D(size, -0.5f, -0.5f, -0.5f);
                BasicRendererDescription basicRendererDescription = new BasicRendererDescription(0.0f, f2, 0.0f, f);
                BasicRendererDescription basicRendererDescription2 = new BasicRendererDescription(0.0f, f3, 0.0f, f);
                return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription2);
            }
            if (sliderConfiguration.isHorizontal()) {
                float f = 0.0f;
                if (AquaUIPainterBase.internalGetSliderRenderingVersion() == 2 && size == AquaUIPainter.Size.REGULAR) {
                    f = 3.0f;
                }
                float f4 = 0.0f;
                float f5 = JNRUtils.size2D(size, 0.0f, 0.0f, 0.0f);
                if (sliderConfiguration.getTickMarkPosition() == AquaUIPainter.TickMarkPosition.ABOVE) {
                    float f6 = 0.0f;
                    float f7 = JNRUtils.size2D(size, 0.0f, 0.0f, 0.0f);
                    BasicRendererDescription basicRendererDescription = new BasicRendererDescription(f4, f6, 0.0f, f += JNRUtils.size2D(size, 1.0f, 0.0f, 0.0f));
                    BasicRendererDescription basicRendererDescription3 = new BasicRendererDescription(f5, f7, 0.0f, f);
                    return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription3);
                }
                float f8 = JNRUtils.size2D(size, -1.0f, 0.0f, 0.0f);
                float f9 = JNRUtils.size2D(size, 0.0f, 0.0f, 0.0f);
                BasicRendererDescription basicRendererDescription = new BasicRendererDescription(f4, f8, 0.0f, f += 1.0f);
                BasicRendererDescription basicRendererDescription4 = new BasicRendererDescription(f5, f9, 0.0f, f);
                return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription4);
            }
            float f = 0.0f;
            if (AquaUIPainterBase.internalGetSliderRenderingVersion() == 2 && size == AquaUIPainter.Size.REGULAR) {
                f = 3.0f;
            }
            float f10 = 0.0f;
            float f11 = JNRUtils.size2D(size, 0.0f, 0.5f, 0.5f);
            if (sliderConfiguration.getTickMarkPosition() == AquaUIPainter.TickMarkPosition.LEFT) {
                float f12 = JNRUtils.size2D(size, 1.0f, 2.0f, 2.0f);
                BasicRendererDescription basicRendererDescription = new BasicRendererDescription(0.0f, f10, f12, f += (float)JNRUtils.size(size, 1, 0, 0));
                BasicRendererDescription basicRendererDescription5 = new BasicRendererDescription(0.0f, f11, f12, f);
                return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription5);
            }
            BasicRendererDescription basicRendererDescription = new BasicRendererDescription(0.0f, f10, 0.0f, f += (float)JNRUtils.size(size, 1, 0, 0));
            BasicRendererDescription basicRendererDescription6 = new BasicRendererDescription(0.0f, f11, 0.0f, f);
            return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription6);
        }
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSpinnerArrowsRendererDescription(@NotNull SpinnerArrowsConfiguration spinnerArrowsConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getGroupBoxRendererDescription(@NotNull GroupBoxConfiguration groupBoxConfiguration) {
        return new BasicRendererDescription(-3.0f, -2.0f, 6.0f, 6.0f);
    }

    @Override
    @NotNull
    public RendererDescription getListBoxRendererDescription(@NotNull ListBoxConfiguration listBoxConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getTextFieldRendererDescription(@NotNull TextFieldConfiguration textFieldConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getScrollBarRendererDescription(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getScrollColumnSizerRendererDescription(@NotNull ScrollColumnSizerConfiguration scrollColumnSizerConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getProgressIndicatorRendererDescription(@NotNull ProgressIndicatorConfiguration progressIndicatorConfiguration) {
        AquaUIPainter.ProgressWidget progressWidget = progressIndicatorConfiguration.getWidget();
        AquaUIPainter.Orientation orientation = progressIndicatorConfiguration.getOrientation();
        int n = JNRPlatformUtils.getPlatformVersion();
        if (progressWidget == AquaUIPainter.ProgressWidget.BAR) {
            if (orientation == AquaUIPainter.Orientation.HORIZONTAL) {
                return n >= 101600 ? new BasicRendererDescription(0.0f, -0.51f, 0.0f, 1.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 1.0f);
            }
            return n >= 101600 ? new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f) : new BasicRendererDescription(0.0f, -1.0f, 1.0f, 2.0f);
        }
        if (progressWidget == AquaUIPainter.ProgressWidget.SPINNER) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getIndeterminateProgressIndicatorRendererDescription(@NotNull IndeterminateProgressIndicatorConfiguration indeterminateProgressIndicatorConfiguration) {
        AquaUIPainter.ProgressWidget progressWidget = indeterminateProgressIndicatorConfiguration.getWidget();
        AquaUIPainter.Orientation orientation = indeterminateProgressIndicatorConfiguration.getOrientation();
        AquaUIPainter.Size size = indeterminateProgressIndicatorConfiguration.getSize();
        if (progressWidget == AquaUIPainter.ProgressWidget.INDETERMINATE_BAR) {
            if (orientation == AquaUIPainter.Orientation.HORIZONTAL) {
                return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 1.0f);
            }
            return new BasicRendererDescription(0.0f, -1.0f, 1.0f, 2.0f);
        }
        if (progressWidget == AquaUIPainter.ProgressWidget.INDETERMINATE_SPINNER) {
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getTableColumnHeaderRendererDescription(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getGradientRendererDescription(@NotNull GradientConfiguration gradientConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    protected RendererDescription createVertical(float f, float f2) {
        return new BasicRendererDescription(0.0f, f, 0.0f, f2);
    }

    @NotNull
    protected RendererDescription createVertical(float f, float f2, float f3) {
        BasicRendererDescription basicRendererDescription = new BasicRendererDescription(0.0f, f, 0.0f, f3);
        BasicRendererDescription basicRendererDescription2 = new BasicRendererDescription(0.0f, f2, 0.0f, f3);
        return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription2);
    }

    @NotNull
    protected AquaUIPainter.ButtonWidget toCanonicalButtonStyle(AquaUIPainter.ButtonWidget buttonWidget) {
        return buttonWidget;
    }

    protected int pos(@NotNull AquaUIPainter.Position position, int n, int n2, int n3) {
        switch (position) {
            case FIRST: {
                return n;
            }
            case LAST: {
                return n2;
            }
            case ONLY: {
                return n3;
            }
        }
        return 0;
    }

    protected int pos(@NotNull AquaUIPainter.Position position, int n, int n2, int n3, int n4) {
        switch (position) {
            case FIRST: {
                return n;
            }
            case MIDDLE: {
                return n2;
            }
            case LAST: {
                return n3;
            }
            case ONLY: {
                return n4;
            }
        }
        return 0;
    }

    protected float pos(@NotNull AquaUIPainter.Position position, float f, float f2, float f3) {
        switch (position) {
            case FIRST: {
                return f;
            }
            case LAST: {
                return f2;
            }
            case ONLY: {
                return f3;
            }
        }
        return 0.0f;
    }

    protected float pos(@NotNull AquaUIPainter.Position position, float f, float f2, float f3, float f4) {
        switch (position) {
            case FIRST: {
                return f;
            }
            case MIDDLE: {
                return f2;
            }
            case LAST: {
                return f3;
            }
            case ONLY: {
                return f4;
            }
        }
        return 0.0f;
    }
}

