/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.RendererDescriptionsBase;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class CoreUIRendererDescriptions
extends RendererDescriptionsBase {
    @Override
    @NotNull
    public RendererDescription getSplitPaneDividerRendererDescription(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        AquaUIPainter.DividerWidget dividerWidget = splitPaneDividerConfiguration.getWidget();
        AquaUIPainter.Orientation orientation = splitPaneDividerConfiguration.getOrientation();
        switch (splitPaneDividerConfiguration.getWidget()) {
            case THIN_DIVIDER: 
            case THICK_DIVIDER: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
            }
            case PANE_SPLITTER: {
                return orientation == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public RendererDescription getButtonRendererDescription(@NotNull ButtonConfiguration buttonConfiguration) {
        int n = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.ButtonWidget buttonWidget = this.toCanonicalButtonStyle(buttonConfiguration.getButtonWidget());
        AquaUIPainter.Size size = buttonConfiguration.getSize();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: 
                case MINI: {
                    return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, -0.49f, 0.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 4.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) {
            if ((buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) && size == AquaUIPainter.Size.LARGE && n >= 101600) {
                return new BasicRendererDescription(-5.0f, -1.0f, 10.0f, 2.0f);
            }
            if (n >= 101100) {
                BasicRendererDescription basicRendererDescription = new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f);
                BasicRendererDescription basicRendererDescription2 = new BasicRendererDescription(-0.5f, -1.0f, 1.0f, 2.0f);
                return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription2);
            }
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return super.getButtonRendererDescription(buttonConfiguration);
    }

    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        int n = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        RendererDescription rendererDescription = super.getSegmentedButtonRendererDescription(segmentedButtonConfiguration);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: 
            case BUTTON_SEGMENTED_SLIDER: {
                if (n >= 101600 && segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    f4 = JNRUtils.size(size, -4, -1, -1, -1);
                    f5 = JNRUtils.size(size, 4, 1, 1, 1);
                    f6 = JNRUtils.size(size, 4, 1, 1, 1);
                    f3 = JNRUtils.size(size, -1, -1, -1, -3);
                    break;
                }
                if (n >= 101500 && segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
                    f2 = position == AquaUIPainter.Position.MIDDLE ? 0.0f : (float)JNRUtils.size(size, -2, -2, -1);
                    f5 = JNRUtils.size(size, 2, 2, 1);
                    f6 = JNRUtils.size(size, 2, 2, 1);
                    f3 = JNRUtils.size2D(size, 0.0, -1.0, 0.51);
                    f7 = JNRUtils.size(size, 0, 0, -5);
                    break;
                }
                if (n >= 101400 && segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
                    f2 = position == AquaUIPainter.Position.MIDDLE ? 0.0f : (float)JNRUtils.size(size, -2, -2, -1);
                    f5 = JNRUtils.size(size, 2, 2, 1);
                    f6 = JNRUtils.size(size, 2, 2, 1);
                    f3 = JNRUtils.size2D(size, 0.0, -0.49, 0.51);
                    f7 = JNRUtils.size(size, 0, -2, -5);
                    break;
                }
                if (n >= 101300 && segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    f2 = -0.49f;
                    f4 = JNRUtils.size2D(size, -2.0f, -2.0f, -1.0f);
                    f = 1.0f;
                    f5 = JNRUtils.size(size, 2, 2, 1);
                    f6 = JNRUtils.size2D(size, 1.49, 1.49, 1.0);
                    f3 = JNRUtils.size2D(size, 0.0, -0.98, 0.51);
                    f7 = JNRUtils.size(size, -1, -2, -5);
                    break;
                }
                if (n >= 101200 && segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    f2 = -0.49f;
                    f4 = JNRUtils.size2D(size, -2.0f, -2.0f, -1.0f);
                    f = 1.0f;
                    f5 = JNRUtils.size(size, 2, 2, 1);
                    f6 = JNRUtils.size2D(size, 1.49, 1.49, 0.49);
                    f3 = JNRUtils.size2D(size, 0.0, -1.98, 0.51);
                    f7 = JNRUtils.size(size, 0, 0, -5);
                    break;
                }
                f3 = JNRUtils.size2D(size, -0.51f, -1.49f, -2.0f);
                f4 = JNRUtils.size(size, -5, -2, -2, -1);
                f5 = JNRUtils.size(size, 5, 2, 2, 1);
                f6 = JNRUtils.size(size, 4, 2, 2, 1);
                if (!this.shouldUseSpecialSeparatedDescription(segmentedButtonConfiguration)) break;
                rendererDescription = this.getSegmentedSeparatedRendererDescription(segmentedButtonConfiguration, rendererDescription, f3, f4);
                f3 = 0.0f;
                f4 = 0.0f;
                break;
            }
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                f3 = JNRUtils.size2D(size, -1.0, 0.0, -0.49f, -1.49f);
                f4 = JNRUtils.size(size, -6, -1, -1, -1);
                f5 = JNRUtils.size(size, 6, 1, 1, 1);
                f6 = JNRUtils.size(size, 5, 1, 1, 1);
                f7 = JNRUtils.size(size, -1, 0, 0, 0);
                if (!this.shouldUseSpecialSeparatedDescription(segmentedButtonConfiguration)) break;
                rendererDescription = this.getSegmentedSeparatedRendererDescription(segmentedButtonConfiguration, rendererDescription, f3, f4);
                f3 = 0.0f;
                f4 = 0.0f;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                f3 = JNRUtils.size2D(size, -1.0f, -1.51f, -2.0f);
                f4 = -1.0f;
                f5 = 1.0f;
                f6 = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                if (n >= 101600) {
                    if (!segmentedButtonWidget.isToolbar()) {
                        int n2;
                        int n3 = n2 = segmentedButtonConfiguration.getPosition() == AquaUIPainter.Position.FIRST ? -1 : 0;
                        if (!segmentedButtonWidget.isSeparated()) {
                            return new BasicRendererDescription(n2, 0.0f, 1.0f, 0.0f);
                        }
                        return new BasicRendererDescription(n2, 0.0f, 2.0f, 1.0f);
                    }
                    if (segmentedButtonWidget.isSeparated()) {
                        if (size == AquaUIPainter.Size.LARGE) {
                            AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
                            int n4 = position == AquaUIPainter.Position.FIRST || position == AquaUIPainter.Position.ONLY ? -6 : 0;
                            AquaUIPainter.State state = segmentedButtonConfiguration.getState();
                            int n5 = state == AquaUIPainter.State.PRESSED || state == AquaUIPainter.State.ROLLOVER || segmentedButtonConfiguration.isSelected() ? -6 : 0;
                            BasicRendererDescription basicRendererDescription = new BasicRendererDescription(n4, n5, 0.0f, 11.0f);
                            return this.adjustSegmentedRendererDescription(segmentedButtonConfiguration, basicRendererDescription, 0.0f, 0.0f, 0.0f, 0.0f, 6.0f, 5.0f, 0.0f);
                        }
                        AquaUIPainter.State state = segmentedButtonConfiguration.getState();
                        int n6 = segmentedButtonConfiguration.isSelected() && state != AquaUIPainter.State.PRESSED && state != AquaUIPainter.State.ROLLOVER ? -2 : -1;
                        return new BasicRendererDescription(-1.0f, n6, 1.0f, 3.0f);
                    }
                    if (size == AquaUIPainter.Size.LARGE) {
                        return new BasicRendererDescription(-6.0f, 0.0f, 11.0f, 0.0f);
                    }
                    int n7 = segmentedButtonConfiguration.getPosition() == AquaUIPainter.Position.FIRST ? -1 : 0;
                    boolean bl = segmentedButtonConfiguration.getPosition() == AquaUIPainter.Position.FIRST;
                    return new BasicRendererDescription(n7, 0.0f, (float)bl, 0.0f);
                }
                if (size == AquaUIPainter.Size.MINI) {
                    rendererDescription = this.createVertical(0.0f, 4.0f);
                }
                float f8 = n >= 101100 ? (segmentedButtonWidget.isToolbar() ? -0.49f : -1.49f) : -1.0f;
                f3 = JNRUtils.size2D(size, 0.0f, f8, -2.0f);
                if (!segmentedButtonWidget.isSeparated()) break;
                return this.getTexturedSeparatedRendererDescription(segmentedButtonConfiguration, rendererDescription, f3);
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                f3 = -1.0f;
                f7 = JNRUtils.size(size, 0, -1, -2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.adjustSegmentedRendererDescription(segmentedButtonConfiguration, rendererDescription, f, f2, f3, f4, f5, f6, f7);
    }

    protected boolean shouldUseSpecialSeparatedDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        if (segmentedButtonConfiguration.getPosition() == AquaUIPainter.Position.ONLY) {
            return false;
        }
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
            return true;
        }
        return segmentedButtonConfiguration.isSelected() && segmentedButtonWidget.isSlider();
    }

    @NotNull
    protected RendererDescription getTexturedSeparatedRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription, float f) {
        float f2 = 0.0f;
        float f3 = -0.5f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = segmentedButtonConfiguration.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        boolean bl2 = segmentedButtonConfiguration.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        if (position == AquaUIPainter.Position.FIRST) {
            if (!bl2) {
                f2 = 1.0f;
                f3 = 0.5f;
            } else {
                f3 = 0.0f;
            }
        } else if (position == AquaUIPainter.Position.MIDDLE) {
            if (bl2 && !bl) {
                f3 = 0.5f;
                f5 = -0.5f;
            } else if (bl && !bl2) {
                f2 = 1.0f;
                f3 = 0.5f;
            } else if (!bl && !bl2) {
                f2 = 1.0f;
                f3 = 1.0f;
                f5 = -0.5f;
            } else {
                f3 = 0.0f;
            }
        } else if (position == AquaUIPainter.Position.LAST) {
            if (!bl) {
                f3 = 0.5f;
                f5 = -0.5f;
            } else {
                f3 = 0.0f;
            }
        }
        RendererDescription rendererDescription2 = this.adjustSegmentedRendererDescription(segmentedButtonConfiguration, rendererDescription, f2, f4, f, 0.0f, 0.0f, 0.0f, 0.0f);
        RendererDescription rendererDescription3 = this.adjustSegmentedRendererDescription(segmentedButtonConfiguration, rendererDescription, f3, f5, f, 0.0f, 0.0f, 0.0f, 0.0f);
        return new MultiResolutionRendererDescription(rendererDescription2, rendererDescription3);
    }

    @NotNull
    protected RendererDescription getSegmentedSeparatedRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription, float f, float f2) {
        boolean bl = segmentedButtonConfiguration.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        boolean bl2 = segmentedButtonConfiguration.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        float f3 = bl2 ? 2.0f : 2.5f;
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        if (position != AquaUIPainter.Position.FIRST) {
            if (position == AquaUIPainter.Position.MIDDLE) {
                f2 = 0.0f;
                f3 = 0.51f;
                if (bl2 && !bl) {
                    f2 = -0.49f;
                    f3 = 0.49f;
                } else if (bl && bl2) {
                    f3 = 0.0f;
                } else if (!bl && !bl2) {
                    f3 = 1.0f;
                    f2 = -0.49f;
                }
            } else if (position == AquaUIPainter.Position.LAST) {
                f3 = 2.0f;
                f2 = bl ? 0.0f : -0.49f;
            }
        }
        try {
            return JNRUtils.adjustRendererDescription(rendererDescription, f2, f, f3, 0.0f);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + segmentedButtonConfiguration);
            return rendererDescription;
        }
    }

    @Override
    @NotNull
    public RendererDescription getComboBoxRendererDescription(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxConfiguration.getWidget();
        AquaUIPainter.Size size = comboBoxConfiguration.getSize();
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -3.0f, 2.0f, 3.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -3.0f, 2.0f, 3.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, -1.5f, 2.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (size) {
            case LARGE: 
            case REGULAR: {
                return new BasicRendererDescription(-0.5f, 0.0f, 2.0f, 1.0f);
            }
            case SMALL: {
                return new BasicRendererDescription(-0.5f, 0.0f, 1.0f, 0.0f);
            }
            case MINI: {
                return new BasicRendererDescription(-0.5f, -0.51f, 2.0f, 1.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getPopupButtonRendererDescription(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        AquaUIPainter.Size size = popupButtonConfiguration.getSize();
        if (popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        return super.getPopupButtonRendererDescription(popupButtonConfiguration);
    }

    @Nullable
    public RendererDescription getPopUpArrowRendererDescription(@NotNull PopupButtonConfiguration popupButtonConfiguration, @NotNull AquaUIPainter.Size size) {
        float f = JNRUtils.size2D(size, 1.0f, 0.0f, 2.0f);
        float f2 = JNRUtils.size2D(size, 3.0f, 1.0f, 1.0f);
        int n = JNRUtils.size(size, 1, 0, 1);
        int n2 = JNRUtils.size(size, 3, 1, 0);
        return new BasicRendererDescription(-f, -f2, n, n2);
    }

    @NotNull
    public RendererDescription getPullDownArrowRendererDescription(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public RendererDescription getScrollBarThumbRendererDescription(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        int n;
        int n2 = n = scrollBarConfiguration.getWidget() == AquaUIPainter.ScrollBarWidget.LEGACY ? 2 : 1;
        if (scrollBarConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL) {
            return new BasicRendererDescription(0.0f, n, 0.0f, -2 * n);
        }
        return new BasicRendererDescription(n, 0.0f, -2 * n, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderThumbRendererDescription(@NotNull SliderConfiguration sliderConfiguration) {
        if (!sliderConfiguration.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderThumbRendererDescription(sliderConfiguration);
        }
        return this.getSlider11ThumbRendererDescription(sliderConfiguration);
    }

    @NotNull
    private RendererDescription getSlider11ThumbRendererDescription(@NotNull SliderConfiguration sliderConfiguration) {
        AquaUIPainter.Size size = sliderConfiguration.getSize();
        float f = sliderConfiguration.hasTickMarks() ? JNRUtils.size2D(size, 3.5, 0.0, 0.0) : JNRUtils.size2D(size, 4.0f, 0.0f, 0.0f);
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderTickMarkRendererDescription(@NotNull SliderConfiguration sliderConfiguration) {
        if (!sliderConfiguration.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderTickMarkRendererDescription(sliderConfiguration);
        }
        AquaUIPainter.Size size = sliderConfiguration.getSize();
        float f = sliderConfiguration.hasTickMarks() ? JNRUtils.size2D(size, 4.0f, 0.0f, 0.0f) : 0.0f;
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, f);
    }
}

