/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.GenericButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class PopupButtonConfiguration
extends PopupButtonLayoutConfiguration
implements GenericButtonConfiguration {
    @NotNull
    private final AquaUIPainter.State state;

    public PopupButtonConfiguration(@NotNull AquaUIPainter.PopupButtonWidget popupButtonWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.UILayoutDirection uILayoutDirection) {
        super(popupButtonWidget, size, uILayoutDirection);
        if (state.isInactive() && !PopupButtonConfiguration.isSensitiveToInactiveState(popupButtonWidget)) {
            state = state.toActive();
        }
        this.state = state;
    }

    public PopupButtonConfiguration(@NotNull PopupButtonLayoutConfiguration popupButtonLayoutConfiguration, @NotNull AquaUIPainter.State state) {
        this(popupButtonLayoutConfiguration.getPopupButtonWidget(), popupButtonLayoutConfiguration.getSize(), state, popupButtonLayoutConfiguration.getLayoutDirection());
    }

    @Override
    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    @Override
    public boolean isTextured() {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = this.getPopupButtonWidget();
        return popupButtonWidget.isTextured();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PopupButtonConfiguration popupButtonConfiguration = (PopupButtonConfiguration)object;
        return this.state == popupButtonConfiguration.state;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state});
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + " " + (Object)((Object)this.state);
    }

    private static boolean isSensitiveToInactiveState(@NotNull AquaUIPainter.PopupButtonWidget popupButtonWidget) {
        int n = JNRPlatformUtils.getPlatformVersion();
        if (popupButtonWidget.isDefault()) {
            return true;
        }
        if (popupButtonWidget.isTextured()) {
            return n < 101500;
        }
        return false;
    }
}

