/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import com.apple.eawt.Application;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.Aqua8MultiResolutionImage;
import org.violetlib.aqua.Aqua8MultiResolutionImage2;
import org.violetlib.aqua.Aqua8PopupFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaPopupFactory;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.JavaSupport;
import sun.awt.image.MultiResolutionImage;
import sun.awt.image.SunWritableRaster;
import sun.java2d.opengl.OGLRenderQueue;
import sun.swing.SwingUtilities2;

public class Java8Support
implements JavaSupport.JavaSupportImpl {
    private static final WeakHashMap<Graphics, Integer> scaleMap = new WeakHashMap();
    private static final AquaUtils.RecyclableSingleton<Method> getJComponentGetFlagMethod = new AquaUtils.RecyclableSingleton<Method>(){

        @Override
        protected Method getInstance() {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method method = JComponent.class.getDeclaredMethod("getFlag", Integer.TYPE);
                        method.setAccessible(true);
                        return method;
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
            });
        }
    };
    private static final Integer OPAQUE_SET_FLAG = 24;

    @Override
    public int getScaleFactor(Graphics graphics) {
        int n;
        Integer n2 = scaleMap.get(graphics);
        if (n2 != null) {
            return n2;
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            n = Java8Support.getScaleFactor(graphicsConfiguration);
        } else {
            n = 1;
        }
        scaleMap.put(graphics, n);
        return n;
    }

    private static int getScaleFactor(GraphicsConfiguration graphicsConfiguration) {
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        Object object = null;
        try {
            Field field = graphicsDevice.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                object = field.get(graphicsDevice);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 1;
    }

    @Override
    public boolean hasOpaqueBeenExplicitlySet(JComponent jComponent) {
        Method method = getJComponentGetFlagMethod.get();
        if (method == null) {
            return false;
        }
        try {
            return Boolean.TRUE.equals(method.invoke((Object)jComponent, OPAQUE_SET_FLAG));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public Image getDockIconImage() {
        return Application.getApplication().getDockIconImage();
    }

    @Override
    public void drawString(JComponent jComponent, Graphics2D graphics2D, String string, float f, float f2) {
        SwingUtilities2.drawString(jComponent, (Graphics)graphics2D, string, (int)f, (int)f2);
    }

    @Override
    public void drawStringUnderlineCharAt(JComponent jComponent, Graphics2D graphics2D, String string, int n, float f, float f2) {
        SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics2D, string, n, (int)f, (int)f2);
    }

    @Override
    public String getClippedString(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        return SwingUtilities2.clipStringIfNecessary(jComponent, fontMetrics, string, n);
    }

    @Override
    public float getStringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return SwingUtilities2.stringWidth(jComponent, fontMetrics, string);
    }

    @Override
    public void installAATextInfo(UIDefaults uIDefaults) {
        SwingUtilities2.AATextInfo aATextInfo = SwingUtilities2.AATextInfo.getAATextInfo((boolean)true);
        uIDefaults.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aATextInfo);
    }

    @Override
    public AquaMultiResolutionImage createMultiResolutionImage(BufferedImage bufferedImage) {
        return new Aqua8MultiResolutionImage(bufferedImage);
    }

    @Override
    public AquaMultiResolutionImage createMultiResolutionImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return new Aqua8MultiResolutionImage2(bufferedImage, bufferedImage2);
    }

    @Override
    @NotNull
    public AquaMultiResolutionImage createImage(int n, int n2, int[] nArray, float f) {
        BufferedImage bufferedImage = this.createImage(n, n2, nArray);
        int n3 = (int)((float)n / f);
        int n4 = (int)((float)n2 / f);
        return new Aqua8MultiResolutionImage(n3, n4, bufferedImage);
    }

    @Override
    public Image applyFilter(Image image, ImageFilter imageFilter) {
        return Aqua8MultiResolutionImage.apply(image, imageFilter);
    }

    @Override
    public Image applyMapper(Image image, Function<Image, Image> function) {
        return Aqua8MultiResolutionImage.apply(image, function);
    }

    @Override
    public Image applyMapper(Image image, AquaMultiResolutionImage.Mapper mapper) {
        return Aqua8MultiResolutionImage.apply(image, mapper);
    }

    @Override
    @NotNull
    public Image getResolutionVariant(@NotNull Image image, double d, double d2) {
        if (image instanceof MultiResolutionImage) {
            MultiResolutionImage multiResolutionImage = (MultiResolutionImage)image;
            return multiResolutionImage.getResolutionVariant((int)d, (int)d2);
        }
        return image;
    }

    @Override
    @NotNull
    public BufferedImage createImage(int n, int n2, int[] nArray) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = SunWritableRaster.stealData(dataBufferInt, 0);
        System.arraycopy(nArray, 0, nArray2, 0, n * n2);
        SunWritableRaster.markDirty(dataBufferInt);
        return bufferedImage;
    }

    @Override
    public void preload(Image image, final int n) {
        Class<?> clazz;
        String string;
        if (n != 0 && (string = (clazz = image.getClass()).getName()).endsWith("ToolkitImage")) {
            try {
                Method method = clazz.getMethod("preload", ImageObserver.class);
                ImageObserver imageObserver = new ImageObserver(){
                    int flags;
                    {
                        this.flags = n;
                    }

                    @Override
                    public boolean imageUpdate(Image image, int n6, int n2, int n3, int n4, int n5) {
                        this.flags &= ~n6;
                        return this.flags != 0 && (n6 & 0xC0) == 0;
                    }
                };
                method.invoke((Object)image, imageObserver);
            }
            catch (Exception exception) {
                AquaUtils.logError("Unable to preload image", exception);
            }
        }
    }

    @Override
    public void lockRenderQueue() {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
    }

    @Override
    public void unlockRenderQueue() {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.unlock();
    }

    @Override
    public AquaPopupFactory createPopupFactory() {
        return new Aqua8PopupFactory();
    }
}

