/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaUtils;

public class AquaTextComponentSupport {
    @NotNull
    public static View getRootView(@NotNull JTextComponent jTextComponent) {
        BasicTextUI basicTextUI = AquaUtils.getUI(jTextComponent, BasicTextUI.class);
        if (basicTextUI != null) {
            return basicTextUI.getRootView(jTextComponent);
        }
        throw new IllegalArgumentException("Unsupported text component");
    }

    public static void updateFocusTraversalKeys(@NotNull JTextComponent jTextComponent, @Nullable EditorKit editorKit) {
        if (editorKit instanceof DefaultEditorKit) {
            Set<AWTKeyStroke> set = jTextComponent.getFocusTraversalKeys(0);
            Set<AWTKeyStroke> set2 = jTextComponent.getFocusTraversalKeys(1);
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
            HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(set2);
            if (jTextComponent.isEditable()) {
                hashSet.remove(KeyStroke.getKeyStroke(9, 0));
                hashSet2.remove(KeyStroke.getKeyStroke(9, 1));
            } else {
                hashSet.add(KeyStroke.getKeyStroke(9, 0));
                hashSet2.add(KeyStroke.getKeyStroke(9, 1));
            }
            LookAndFeel.installProperty(jTextComponent, "focusTraversalKeysForward", hashSet);
            LookAndFeel.installProperty(jTextComponent, "focusTraversalKeysBackward", hashSet2);
        }
    }

    public static int getBaseline(View view, int n, int n2) {
        if (AquaTextComponentSupport.hasParagraph(view)) {
            view.setSize(n, n2);
            return AquaTextComponentSupport.getBaseline(view, new Rectangle(0, 0, n, n2));
        }
        return -1;
    }

    private static int getBaseline(View view, Shape shape) {
        if (view.getViewCount() == 0) {
            return -1;
        }
        AttributeSet attributeSet = view.getElement().getAttributes();
        Object object = null;
        if (attributeSet != null) {
            object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        }
        int n = 0;
        if (object == HTML.Tag.HTML && view.getViewCount() > 1) {
            ++n;
        }
        if ((shape = view.getChildAllocation(n, shape)) == null) {
            return -1;
        }
        View view2 = view.getView(n);
        if (view instanceof ParagraphView) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            return rectangle.y + (int)((float)rectangle.height * view2.getAlignment(1));
        }
        return AquaTextComponentSupport.getBaseline(view2, shape);
    }

    private static boolean hasParagraph(View view) {
        if (view instanceof ParagraphView) {
            return true;
        }
        if (view.getViewCount() == 0) {
            return false;
        }
        AttributeSet attributeSet = view.getElement().getAttributes();
        Object object = null;
        if (attributeSet != null) {
            object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        }
        int n = 0;
        if (object == HTML.Tag.HTML && view.getViewCount() > 1) {
            n = 1;
        }
        return AquaTextComponentSupport.hasParagraph(view.getView(n));
    }

    public static String displayPropertiesToCSS(Font font, Color color) {
        StringBuilder stringBuilder = new StringBuilder("body {");
        if (font != null) {
            stringBuilder.append(" font-family: ");
            stringBuilder.append(font.getFamily());
            stringBuilder.append(" ; ");
            stringBuilder.append(" font-size: ");
            stringBuilder.append(font.getSize());
            stringBuilder.append("pt ;");
            if (font.isBold()) {
                stringBuilder.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                stringBuilder.append(" font-style: italic ; ");
            }
        }
        if (color != null) {
            stringBuilder.append(" color: #");
            if (color.getRed() < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(color.getRed()));
            if (color.getGreen() < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(color.getGreen()));
            if (color.getBlue() < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(color.getBlue()));
            stringBuilder.append(" ; ");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

