/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import org.violetlib.aqua.AquaDragRecognitionSupport;
import org.violetlib.aqua.GenericList;

public class AquaListMouseBehavior
extends MouseInputAdapter {
    protected GenericList list;
    protected final int OP_SELECT = 1;
    protected final int OP_INTERVAL = 2;
    protected final int OP_TOGGLE = 3;
    protected int targetIndex;
    protected boolean dragWouldTransfer;
    protected int mouseReleaseOp;
    protected int mouseDragOp;
    protected boolean isMultipleSelection;
    protected int mouseDragOpPreviousIndex;
    protected MouseEvent armedEvent;
    protected int dragThreshold;
    protected boolean isDragging;

    public AquaListMouseBehavior(GenericList genericList) {
        this.list = genericList;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 501) {
            this.mousePressed(mouseEvent);
        } else if (n == 502) {
            this.mouseReleased(mouseEvent);
        } else if (n == 506) {
            this.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.armedEvent = mouseEvent;
        this.dragThreshold = DragSource.getDragThreshold();
        this.list.requestFocus();
        this.mouseReleaseOp = 0;
        this.mouseDragOp = 0;
        this.targetIndex = -1;
        this.dragWouldTransfer = false;
        this.isDragging = false;
        if (!this.list.isEnabled() || mouseEvent.isPopupTrigger()) {
            return;
        }
        this.isMultipleSelection = this.list.isMultipleSelection();
        this.interpretLocation(mouseEvent);
        int n = this.getSelectionOperation(mouseEvent);
        if (this.targetIndex < 0) {
            this.mousePressedOutsideCell(n);
        }
        this.mouseDragOpPreviousIndex = this.targetIndex;
        if (n != 0) {
            if (this.isMousePressedOperation(n)) {
                this.performSelectionOperation(n);
            } else {
                this.mouseReleaseOp = n;
            }
            if (!this.dragWouldTransfer) {
                this.mouseDragOp = n;
            }
        }
        this.list.setValueIsAdjusting(this.mouseDragOp != 0);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        TransferHandler transferHandler;
        int n;
        if (this.armedEvent == null) {
            return;
        }
        if (this.list.isDragEnabled() && (n = AquaDragRecognitionSupport.mapDragOperationFromModifiers(mouseEvent, transferHandler = this.list.getTransferHandler())) != 0 && !this.list.isRowSelected(this.targetIndex)) {
            this.setSelectionInterval(this.targetIndex, this.targetIndex);
        }
        if (!this.isDragging) {
            int n2 = Math.abs(mouseEvent.getX() - this.armedEvent.getX());
            boolean bl = this.isDragging = Math.sqrt(n2 * n2 + (n = Math.abs(mouseEvent.getY() - this.armedEvent.getY())) * n) > (double)this.dragThreshold;
        }
        if (this.isDragging) {
            this.mouseReleaseOp = 0;
            if (this.mouseDragOp != 0) {
                this.targetIndex = this.getIndex(mouseEvent);
                if (this.targetIndex != -1 && this.targetIndex != this.mouseDragOpPreviousIndex) {
                    this.list.scrollToViewRows(this.targetIndex, this.targetIndex);
                    if (!this.isMultipleSelection) {
                        this.performSelectionOperation(1);
                    } else {
                        int n3 = this.getAnchor();
                        if (this.targetIndex > n3 && this.targetIndex > this.mouseDragOpPreviousIndex) {
                            this.performDragSelectionOperation(this.mouseDragOp, this.mouseDragOpPreviousIndex + 1, this.targetIndex, true);
                        } else if (this.targetIndex < n3 && this.targetIndex < this.mouseDragOpPreviousIndex) {
                            this.performDragSelectionOperation(this.mouseDragOp, this.mouseDragOpPreviousIndex - 1, this.targetIndex, true);
                        } else if (this.targetIndex >= n3 && this.targetIndex < this.mouseDragOpPreviousIndex) {
                            this.performDragSelectionOperation(this.mouseDragOp, this.targetIndex + 1, this.mouseDragOpPreviousIndex, false);
                        } else if (this.targetIndex <= n3 && this.targetIndex > this.mouseDragOpPreviousIndex) {
                            this.performDragSelectionOperation(this.mouseDragOp, this.targetIndex - 1, this.mouseDragOpPreviousIndex, false);
                        }
                    }
                    this.mouseDragOpPreviousIndex = this.targetIndex;
                }
            } else if (this.list.isDragEnabled() && (n = AquaDragRecognitionSupport.mapDragOperationFromModifiers(mouseEvent, transferHandler = this.list.getTransferHandler())) != 0) {
                transferHandler.exportAsDrag(this.list.getComponent(), this.armedEvent, n);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseReleaseOp != 0) {
            this.performSelectionOperation(this.mouseReleaseOp);
            this.mouseReleaseOp = 0;
        }
        this.list.setValueIsAdjusting(false);
    }

    protected int getSelectionOperation(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x1900) == 256) {
            return 3;
        }
        if ((n & 0x1840) == 64) {
            return 2;
        }
        if ((mouseEvent.getModifiersEx() & 0x140) == 0) {
            return 1;
        }
        return 0;
    }

    protected boolean isMousePressedOperation(int n) {
        if (n == 1) {
            return !this.dragWouldTransfer;
        }
        if (n == 2) {
            return true;
        }
        if (n == 3) {
            return !this.list.isRowSelected(this.targetIndex) || !this.dragWouldTransfer;
        }
        return true;
    }

    protected void interpretLocation(MouseEvent mouseEvent) {
        this.targetIndex = this.getIndex(mouseEvent);
        this.dragWouldTransfer = this.list.isDragEnabled();
    }

    protected int getIndex(MouseEvent mouseEvent) {
        return this.list.identifyRowAtLocation(mouseEvent.getPoint());
    }

    protected void mousePressedOutsideCell(int n) {
        this.list.clearSelection();
        if (n == 3) {
            n = 1;
        }
        if (n == 1) {
            int n2 = this.list.getRowCount() - 1;
            this.list.setAnchorSelectionIndex(n2);
        } else {
            this.list.setAnchorSelectionIndex(0);
        }
        this.dragWouldTransfer = false;
    }

    protected void performSelectionOperation(int n) {
        if (this.targetIndex < 0) {
            return;
        }
        if (n == 2 && !this.isMultipleSelection) {
            n = 1;
        }
        if (n == 3) {
            this.toggleSelection(this.targetIndex);
        } else if (n == 2) {
            int n2 = this.getAnchor();
            this.selectInterval(n2, this.targetIndex);
        } else if (n == 1) {
            this.setSelectionInterval(this.targetIndex, this.targetIndex);
        }
    }

    protected void performDragSelectionOperation(int n, int n2, int n3, boolean bl) {
        if (!this.isMultipleSelection) {
            this.setSelectionInterval(this.targetIndex, this.targetIndex);
            return;
        }
        if (n == 3) {
            int n4 = this.getAnchor();
            this.toggleSelectionInterval(n2, n3);
            this.list.setAnchorSelectionIndex(n4);
        } else if (n == 2 || n == 1) {
            int n5 = this.getAnchor();
            this.setSelectionInterval(n5, this.targetIndex);
        }
    }

    protected void toggleSelection(int n) {
        if (this.list.isRowSelected(n)) {
            int n2 = this.getAnchor();
            this.removeSelectionInterval(n, n);
            if (n == n2) {
                this.updateAnchor(n2);
            } else {
                this.list.setAnchorSelectionIndex(n2);
            }
        } else {
            this.addSelectionInterval(n, n);
            this.list.setAnchorSelectionIndex(n);
        }
    }

    protected void selectInterval(int n, int n2) {
        this.list.setValueIsAdjusting(true);
        int n3 = n2 - n;
        this.trimSelectedInterval(n, -n3);
        if (this.list.isRowSelected(n2)) {
            this.trimSelectedInterval(n2, n3);
        } else {
            this.addSelectionInterval(n, n2);
        }
        this.list.setAnchorSelectionIndex(n);
        this.list.setValueIsAdjusting(false);
    }

    protected int getAnchor() {
        int n = this.list.getAnchorSelectionIndex();
        return Math.max(0, n);
    }

    protected void updateAnchor(int n) {
        int n2;
        int n3 = this.list.getRowCount();
        for (n2 = n + 1; n2 < n3; ++n2) {
            if (!this.list.isRowSelected(n2)) continue;
            this.list.setAnchorSelectionIndex(n2);
            return;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            if (!this.list.isRowSelected(n2)) continue;
            this.list.setAnchorSelectionIndex(n2);
            return;
        }
        this.list.setAnchorSelectionIndex(0);
    }

    protected void trimSelectedInterval(int n, int n2) {
        block3: {
            block2: {
                if (n2 <= 0) break block2;
                int n3 = this.list.getRowCount();
                while (++n < n3 && this.list.isRowSelected(n)) {
                    this.list.removeSelectionInterval(n, n);
                }
                break block3;
            }
            if (n2 >= 0) break block3;
            while (--n >= 0 && this.list.isRowSelected(n)) {
                this.list.removeSelectionInterval(n, n);
            }
        }
    }

    protected void setSelectionInterval(int n, int n2) {
        this.list.setSelectionInterval(n, n2);
    }

    protected void addSelectionInterval(int n, int n2) {
        this.list.addSelectionInterval(n, n2);
    }

    protected void removeSelectionInterval(int n, int n2) {
        this.list.removeSelectionInterval(n, n2);
    }

    protected void toggleSelectionInterval(int n, int n2) {
        int n3 = n > n2 ? -1 : 1;
        int n4 = n;
        while (true) {
            if (!this.list.isRowSelected(n4)) {
                this.list.addSelectionInterval(n4, n4);
            } else {
                this.list.removeSelectionInterval(n4, n4);
            }
            if (n4 == n2) {
                return;
            }
            n4 += n3;
        }
    }
}

