/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicAquaAppearance;
import org.violetlib.aqua.Colors;
import org.violetlib.aqua.EffectName;
import org.violetlib.aqua.Logger;
import org.violetlib.vappearances.VAppearance;

public class AquaAppearance
extends BasicAquaAppearance {
    public AquaAppearance(@NotNull VAppearance vAppearance, @NotNull Colors colors, @NotNull Logger logger) {
        super(vAppearance, colors, logger);
    }

    @Override
    @Nullable
    public Color getColor(@NotNull String string) {
        Color color = super.getColor(string);
        if (AquaColors.isDebugging()) {
            AquaUtils.logDebug("  Color " + string + ": " + AquaColors.toString(color));
        }
        return color;
    }

    @Nullable
    public Color getColorForEffect(@NotNull String string, @NotNull EffectName effectName) {
        if (effectName == EffectName.EFFECT_NONE) {
            return this.getColor(string);
        }
        String string2 = string + "_" + effectName;
        Color color = this.getColor(string2);
        if (color != null) {
            return color;
        }
        return this.getColor(string);
    }

    @Nullable
    public Color getColorForOptionalEffect(@NotNull String string, @NotNull EffectName effectName) {
        if (effectName == EffectName.EFFECT_NONE) {
            return this.getColor(string);
        }
        String string2 = string + "_" + effectName;
        Color color = this.getColor(string2);
        return color != null ? color : this.getColor(string);
    }
}

