/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl.jrs;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.violetlib.jnr.impl.jrs.JRSUIConstants;
import org.violetlib.jnr.impl.jrs.JRSUIState;

public final class JRSUIControl {
    private static final int INCOHERENT = 2;
    private static final int NOT_INIT = 1;
    private static final int SUCCESS = 0;
    private static final int NULL_PTR = -1;
    private static final int NULL_CG_REF = -2;
    private static int nativeJRSInitialized = 1;
    private static final int NIO_BUFFER_SIZE = 128;
    private static final ThreadLocal<ThreadLocalByteBuffer> threadLocal = new ThreadLocal();
    private final HashMap<JRSUIConstants.Key, JRSUIConstants.DoubleValue> nativeMap;
    private final HashMap<JRSUIConstants.Key, JRSUIConstants.DoubleValue> changes;
    private long cfDictionaryPtr;
    private long priorEncodedProperties;
    private long currentEncodedProperties;
    private final boolean flipped;

    private static native int initNativeJRSUI();

    private static native long getPtrOfBuffer(ByteBuffer var0);

    private static native long getCFDictionary(boolean var0);

    private static native void disposeCFDictionary(long var0);

    private static native int syncChanges(long var0, long var2);

    private static native int paintToCGContext(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14);

    private static native int paintChangesToCGContext(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14, long var16);

    private static native int paintImage(int[] var0, int var1, int var2, long var3, long var5, long var7, double var9, double var11, double var13, double var15);

    private static native int paintChangesImage(int[] var0, int var1, int var2, long var3, long var5, long var7, double var9, double var11, double var13, double var15, long var17);

    private static native int getNativeHitPart(long var0, long var2, long var4, double var6, double var8, double var10, double var12, double var14, double var16);

    private static native void getNativePartBounds(double[] var0, long var1, long var3, long var5, double var7, double var9, double var11, double var13, int var15);

    private static native double getNativeScrollBarOffsetChange(long var0, long var2, long var4, double var6, double var8, double var10, double var12, int var14, int var15, int var16);

    public static void initJRSUI() {
        if (nativeJRSInitialized == 0) {
            return;
        }
        nativeJRSInitialized = JRSUIControl.initNativeJRSUI();
        if (nativeJRSInitialized != 0) {
            throw new RuntimeException("JRSUI could not be initialized (" + nativeJRSInitialized + ").");
        }
    }

    private static ThreadLocalByteBuffer getThreadLocalBuffer() {
        ThreadLocalByteBuffer threadLocalByteBuffer = threadLocal.get();
        if (threadLocalByteBuffer != null) {
            return threadLocalByteBuffer;
        }
        threadLocalByteBuffer = new ThreadLocalByteBuffer();
        threadLocal.set(threadLocalByteBuffer);
        return threadLocalByteBuffer;
    }

    public JRSUIControl(boolean bl) {
        this.flipped = bl;
        this.cfDictionaryPtr = JRSUIControl.getCFDictionary(bl);
        if (this.cfDictionaryPtr == 0L) {
            throw new RuntimeException("Unable to create native representation");
        }
        this.nativeMap = new HashMap();
        this.changes = new HashMap();
    }

    JRSUIControl(JRSUIControl jRSUIControl) {
        this.flipped = jRSUIControl.flipped;
        this.cfDictionaryPtr = JRSUIControl.getCFDictionary(this.flipped);
        if (this.cfDictionaryPtr == 0L) {
            throw new RuntimeException("Unable to create native representation");
        }
        this.nativeMap = new HashMap();
        this.changes = new HashMap<JRSUIConstants.Key, JRSUIConstants.DoubleValue>(jRSUIControl.nativeMap);
        this.changes.putAll(jRSUIControl.changes);
    }

    protected synchronized void finalize() throws Throwable {
        if (this.cfDictionaryPtr == 0L) {
            return;
        }
        JRSUIControl.disposeCFDictionary(this.cfDictionaryPtr);
        this.cfDictionaryPtr = 0L;
    }

    private BufferState loadBufferWithChanges(ThreadLocalByteBuffer threadLocalByteBuffer) {
        ByteBuffer byteBuffer = threadLocalByteBuffer.buffer;
        ((Buffer)byteBuffer).rewind();
        for (JRSUIConstants.Key key : new HashSet<JRSUIConstants.Key>(this.changes.keySet())) {
            int n = byteBuffer.position();
            JRSUIConstants.DoubleValue doubleValue = this.changes.get(key);
            try {
                byteBuffer.putLong(key.getConstantPtr());
                byteBuffer.put(doubleValue.getTypeCode());
                doubleValue.putValueInBuffer(byteBuffer);
            }
            catch (BufferOverflowException bufferOverflowException) {
                return this.handleBufferOverflow(byteBuffer, n);
            }
            catch (RuntimeException runtimeException) {
                System.err.println(this);
                throw runtimeException;
            }
            if (byteBuffer.position() >= 120) {
                return this.handleBufferOverflow(byteBuffer, n);
            }
            this.changes.remove(key);
            this.nativeMap.put(key, doubleValue);
        }
        byteBuffer.putLong(0L);
        return BufferState.ALL_CHANGES_IN_BUFFER;
    }

    private BufferState handleBufferOverflow(ByteBuffer byteBuffer, int n) {
        if (n == 0) {
            byteBuffer.putLong(0, 0L);
            return BufferState.CHANGE_WONT_FIT_IN_BUFFER;
        }
        byteBuffer.putLong(n, 0L);
        return BufferState.SOME_CHANGES_IN_BUFFER;
    }

    private synchronized void set(JRSUIConstants.Key key, JRSUIConstants.DoubleValue doubleValue) {
        JRSUIConstants.DoubleValue doubleValue2 = this.nativeMap.get(key);
        if (doubleValue2 != null && doubleValue2.equals(doubleValue)) {
            this.changes.remove(key);
            return;
        }
        this.changes.put(key, doubleValue);
    }

    public void set(JRSUIState jRSUIState) {
        jRSUIState.apply(this);
    }

    void setEncodedState(long l) {
        this.currentEncodedProperties = l;
    }

    void set(JRSUIConstants.Key key, double d) {
        this.set(key, new JRSUIConstants.DoubleValue(d));
    }

    public void paint(int[] nArray, int n, int n2, double d, double d2, double d3, double d4) {
        this.paintImage(nArray, n, n2, d, d2, d3, d4);
        this.priorEncodedProperties = this.currentEncodedProperties;
    }

    private synchronized int paintImage(int[] nArray, int n, int n2, double d, double d2, double d3, double d4) {
        if (this.changes.isEmpty()) {
            return JRSUIControl.paintImage(nArray, n, n2, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, d, d2, d3, d4);
        }
        ThreadLocalByteBuffer threadLocalByteBuffer = JRSUIControl.getThreadLocalBuffer();
        BufferState bufferState = this.loadBufferWithChanges(threadLocalByteBuffer);
        if (bufferState == BufferState.ALL_CHANGES_IN_BUFFER) {
            return JRSUIControl.paintChangesImage(nArray, n, n2, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, d, d2, d3, d4, threadLocalByteBuffer.ptr);
        }
        while (bufferState == BufferState.SOME_CHANGES_IN_BUFFER) {
            int n3 = JRSUIControl.syncChanges(this.cfDictionaryPtr, threadLocalByteBuffer.ptr);
            if (n3 != 0) {
                throw new RuntimeException("JRSUI failed to sync changes into the native buffer: " + this);
            }
            bufferState = this.loadBufferWithChanges(threadLocalByteBuffer);
        }
        if (bufferState == BufferState.CHANGE_WONT_FIT_IN_BUFFER) {
            throw new RuntimeException("JRSUI failed to sync changes to the native buffer, because some change was too big: " + this);
        }
        return JRSUIControl.paintChangesImage(nArray, n, n2, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, d, d2, d3, d4, threadLocalByteBuffer.ptr);
    }

    public void paint(long l, double d, double d2, double d3, double d4) {
        this.paintToCGContext(l, d, d2, d3, d4);
        this.priorEncodedProperties = this.currentEncodedProperties;
    }

    private synchronized int paintToCGContext(long l, double d, double d2, double d3, double d4) {
        if (this.changes.isEmpty()) {
            return JRSUIControl.paintToCGContext(l, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, d, d2, d3, d4);
        }
        ThreadLocalByteBuffer threadLocalByteBuffer = JRSUIControl.getThreadLocalBuffer();
        BufferState bufferState = this.loadBufferWithChanges(threadLocalByteBuffer);
        if (bufferState == BufferState.ALL_CHANGES_IN_BUFFER) {
            return JRSUIControl.paintChangesToCGContext(l, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, d, d2, d3, d4, threadLocalByteBuffer.ptr);
        }
        while (bufferState == BufferState.SOME_CHANGES_IN_BUFFER) {
            int n = JRSUIControl.syncChanges(this.cfDictionaryPtr, threadLocalByteBuffer.ptr);
            if (n != 0) {
                throw new RuntimeException("JRSUI failed to sync changes into the native buffer: " + this);
            }
            bufferState = this.loadBufferWithChanges(threadLocalByteBuffer);
        }
        if (bufferState == BufferState.CHANGE_WONT_FIT_IN_BUFFER) {
            throw new RuntimeException("JRSUI failed to sync changes to the native buffer, because some change was too big: " + this);
        }
        return JRSUIControl.paintChangesToCGContext(l, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, d, d2, d3, d4, threadLocalByteBuffer.ptr);
    }

    JRSUIConstants.Hit getHitForPoint(int n, int n2, int n3, int n4, int n5, int n6) {
        this.sync();
        JRSUIConstants.Hit hit = JRSUIConstants.getHit(JRSUIControl.getNativeHitPart(this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, n, n2, n3, n4, n5, 2 * n2 + n4 - n6));
        this.priorEncodedProperties = this.currentEncodedProperties;
        return hit;
    }

    void getPartBounds(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        if (dArray == null) {
            throw new NullPointerException("Cannot load null rect");
        }
        if (dArray.length != 4) {
            throw new IllegalArgumentException("Rect must have four elements");
        }
        this.sync();
        JRSUIControl.getNativePartBounds(dArray, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, n, n2, n3, n4, n5);
        this.priorEncodedProperties = this.currentEncodedProperties;
    }

    double getScrollBarOffsetChange(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.sync();
        double d = JRSUIControl.getNativeScrollBarOffsetChange(this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, n, n2, n3, n4, n5, n6, n7);
        this.priorEncodedProperties = this.currentEncodedProperties;
        return d;
    }

    private void sync() {
        if (this.changes.isEmpty()) {
            return;
        }
        ThreadLocalByteBuffer threadLocalByteBuffer = JRSUIControl.getThreadLocalBuffer();
        BufferState bufferState = this.loadBufferWithChanges(threadLocalByteBuffer);
        if (bufferState == BufferState.ALL_CHANGES_IN_BUFFER) {
            int n = JRSUIControl.syncChanges(this.cfDictionaryPtr, threadLocalByteBuffer.ptr);
            if (n != 0) {
                throw new RuntimeException("JRSUI failed to sync changes into the native buffer: " + this);
            }
            return;
        }
        while (bufferState == BufferState.SOME_CHANGES_IN_BUFFER) {
            int n = JRSUIControl.syncChanges(this.cfDictionaryPtr, threadLocalByteBuffer.ptr);
            if (n != 0) {
                throw new RuntimeException("JRSUI failed to sync changes into the native buffer: " + this);
            }
            bufferState = this.loadBufferWithChanges(threadLocalByteBuffer);
        }
        if (bufferState == BufferState.CHANGE_WONT_FIT_IN_BUFFER) {
            throw new RuntimeException("JRSUI failed to sync changes to the native buffer, because some change was too big: " + this);
        }
    }

    public int hashCode() {
        int n = (int)(this.currentEncodedProperties ^ this.currentEncodedProperties >>> 32);
        n ^= this.nativeMap.hashCode();
        return n ^= this.changes.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JRSUIControl)) {
            return false;
        }
        JRSUIControl jRSUIControl = (JRSUIControl)object;
        if (this.currentEncodedProperties != jRSUIControl.currentEncodedProperties) {
            return false;
        }
        if (!this.nativeMap.equals(jRSUIControl.nativeMap)) {
            return false;
        }
        return this.changes.equals(jRSUIControl.changes);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("JRSUIControl[inNative:");
        stringBuilder.append(Arrays.toString(this.nativeMap.entrySet().toArray()));
        stringBuilder.append(", changes:");
        stringBuilder.append(Arrays.toString(this.changes.entrySet().toArray()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static class ThreadLocalByteBuffer {
        final ByteBuffer buffer = ByteBuffer.allocateDirect(128);
        final long ptr;

        public ThreadLocalByteBuffer() {
            this.buffer.order(ByteOrder.nativeOrder());
            this.ptr = JRSUIControl.getPtrOfBuffer(this.buffer);
        }
    }

    static enum BufferState {
        NO_CHANGE,
        ALL_CHANGES_IN_BUFFER,
        SOME_CHANGES_IN_BUFFER,
        CHANGE_WONT_FIT_IN_BUFFER;

    }
}

