/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AnimatedButtonConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.LinearSliderRenderer;
import org.violetlib.jnr.aqua.impl.PopupRenderer;
import org.violetlib.jnr.aqua.impl.TitleBarRendererBase;
import org.violetlib.jnr.aqua.jrs.JRSRenderedPainter;
import org.violetlib.jnr.aqua.jrs.JRSRenderer;
import org.violetlib.jnr.aqua.jrs.JRSRendererDescriptions;
import org.violetlib.jnr.aqua.jrs.JRSRendererMaker;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;
import org.violetlib.jnr.impl.jrs.JRSUIConstants;
import org.violetlib.jnr.impl.jrs.JRSUIControl;
import org.violetlib.jnr.impl.jrs.JRSUIState;
import org.violetlib.vappearances.VAppearance;

public class JRSPainter
extends AquaUIPainterBase {
    protected final JRSRendererMaker maker;
    @NotNull
    private static final JRSRendererDescriptions rendererDescriptions = new JRSRendererDescriptions();

    public JRSPainter() throws UnsupportedOperationException {
        super(rendererDescriptions);
        try {
            JRSUIControl.initJRSUI();
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Unable to initialize the native library: " + exception);
        }
        this.maker = new JRSRendererMaker();
    }

    @Override
    @NotNull
    public JRSPainter copy() {
        return new JRSPainter();
    }

    @Override
    @NotNull
    protected Painter getPainter(@NotNull Configuration configuration, @NotNull VAppearance vAppearance, @NotNull Renderer renderer, float f, float f2) {
        JRSUIState jRSUIState;
        JRSRenderer jRSRenderer;
        BasicRenderer basicRenderer = renderer.getBasicRenderer();
        if (basicRenderer instanceof JRSRenderer && !(jRSRenderer = (JRSRenderer)basicRenderer).isAnimating() && (jRSUIState = jRSRenderer.getControlState()) != null) {
            return new JRSRenderedPainter(jRSUIState, vAppearance, renderer, f, f2);
        }
        return super.getPainter(configuration, vAppearance, renderer, f, f2);
    }

    protected void configureSize(@NotNull AquaUIPainter.Size size) {
        switch (size) {
            case REGULAR: {
                this.maker.set(JRSUIConstants.Size.REGULAR);
                break;
            }
            case SMALL: {
                this.maker.set(JRSUIConstants.Size.SMALL);
                break;
            }
            case MINI: {
                this.maker.set(JRSUIConstants.Size.MINI);
                break;
            }
            case LARGE: {
                this.maker.set(JRSUIConstants.Size.LARGE);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void configureState(@NotNull AquaUIPainter.State state) {
        switch (state) {
            case ACTIVE: {
                this.maker.set(JRSUIConstants.State.ACTIVE);
                break;
            }
            case INACTIVE: {
                this.maker.setProperty(JRSUIConstants.State.INACTIVE);
                break;
            }
            case DISABLED: 
            case DISABLED_INACTIVE: {
                this.maker.setProperty(JRSUIConstants.State.DISABLED);
                break;
            }
            case PRESSED: {
                this.maker.setProperty(JRSUIConstants.State.PRESSED);
                break;
            }
            case ACTIVE_DEFAULT: {
                this.maker.setProperty(JRSUIConstants.State.PULSED);
                break;
            }
            case ROLLOVER: {
                this.maker.setProperty(JRSUIConstants.State.ROLLOVER);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void configureLayoutDirection(@NotNull AquaUIPainter.UILayoutDirection uILayoutDirection) {
    }

    protected void configureOrientation(@NotNull AquaUIPainter.Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                this.maker.set(JRSUIConstants.Orientation.HORIZONTAL);
                break;
            }
            case VERTICAL: {
                this.maker.set(JRSUIConstants.Orientation.VERTICAL);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void configureDirection(@NotNull AquaUIPainter.Direction direction) {
        switch (direction) {
            case NONE: {
                this.maker.set(JRSUIConstants.Direction.NONE);
                break;
            }
            case UP: {
                this.maker.set(JRSUIConstants.Direction.UP);
                break;
            }
            case DOWN: {
                this.maker.set(JRSUIConstants.Direction.DOWN);
                break;
            }
            case LEFT: {
                this.maker.set(JRSUIConstants.Direction.LEFT);
                break;
            }
            case RIGHT: {
                this.maker.set(JRSUIConstants.Direction.RIGHT);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration buttonConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = this.toCanonicalButtonStyle(buttonConfiguration.getButtonWidget());
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            if (buttonConfiguration.getButtonState() != AquaUIPainter.ButtonState.ON) {
                return NULL_RENDERER;
            }
            ToolBarItemWellConfiguration toolBarItemWellConfiguration = new ToolBarItemWellConfiguration(buttonConfiguration.getState(), true);
            return this.getToolBarItemWellRenderer(toolBarItemWellConfiguration);
        }
        RendererDescription rendererDescription = rendererDescriptions.getButtonRendererDescription(buttonConfiguration);
        this.maker.reset();
        AquaUIPainter.State state = buttonConfiguration.getState();
        AquaUIPainter.ButtonState buttonState = buttonConfiguration.getButtonState();
        boolean bl = false;
        switch (buttonWidget) {
            case BUTTON_PUSH: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH);
                break;
            }
            case BUTTON_BEVEL: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL);
                break;
            }
            case BUTTON_BEVEL_ROUND: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_ROUND);
                break;
            }
            case BUTTON_CHECK_BOX: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_CHECK_BOX);
                break;
            }
            case BUTTON_RADIO: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_RADIO);
                break;
            }
            case BUTTON_DISCLOSURE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_DISCLOSURE);
                break;
            }
            case BUTTON_HELP: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_ROUND_HELP);
                break;
            }
            case BUTTON_GRADIENT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_INSET);
                break;
            }
            case BUTTON_RECESSED: {
                if (!this.shouldPaintRecessedBackground(state, buttonState)) {
                    return NULL_RENDERER;
                }
                bl = true;
                state = this.adjustRecessedState(state);
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_SCOPE);
                break;
            }
            case BUTTON_INLINE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_INSET2);
                break;
            }
            case BUTTON_ROUNDED_RECT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_INSET);
                break;
            }
            case BUTTON_TEXTURED: 
            case BUTTON_TEXTURED_TOOLBAR: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_TEXTURED);
                break;
            }
            case BUTTON_ROUND: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_ROUND);
                break;
            }
            case BUTTON_ROUND_INSET: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_ROUND_INSET);
                break;
            }
            case BUTTON_ROUND_TEXTURED: 
            case BUTTON_ROUND_TOOLBAR: {
                throw new UnsupportedOperationException();
            }
            case BUTTON_DISCLOSURE_TRIANGLE: {
                this.maker.set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                break;
            }
            case BUTTON_PUSH_INSET2: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_INSET2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (state == AquaUIPainter.State.ROLLOVER && !bl) {
            state = AquaUIPainter.State.ACTIVE;
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            if (buttonState == AquaUIPainter.ButtonState.ON && (state == AquaUIPainter.State.ACTIVE || state == AquaUIPainter.State.INACTIVE)) {
                state = AquaUIPainter.State.PRESSED;
            }
            buttonState = AquaUIPainter.ButtonState.STATELESS;
        }
        if (buttonState == AquaUIPainter.ButtonState.STATELESS && !buttonWidget.isTextured()) {
            if (state == AquaUIPainter.State.INACTIVE) {
                state = AquaUIPainter.State.ACTIVE;
            } else if (state == AquaUIPainter.State.DISABLED_INACTIVE) {
                state = AquaUIPainter.State.DISABLED;
            }
        }
        this.configureSize(buttonConfiguration.getSize());
        this.configureState(state);
        this.maker.set(JRSUIConstants.AlignmentVertical.CENTER);
        this.maker.set(JRSUIConstants.AlignmentHorizontal.CENTER);
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            AnimatedButtonConfiguration animatedButtonConfiguration;
            AquaUIPainter.ButtonState buttonState2;
            switch (buttonConfiguration.getButtonState()) {
                case ON: {
                    this.maker.set(JRSUIConstants.Direction.DOWN);
                    break;
                }
                case OFF: {
                    this.maker.set(buttonConfiguration.getLayoutDirection() == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT ? JRSUIConstants.Direction.RIGHT : JRSUIConstants.Direction.LEFT);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            int n = -1;
            if (buttonConfiguration instanceof AnimatedButtonConfiguration && (buttonState2 = (animatedButtonConfiguration = (AnimatedButtonConfiguration)buttonConfiguration).getPreviousButtonState()) != buttonState) {
                n = 1 + Math.round(2.0f * animatedButtonConfiguration.getTransition());
                if (buttonState == AquaUIPainter.ButtonState.OFF) {
                    n = 4 - n;
                }
                this.maker.set(buttonConfiguration.getLayoutDirection() == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT ? JRSUIConstants.Direction.RIGHT : JRSUIConstants.Direction.LEFT);
            }
            this.maker.setAnimationFrame(n);
        } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            this.maker.set(buttonState == AquaUIPainter.ButtonState.OFF ? JRSUIConstants.Direction.DOWN : JRSUIConstants.Direction.UP);
        } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            switch (buttonState) {
                case ON: {
                    this.maker.setValue(1.0);
                    break;
                }
                case OFF: {
                    this.maker.setValue(0.0);
                    break;
                }
                case MIXED: {
                    this.maker.setValue(2.0);
                    break;
                }
                case STATELESS: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getTableColumnHeaderRendererDescription(tableColumnHeaderConfiguration);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.BUTTON_LIST_HEADER);
        this.maker.set(tableColumnHeaderConfiguration.isSelected() ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        this.maker.set(tableColumnHeaderConfiguration.isFocused() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        this.configureState(tableColumnHeaderConfiguration.getState());
        switch (tableColumnHeaderConfiguration.getSortArrowDirection()) {
            case UP: {
                this.maker.set(JRSUIConstants.Direction.UP);
                break;
            }
            case DOWN: {
                this.maker.set(JRSUIConstants.Direction.DOWN);
                break;
            }
            case NONE: {
                this.maker.set(JRSUIConstants.Direction.NONE);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getScrollColumnSizerRenderer(@NotNull ScrollColumnSizerConfiguration scrollColumnSizerConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getScrollColumnSizerRendererDescription(scrollColumnSizerConfiguration);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.SCROLL_COLUMN_SIZER);
        this.configureState(scrollColumnSizerConfiguration.getState());
        this.maker.set(JRSUIConstants.AlignmentVertical.CENTER);
        this.maker.set(JRSUIConstants.AlignmentHorizontal.CENTER);
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getScrollBarRendererDescription(scrollBarConfiguration);
        RendererDescription rendererDescription2 = rendererDescriptions.getScrollBarThumbRendererDescription(scrollBarConfiguration);
        AquaUIPainter.State state = scrollBarConfiguration.getState();
        this.maker.reset();
        switch (scrollBarConfiguration.getWidget()) {
            case LEGACY: {
                this.maker.set(JRSUIConstants.Widget.SCROLL_BAR);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.configureSize(scrollBarConfiguration.getSize());
        this.configureState(state == AquaUIPainter.State.ACTIVE ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE);
        this.configureOrientation(scrollBarConfiguration.getOrientation());
        Renderer renderer = null;
        Renderer renderer2 = null;
        if (!scrollBarConfiguration.isTrackSuppressed()) {
            this.maker.set(JRSUIConstants.NothingToScroll.YES);
            this.maker.set(JRSUIConstants.ScrollBarPart.NONE);
            renderer = Renderer.create(this.maker.getRenderer(), rendererDescription);
        }
        if (state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.DISABLED_INACTIVE && scrollBarConfiguration.getKnobWidget() != AquaUIPainter.ScrollBarKnobWidget.NONE) {
            this.maker.set(JRSUIConstants.NothingToScroll.NO);
            this.maker.setValue(scrollBarConfiguration.getThumbPosition());
            this.maker.setThumbStart(scrollBarConfiguration.getThumbPosition());
            this.maker.setThumbPercent(scrollBarConfiguration.getThumbExtent());
            this.maker.set(JRSUIConstants.ShowArrows.NO);
            if (state == AquaUIPainter.State.PRESSED) {
                this.maker.set(JRSUIConstants.ScrollBarPart.THUMB);
            } else {
                this.maker.set(JRSUIConstants.ScrollBarPart.NONE);
            }
            this.maker.set(scrollBarConfiguration.isTrackSuppressed() ? JRSUIConstants.IndicatorOnly.YES : JRSUIConstants.IndicatorOnly.NO);
            renderer2 = Renderer.create(this.maker.getRenderer(), rendererDescription2);
        }
        return Renderer.createCompositeRenderer(renderer, renderer2);
    }

    @Override
    @NotNull
    protected Renderer getToolBarItemWellRenderer(@NotNull ToolBarItemWellConfiguration toolBarItemWellConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getToolBarItemWellRendererDescription(toolBarItemWellConfiguration);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.TOOLBAR_ITEM_WELL);
        this.configureState(toolBarItemWellConfiguration.getState());
        this.maker.set(toolBarItemWellConfiguration.isFrameOnly() ? JRSUIConstants.FrameOnly.YES : JRSUIConstants.FrameOnly.NO);
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration groupBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getGroupBoxRendererDescription(groupBoxConfiguration);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.FRAME_GROUP_BOX);
        this.configureState(groupBoxConfiguration.getState());
        this.maker.set(groupBoxConfiguration.isFrameOnly() ? JRSUIConstants.FrameOnly.YES : JRSUIConstants.FrameOnly.NO);
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getListBoxRenderer(@NotNull ListBoxConfiguration listBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getListBoxRendererDescription(listBoxConfiguration);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.FRAME_LIST_BOX);
        this.configureState(listBoxConfiguration.getState());
        this.maker.set(listBoxConfiguration.isFrameOnly() ? JRSUIConstants.FrameOnly.YES : JRSUIConstants.FrameOnly.NO);
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getTextFieldRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getTextFieldRendererDescription(textFieldConfiguration);
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldConfiguration.getWidget();
        JRSUIConstants.Widget widget = this.getWidget(textFieldWidget);
        if (widget != null) {
            this.maker.reset();
            this.maker.set(widget);
            this.configureSize(textFieldConfiguration.getSize());
            this.configureState(textFieldConfiguration.getState());
            return Renderer.create(this.maker.getRenderer(), rendererDescription);
        }
        if (textFieldWidget.isSearch()) {
            Insetter insetter = uiLayout.getSearchButtonPaintingInsets(textFieldConfiguration);
            Insetter insetter2 = textFieldWidget.hasCancel() ? uiLayout.getCancelButtonPaintingInsets(textFieldConfiguration) : null;
            return new SearchFieldRenderer(textFieldConfiguration, insetter, insetter2);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    private JRSUIConstants.Widget getWidget(@NotNull AquaUIPainter.TextFieldWidget textFieldWidget) {
        switch (textFieldWidget) {
            case TEXT_FIELD_ROUND: 
            case TEXT_FIELD_ROUND_TOOLBAR: {
                return JRSUIConstants.Widget.FRAME_TEXT_FIELD_ROUND;
            }
            case TEXT_FIELD: {
                return JRSUIConstants.Widget.FRAME_TEXT_FIELD;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Renderer getSearchFieldFindButtonRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldConfiguration.getWidget();
        boolean bl = textFieldWidget.hasMenu();
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_FIND);
        if (bl) {
            this.maker.set(JRSUIConstants.Variant.MENU_GLYPH);
        }
        this.configureSize(textFieldConfiguration.getSize());
        this.configureState(textFieldConfiguration.getState());
        BasicRenderer basicRenderer = this.maker.getRenderer();
        RendererDescription rendererDescription = this.getSearchFieldFindButtonRendererDescription(textFieldConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected RendererDescription getSearchFieldFindButtonRendererDescription(@NotNull TextFieldConfiguration textFieldConfiguration) {
        return this.getSearchButtonRendererDescription(textFieldConfiguration);
    }

    @Override
    @NotNull
    public Renderer getSearchFieldCancelButtonRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_CANCEL);
        this.configureSize(textFieldConfiguration.getSize());
        this.configureState(textFieldConfiguration.getState());
        BasicRenderer basicRenderer = this.maker.getRenderer();
        RendererDescription rendererDescription = this.getSearchFieldCancelButtonRendererDescription(textFieldConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected RendererDescription getSearchFieldCancelButtonRendererDescription(@NotNull TextFieldConfiguration textFieldConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getComboBoxRendererDescription(comboBoxConfiguration);
        this.maker.reset();
        switch (comboBoxConfiguration.getWidget()) {
            case BUTTON_COMBO_BOX: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_COMBO_BOX);
                this.maker.set(JRSUIConstants.IndicatorOnly.NO);
                this.maker.set(JRSUIConstants.ArrowsOnly.NO);
                this.maker.set(JRSUIConstants.AlignmentHorizontal.RIGHT);
                this.maker.set(JRSUIConstants.AlignmentVertical.CENTER);
                break;
            }
            case BUTTON_COMBO_BOX_CELL: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        AquaUIPainter.State state = comboBoxConfiguration.getState();
        if (state == AquaUIPainter.State.ROLLOVER) {
            state = AquaUIPainter.State.ACTIVE;
        }
        this.configureSize(comboBoxConfiguration.getSize());
        this.configureState(state);
        this.configureLayoutDirection(comboBoxConfiguration.getLayoutDirection());
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSegmentedButtonRendererDescription(segmentedButtonConfiguration);
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        this.maker.reset();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: {
                this.maker.set(JRSUIConstants.Widget.TAB);
                break;
            }
            case BUTTON_SEGMENTED: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED);
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                position = AquaUIPainter.Position.ONLY;
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_INSET);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_SCURVE);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_TEXTURED);
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_TOOLBAR);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_INSET);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                position = AquaUIPainter.Position.ONLY;
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_TEXTURED);
            }
        }
        switch (position) {
            case FIRST: {
                this.maker.set(JRSUIConstants.SegmentPosition.FIRST);
                break;
            }
            case MIDDLE: {
                this.maker.set(JRSUIConstants.SegmentPosition.MIDDLE);
                break;
            }
            case LAST: {
                this.maker.set(JRSUIConstants.SegmentPosition.LAST);
                break;
            }
            case ONLY: {
                this.maker.set(JRSUIConstants.SegmentPosition.ONLY);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.configureSize(segmentedButtonConfiguration.getSize());
        this.configureState(segmentedButtonConfiguration.getState());
        this.configureDirection(segmentedButtonConfiguration.getDirection());
        this.maker.set(JRSUIConstants.SegmentLeadingSeparator.NO);
        this.maker.set(JRSUIConstants.SegmentTrailingSeparator.YES);
        this.maker.set(segmentedButtonConfiguration.isSelected() ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        this.maker.set(segmentedButtonConfiguration.isFocused() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getPopupButtonRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        Renderer renderer = this.getBasicPopupButtonRenderer(popupButtonConfiguration);
        Renderer renderer2 = this.getPopupArrowRenderer(popupButtonConfiguration);
        Insetter insetter = renderer2 != null ? uiLayout.getPopUpArrowInsets(popupButtonConfiguration) : null;
        return new PopupRenderer(popupButtonConfiguration, renderer, renderer2, insetter);
    }

    @Nullable
    protected Renderer getBasicPopupButtonRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        if (popupButtonConfiguration.isCell()) {
            return null;
        }
        AquaUIPainter.State state = popupButtonConfiguration.getState();
        RendererDescription rendererDescription = rendererDescriptions.getPopupButtonRendererDescription(popupButtonConfiguration);
        this.maker.reset();
        boolean bl = false;
        switch (popupButtonConfiguration.getPopupButtonWidget()) {
            case BUTTON_POP_DOWN: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_POP_DOWN);
                break;
            }
            case BUTTON_POP_UP: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_POP_UP);
                break;
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_ROUND);
                break;
            }
            case BUTTON_POP_DOWN_ROUND_RECT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_POP_DOWN_INSET);
                break;
            }
            case BUTTON_POP_UP_ROUND_RECT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_POP_UP_INSET);
                break;
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                if (state != AquaUIPainter.State.ROLLOVER && state != AquaUIPainter.State.PRESSED) {
                    return null;
                }
                bl = true;
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_SCOPE);
                break;
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_TEXTURED);
                break;
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_INSET);
                break;
            }
            case BUTTON_POP_DOWN_SQUARE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL);
                break;
            }
            case BUTTON_POP_UP_SQUARE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (state == AquaUIPainter.State.ROLLOVER && !bl) {
            state = AquaUIPainter.State.ACTIVE;
        }
        this.maker.set(JRSUIConstants.IndicatorOnly.NO);
        this.maker.set(JRSUIConstants.ArrowsOnly.NO);
        this.maker.set(JRSUIConstants.AlignmentHorizontal.CENTER);
        this.configureSize(popupButtonConfiguration.getSize());
        this.configureState(state);
        this.configureLayoutDirection(popupButtonConfiguration.getLayoutDirection());
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        AquaUIPainter.State state = popupButtonConfiguration.getState();
        switch (popupButtonWidget) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return null;
            }
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_UP_CELL: {
                if (state != AquaUIPainter.State.ROLLOVER) break;
                state = AquaUIPainter.State.ACTIVE;
            }
        }
        if (!popupButtonConfiguration.isPopUp()) {
            return null;
        }
        this.maker.reset();
        this.maker.set(popupButtonConfiguration.isPopUp() ? JRSUIConstants.Widget.BUTTON_POP_UP_SQUARE : JRSUIConstants.Widget.BUTTON_POP_DOWN_SQUARE);
        this.maker.set(JRSUIConstants.IndicatorOnly.YES);
        this.maker.set(JRSUIConstants.ArrowsOnly.YES);
        this.maker.set(JRSUIConstants.AlignmentHorizontal.RIGHT);
        this.configureSize(popupButtonConfiguration.getSize());
        this.configureState(state);
        this.configureLayoutDirection(popupButtonConfiguration.getLayoutDirection());
        BasicRenderer basicRenderer = this.maker.getRenderer();
        JRSRendererDescriptions jRSRendererDescriptions = rendererDescriptions;
        AquaUIPainter.Size size = popupButtonConfiguration.getSize();
        RendererDescription rendererDescription = jRSRendererDescriptions.getPopUpArrowRendererDescription(popupButtonConfiguration, size);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getTitleBarRenderer(@NotNull TitleBarConfiguration titleBarConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getTitleBarRendererDescription(titleBarConfiguration);
        Insetter insetter = uiLayout.getTitleBarButtonInsets(titleBarConfiguration, AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX);
        Insetter insetter2 = uiLayout.getTitleBarButtonInsets(titleBarConfiguration, AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX);
        Insetter insetter3 = uiLayout.getTitleBarButtonInsets(titleBarConfiguration, AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX);
        return new TitleBarRenderer(titleBarConfiguration, rendererDescription, insetter, insetter2, insetter3);
    }

    @NotNull
    public Renderer getTitleBarButtonRenderer(@NotNull TitleBarConfiguration titleBarConfiguration, @NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
        AquaUIPainter.State state;
        JRSUIConstants.Widget widget;
        switch (titleBarButtonWidget) {
            case CLOSE_BOX: {
                widget = JRSUIConstants.Widget.TITLE_BAR_CLOSE_BOX;
                state = titleBarConfiguration.getCloseButtonState();
                break;
            }
            case MINIMIZE_BOX: {
                widget = JRSUIConstants.Widget.TITLE_BAR_COLLAPSE_BOX;
                state = titleBarConfiguration.getMinimizeButtonState();
                break;
            }
            case RESIZE_BOX: {
                widget = JRSUIConstants.Widget.TITLE_BAR_ZOOM_BOX;
                state = titleBarConfiguration.getResizeButtonState();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        AquaUIPainter.TitleBarWidget titleBarWidget = titleBarConfiguration.getWidget();
        int n = titleBarWidget == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? -1 : 1;
        this.maker.reset();
        this.maker.set(widget);
        this.maker.set(this.toWindowType(titleBarConfiguration));
        this.maker.set(JRSUIConstants.AlignmentVertical.CENTER);
        this.configureState(state);
        if (titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX) {
            this.maker.set(titleBarConfiguration.isDirty() ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        }
        BasicRenderer basicRenderer = this.maker.getRenderer();
        BasicRendererDescription basicRendererDescription = new BasicRendererDescription(n, 0.0f, 0.0f, 0.0f);
        return Renderer.create(basicRenderer, basicRendererDescription);
    }

    @NotNull
    protected JRSUIConstants.WindowType toWindowType(@NotNull TitleBarConfiguration titleBarConfiguration) {
        switch (titleBarConfiguration.getWidget()) {
            case DOCUMENT_WINDOW: {
                return JRSUIConstants.WindowType.DOCUMENT;
            }
            case UTILITY_WINDOW: {
                return JRSUIConstants.WindowType.UTILITY;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Renderer getIndeterminateProgressIndicatorRenderer(@NotNull IndeterminateProgressIndicatorConfiguration indeterminateProgressIndicatorConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getIndeterminateProgressIndicatorRendererDescription(indeterminateProgressIndicatorConfiguration);
        AquaUIPainter.Size size = indeterminateProgressIndicatorConfiguration.getSize();
        this.maker.reset();
        switch (indeterminateProgressIndicatorConfiguration.getWidget()) {
            case INDETERMINATE_SPINNER: {
                this.maker.set(JRSUIConstants.Widget.PROGRESS_SPINNER);
                if (size == AquaUIPainter.Size.SMALL) break;
                size = AquaUIPainter.Size.LARGE;
                break;
            }
            case INDETERMINATE_BAR: {
                JRSUIConstants.Orientation orientation = indeterminateProgressIndicatorConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
                this.maker.set(JRSUIConstants.Widget.PROGRESS_INDETERMINATE_BAR);
                this.maker.set(orientation);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.configureSize(size);
        this.configureState(indeterminateProgressIndicatorConfiguration.getState());
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getProgressIndicatorRenderer(@NotNull ProgressIndicatorConfiguration progressIndicatorConfiguration) {
        if (progressIndicatorConfiguration.getWidget() == AquaUIPainter.ProgressWidget.SPINNER) {
            throw new UnsupportedOperationException();
        }
        RendererDescription rendererDescription = rendererDescriptions.getProgressIndicatorRendererDescription(progressIndicatorConfiguration);
        JRSUIConstants.Orientation orientation = progressIndicatorConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.PROGRESS_BAR);
        this.maker.set(orientation);
        this.configureSize(progressIndicatorConfiguration.getSize());
        this.configureState(progressIndicatorConfiguration.getState());
        this.maker.setValue(progressIndicatorConfiguration.getValue());
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSliderRendererDescription(sliderConfiguration);
        AquaUIPainter.Size size = sliderConfiguration.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : sliderConfiguration.getSize();
        AquaUIPainter.SliderWidget sliderWidget = sliderConfiguration.getWidget();
        double d = sliderConfiguration.getValue();
        this.maker.reset();
        AquaUIPainter.State state = sliderConfiguration.getState();
        if (state == AquaUIPainter.State.ROLLOVER) {
            state = AquaUIPainter.State.ACTIVE;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            if (state == AquaUIPainter.State.PRESSED) {
                state = AquaUIPainter.State.ACTIVE;
            }
            int n = (int)Math.round(d * 360.0);
            this.maker.reset();
            this.maker.set(JRSUIConstants.Widget.DIAL);
            this.maker.set(JRSUIConstants.Focused.NO);
            this.maker.set(JRSUIConstants.NoIndicator.YES);
            this.configureSize(size);
            this.configureState(state);
            this.maker.setValue(n);
            return Renderer.create(this.maker.getRenderer(), rendererDescription);
        }
        Renderer renderer = this.getSliderTrackRenderer(sliderConfiguration);
        Renderer renderer2 = this.getSliderTickMarkRenderer(sliderConfiguration);
        Renderer renderer3 = this.getSliderThumbRenderer(sliderConfiguration);
        Insetter insetter = uiLayout.getSliderTrackPaintingInsets(sliderConfiguration);
        Insetter insetter2 = uiLayout.getSliderThumbPaintingInsets(sliderConfiguration, sliderConfiguration.getValue());
        boolean bl = this.appearance != null && this.appearance.isDark();
        return new LinearSliderRenderer(sliderConfiguration, renderer, insetter, renderer2, renderer3, insetter2, bl);
    }

    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        return null;
    }

    @NotNull
    protected Renderer getSliderTrackRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        AquaUIPainter.SliderWidget sliderWidget = sliderConfiguration.getWidget();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return NULL_RENDERER;
        }
        AquaUIPainter.Size size = sliderConfiguration.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : sliderConfiguration.getSize();
        AquaUIPainter.State state = sliderConfiguration.getState();
        if (state == AquaUIPainter.State.ROLLOVER) {
            state = AquaUIPainter.State.ACTIVE;
        }
        double d = sliderConfiguration.getValue();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            sliderWidget = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
            d = 1.0 - d;
        } else if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            sliderWidget = AquaUIPainter.SliderWidget.SLIDER_VERTICAL;
            d = 1.0 - d;
        }
        boolean bl = sliderConfiguration.isVertical();
        int n = sliderConfiguration.getNumberOfTickMarks();
        AquaUIPainter.TickMarkPosition tickMarkPosition = sliderConfiguration.getTickMarkPosition();
        JRSUIConstants.Orientation orientation = bl ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
        JRSUIConstants.Direction direction = n > 0 ? this.toDirection(tickMarkPosition) : JRSUIConstants.Direction.NONE;
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.SLIDER);
        this.maker.set(JRSUIConstants.NoIndicator.YES);
        this.configureSize(size);
        this.configureState(state);
        this.maker.set(orientation);
        this.maker.set(direction);
        this.maker.set(sliderConfiguration.isFocused() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        this.maker.setValue(d);
        BasicRenderer basicRenderer = this.maker.getRenderer();
        RendererDescription rendererDescription = rendererDescriptions.getSliderTrackRendererDescription(sliderConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSliderThumbRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        AquaUIPainter.SliderWidget sliderWidget = sliderConfiguration.getWidget();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return NULL_RENDERER;
        }
        AquaUIPainter.Size size = sliderConfiguration.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : sliderConfiguration.getSize();
        AquaUIPainter.State state = sliderConfiguration.getState();
        if (state == AquaUIPainter.State.ROLLOVER) {
            state = AquaUIPainter.State.ACTIVE;
        }
        JRSUIConstants.Orientation orientation = sliderConfiguration.isVertical() ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
        JRSUIConstants.Direction direction = sliderConfiguration.hasTickMarks() ? this.toDirection(sliderConfiguration.getTickMarkPosition()) : JRSUIConstants.Direction.NONE;
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.SLIDER_THUMB);
        this.configureSize(size);
        this.configureState(state);
        this.maker.set(orientation);
        this.maker.set(direction);
        this.maker.set(sliderConfiguration.isFocused() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        this.maker.setValue(sliderConfiguration.getValue());
        BasicRenderer basicRenderer = this.maker.getRenderer();
        RendererDescription rendererDescription = rendererDescriptions.getSliderThumbRendererDescription(sliderConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected JRSUIConstants.Direction toDirection(@NotNull AquaUIPainter.TickMarkPosition tickMarkPosition) {
        switch (tickMarkPosition) {
            case ABOVE: {
                return JRSUIConstants.Direction.UP;
            }
            case BELOW: {
                return JRSUIConstants.Direction.DOWN;
            }
            case LEFT: {
                return JRSUIConstants.Direction.LEFT;
            }
            case RIGHT: {
                return JRSUIConstants.Direction.RIGHT;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Renderer getSpinnerArrowsRenderer(@NotNull SpinnerArrowsConfiguration spinnerArrowsConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSpinnerArrowsRendererDescription(spinnerArrowsConfiguration);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.BUTTON_LITTLE_ARROWS);
        this.configureSize(spinnerArrowsConfiguration.getSize());
        this.configureState(spinnerArrowsConfiguration.getState());
        if (spinnerArrowsConfiguration.getState() == AquaUIPainter.State.PRESSED) {
            this.maker.set(spinnerArrowsConfiguration.isPressedTop() ? JRSUIConstants.BooleanValue.NO : JRSUIConstants.BooleanValue.YES);
        }
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSplitPaneDividerRendererDescription(splitPaneDividerConfiguration);
        this.maker.reset();
        switch (splitPaneDividerConfiguration.getWidget()) {
            case THIN_DIVIDER: {
                this.maker.set(JRSUIConstants.Widget.DIVIDER_SEPARATOR_BAR);
                break;
            }
            case THICK_DIVIDER: {
                throw new UnsupportedOperationException();
            }
            case PANE_SPLITTER: {
                this.maker.set(JRSUIConstants.Widget.DIVIDER_SPLITTER);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.configureState(splitPaneDividerConfiguration.getState());
        this.configureOrientation(splitPaneDividerConfiguration.getOrientation());
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getGradientRenderer(@NotNull GradientConfiguration gradientConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getGradientRendererDescription(gradientConfiguration);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.GRADIENT);
        switch (gradientConfiguration.getWidget()) {
            case GRADIENT_FIND_BAR: 
            case GRADIENT_FINDER_INFO: 
            case GRADIENT_FINDER_SIDE_BAR: 
            case GRADIENT_FREEFORM: {
                throw new UnsupportedOperationException();
            }
            case GRADIENT_LIST_BACKGROUND_EVEN: {
                this.maker.set(JRSUIConstants.Variant.GRADIENT_LIST_BACKGROUND_EVEN);
                break;
            }
            case GRADIENT_LIST_BACKGROUND_ODD: {
                this.maker.set(JRSUIConstants.Variant.GRADIENT_LIST_BACKGROUND_ODD);
                break;
            }
            case GRADIENT_SCOPE_BACKGROUND_BAR: 
            case GRADIENT_SCOPE_BACKGROUND_EVEN: 
            case GRADIENT_SCOPE_BACKGROUND_ODD: {
                throw new UnsupportedOperationException();
            }
            case GRADIENT_SIDE_BAR: {
                this.maker.set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR);
                break;
            }
            case GRADIENT_SIDE_BAR_SELECTION: {
                this.maker.set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR_SELECTION);
                break;
            }
            case GRADIENT_SIDE_BAR_SELECTION_MULTIPLE: {
                throw new UnsupportedOperationException();
            }
        }
        this.maker.set(gradientConfiguration.getState() == AquaUIPainter.State.ACTIVE ? JRSUIConstants.State.ACTIVE : JRSUIConstants.State.INACTIVE);
        return Renderer.create(this.maker.getRenderer(), rendererDescription);
    }

    @NotNull
    public String toString() {
        return "JRS";
    }

    private class SearchFieldRenderer
    extends Renderer {
        @NotNull
        private final TextFieldConfiguration g;
        @Nullable
        private final Insetter searchButtonInsets;
        @Nullable
        private final Insetter cancelButtonInsets;

        public SearchFieldRenderer(@Nullable TextFieldConfiguration textFieldConfiguration, @Nullable Insetter insetter, Insetter insetter2) {
            this.g = textFieldConfiguration;
            this.searchButtonInsets = insetter;
            this.cancelButtonInsets = insetter2;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
            float f = reusableCompositor.getWidth();
            float f2 = reusableCompositor.getHeight();
            JRSPainter.this.maker.reset();
            JRSPainter.this.maker.set(JRSUIConstants.Widget.FRAME_TEXT_FIELD_ROUND);
            JRSPainter.this.configureSize(this.g.getSize());
            JRSPainter.this.configureState(this.g.getState());
            Object object = JRSPainter.this.maker.getRenderer();
            Object object2 = Renderer.create((BasicRenderer)object, new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f));
            reusableCompositor.compose(object2);
            if (this.searchButtonInsets != null) {
                object = JRSPainter.this.getSearchFieldFindButtonRenderer(this.g);
                object2 = this.searchButtonInsets.apply2D(f, f2);
                reusableCompositor.compose(Renderer.createOffsetRenderer((Renderer)object, (Rectangle2D)object2));
            }
            if (this.cancelButtonInsets != null) {
                object = JRSPainter.this.getSearchFieldCancelButtonRenderer(this.g);
                object2 = this.cancelButtonInsets.apply2D(f, f2);
                reusableCompositor.compose(Renderer.createOffsetRenderer((Renderer)object, (Rectangle2D)object2));
            }
        }
    }

    protected class TitleBarRenderer
    extends TitleBarRendererBase {
        public TitleBarRenderer(@NotNull TitleBarConfiguration titleBarConfiguration, @Nullable RendererDescription rendererDescription, @Nullable Insetter insetter, @Nullable Insetter insetter2, Insetter insetter3) {
            super(titleBarConfiguration, rendererDescription, insetter, insetter2, insetter3);
        }

        @Override
        @NotNull
        protected BasicRenderer getBasicTitleBarRenderer(float f, float f2) {
            LayoutInfo layoutInfo = uiLayout.getLayoutInfo(this.g);
            float f3 = layoutInfo.getFixedVisualHeight();
            int n = (int)Math.ceil(f3);
            JRSPainter.this.maker.reset();
            JRSPainter.this.maker.set(JRSUIConstants.Widget.WINDOW_FRAME);
            JRSPainter.this.maker.set(JRSUIConstants.WindowClipCorners.YES);
            JRSPainter.this.maker.set(JRSPainter.this.toWindowType(this.g));
            JRSPainter.this.maker.setValue(n);
            JRSPainter.this.maker.set(JRSUIConstants.WindowTitleBarSeparator.YES);
            JRSPainter.this.configureState(this.g.getTitleBarState());
            return JRSPainter.this.maker.getRenderer();
        }

        @Override
        @NotNull
        protected Renderer getButtonRenderer(@NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
            return JRSPainter.this.getTitleBarButtonRenderer(this.g, titleBarButtonWidget);
        }
    }
}

