/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComboBoxRenderer;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaListMouseBehavior;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.JListModel;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaListUI
extends BasicListUI
implements AquaComponentUI {
    public static final String LIST_STYLE_KEY = "JList.style";
    public static final String QUAQUA_LIST_STYLE_KEY = "Quaqua.List.style";
    private boolean isStriped = false;
    private boolean isFocused = false;
    @NotNull
    protected ContainerContextualColors colors = AquaColors.CONTAINER_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;
    @Nullable
    protected Color actualListBackground;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaListUI();
    }

    public void setColors(@NotNull ContainerContextualColors containerContextualColors) {
        if (containerContextualColors != this.colors) {
            this.colors = containerContextualColors;
            this.configureAppearanceContext(null);
        }
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new AquaListMouseBehavior(new JListModel(this.list));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.list.putClientProperty("JComponent.isCellContainer", true);
        this.isStriped = this.getStripedValue();
        this.updateOpaque();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListener(this.list);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListener(this.list);
        super.uninstallListeners();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.list.getActionMap().put("aquaHome", new AquaHomeEndAction(true));
        this.list.getActionMap().put("aquaEnd", new AquaHomeEndAction(false));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new AquaPropertyChangeHandler();
    }

    @NotNull
    public ContainerContextualColors getColors() {
        return this.colors;
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.list);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.colors.configureForContainer();
        this.actualListBackground = this.colors.getBackground(this.appearanceContext);
        AquaColors.installColors(this.list, this.appearanceContext, this.colors);
        this.list.repaint();
    }

    protected AquaUIPainter.State getState() {
        return this.list.isEnabled() ? (this.isFocused ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    private void updateStriped() {
        boolean bl = this.getStripedValue();
        if (bl != this.isStriped) {
            this.isStriped = bl;
            this.colors = this.isStriped ? AquaColors.STRIPED_CONTAINER_COLORS : AquaColors.CONTAINER_COLORS;
            this.updateOpaque();
            this.configureAppearanceContext(null);
        }
    }

    private void updateOpaque() {
        this.list.setOpaque(!this.isStriped);
    }

    private boolean getStripedValue() {
        String string = this.getStyleProperty();
        return "striped".equals(string) && this.list.getLayoutOrientation() == 0 && this.isBackgroundClear();
    }

    private boolean isBackgroundClear() {
        Color color = this.list.getBackground();
        return color.getAlpha() == 0 || color instanceof ColorUIResource;
    }

    public boolean isStriped() {
        return this.isStriped;
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        Color color = this.getBackgroundColor();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Nullable
    private Color getBackgroundColor() {
        if (this.list.isOpaque()) {
            if (this.isStriped && this.actualListBackground != null) {
                return this.actualListBackground;
            }
            return this.list.getBackground();
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.appearanceContext != null) {
            this.paintStripes(graphics, jComponent);
            super.paint(graphics, jComponent);
        }
    }

    public void paintStripes(Graphics graphics, JComponent jComponent) {
        if (this.isStriped && this.list.getModel() != null) {
            assert (this.appearanceContext != null);
            Dimension dimension = jComponent.getSize();
            int n = this.list.getFixedCellHeight();
            int n2 = this.list.getModel().getSize();
            if (n <= 0) {
                n = n2 == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int n3 = (int)Math.ceil(Math.abs(dimension.getHeight() / (double)n));
            int n4 = 0;
            int n5 = 0;
            ListSelectionModel listSelectionModel = this.list.getSelectionModel();
            while (n4 < n3) {
                boolean bl = listSelectionModel.isSelectedIndex(n4);
                this.colors.configureForRow(n4, bl);
                Color color = this.colors.getBackground(this.appearanceContext);
                graphics.setColor(color);
                graphics.fillRect(0, n5, dimension.width, n);
                ++n4;
                n5 += n;
            }
        }
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Component component;
        Object object;
        boolean bl;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        assert (this.appearanceContext != null);
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        boolean bl3 = this.list.isEnabled();
        boolean bl4 = bl3 && AquaFocusHandler.hasFocus(this.list);
        boolean bl5 = bl = bl4 && n == n2;
        if (bl2 && !this.isStriped) {
            object = this.colors.getBackground(this.appearanceContext.withSelected(true));
            graphics.setColor((Color)object);
            graphics.fillRect(n3, n4, n5, n6);
        }
        if ((component = listCellRenderer.getListCellRendererComponent(this.list, object = listModel.getElementAt(n), n, bl2, bl)) instanceof JTextComponent) {
            ((JTextComponent)component).putClientProperty("Aqua.componentColors", AquaColors.CELL_TEXT_COLORS);
        }
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n6, true);
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).putClientProperty("Aqua.componentColors", null);
        }
    }

    protected void repaintCell(Object object, int n, boolean bl) {
        AquaComboBoxRenderer aquaComboBoxRenderer;
        Rectangle rectangle = this.getCellBounds(this.list, n, n);
        if (rectangle == null) {
            return;
        }
        ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
        if (listCellRenderer == null) {
            return;
        }
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl, true);
        if (component == null) {
            return;
        }
        AquaComboBoxRenderer aquaComboBoxRenderer2 = aquaComboBoxRenderer = listCellRenderer instanceof AquaComboBoxRenderer ? (AquaComboBoxRenderer)listCellRenderer : null;
        if (aquaComboBoxRenderer != null) {
            aquaComboBoxRenderer.setDrawCheckedItem(false);
        }
        this.rendererPane.paintComponent(this.list.getGraphics().create(), component, this.list, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        if (aquaComboBoxRenderer != null) {
            aquaComboBoxRenderer.setDrawCheckedItem(true);
        }
    }

    protected class FocusHandler
    implements FocusListener {
        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusChanged();
        }

        private void focusChanged() {
            AquaListUI.this.isFocused = AquaFocusHandler.hasFocus(AquaListUI.this.list);
            AquaListUI.this.configureAppearanceContext(null);
        }
    }

    static class AquaHomeEndAction
    extends AbstractAction {
        private boolean fHomeAction;

        protected AquaHomeEndAction(boolean bl) {
            this.fHomeAction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            if (this.fHomeAction) {
                jList.ensureIndexIsVisible(0);
            } else {
                int n = jList.getModel().getSize();
                jList.ensureIndexIsVisible(n - 1);
            }
        }
    }

    class AquaPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        AquaPropertyChangeHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                AquaListUI.this.configureAppearanceContext(null);
            } else {
                if (AquaListUI.this.isStyleProperty(string)) {
                    AquaListUI.this.updateStriped();
                } else if ("layoutOrientation".equals(string)) {
                    AquaListUI.this.updateStriped();
                }
                super.propertyChange(propertyChangeEvent);
            }
        }
    }
}

