/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.basic.BasicDesktopPaneUI;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaInternalFrameDockIconUI;
import org.violetlib.aqua.AquaInternalFrameManager;

public class AquaInternalFramePaneUI
extends BasicDesktopPaneUI
implements MouseListener,
AquaComponentUI {
    JComponent fDock;
    DockLayoutManager fLayoutMgr;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaInternalFramePaneUI();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.fLayoutMgr = new DockLayoutManager();
        jComponent.setLayout(this.fLayoutMgr);
        jComponent.addMouseListener(this);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        if (this.fDock != null) {
            jComponent.remove(this.fDock);
            this.fDock = null;
        }
        if (this.fLayoutMgr != null) {
            jComponent.setLayout(null);
            this.fLayoutMgr = null;
        }
        super.uninstallUI(jComponent);
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
    }

    @Override
    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new AquaDockingDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    @Override
    protected void uninstallDesktopManager() {
        DesktopManager desktopManager = this.desktop.getDesktopManager();
        if (desktopManager instanceof AquaDockingDesktopManager) {
            this.desktop.setDesktopManager(null);
        }
    }

    JComponent getDock() {
        if (this.fDock == null) {
            this.fDock = new Dock(this.desktop);
            this.desktop.add((Component)this.fDock, new Integer(399));
        }
        return this.fDock;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JInternalFrame jInternalFrame = this.desktop.getSelectedFrame();
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.desktop.getDesktopManager().deactivateFrame(jInternalFrame);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    class DockLayoutManager
    implements LayoutManager {
        DockLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return container.getSize();
        }

        @Override
        public void layoutContainer(Container container) {
            if (AquaInternalFramePaneUI.this.fDock != null) {
                ((Dock)AquaInternalFramePaneUI.this.fDock).updateSize();
            }
        }
    }

    class AquaDockingDesktopManager
    extends AquaInternalFrameManager {
        AquaDockingDesktopManager() {
        }

        @Override
        public void openFrame(JInternalFrame jInternalFrame) {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            Container container = jDesktopIcon.getParent();
            if (container == null) {
                return;
            }
            if (container.getParent() != null) {
                container.getParent().add(jInternalFrame);
            }
            this.removeIconFor(jInternalFrame);
        }

        @Override
        public void deiconifyFrame(JInternalFrame jInternalFrame) {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            Container container = jDesktopIcon.getParent();
            if (container == null) {
                return;
            }
            if (container.getParent() != null) {
                container.getParent().add(jInternalFrame);
            }
            this.removeIconFor(jInternalFrame);
            jInternalFrame.moveToFront();
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void iconifyFrame(JInternalFrame jInternalFrame) {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            ((AquaInternalFrameDockIconUI)jDesktopIcon.getUI()).updateIcon();
            super.iconifyFrame(jInternalFrame);
        }

        @Override
        void addIcon(Container container, JInternalFrame.JDesktopIcon jDesktopIcon) {
            DesktopPaneUI desktopPaneUI = ((JDesktopPane)container).getUI();
            ((AquaInternalFramePaneUI)desktopPaneUI).getDock().add(jDesktopIcon);
        }
    }

    class Dock
    extends JComponent
    implements Border {
        public static final int DOCK_EDGE_SLACK = 8;

        Dock(JComponent jComponent) {
            this.setBorder(this);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setVisible(false);
        }

        @Override
        public void removeNotify() {
            AquaInternalFramePaneUI.this.fDock = null;
            super.removeNotify();
        }

        void updateSize() {
            Dimension dimension = this.getPreferredSize();
            this.setBounds((this.getParent().getWidth() - dimension.width) / 2, this.getParent().getHeight() - dimension.height, dimension.width, dimension.height);
        }

        @Override
        public Component add(Component component) {
            super.add(component);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.updateSize();
            this.validate();
            return component;
        }

        @Override
        public void remove(Component component) {
            super.remove(component);
            if (this.getComponentCount() == 0) {
                this.setVisible(false);
            } else {
                this.updateSize();
                this.validate();
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(2, 8, 0, 8);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n5 = this.getHeight();
            int n6 = this.getWidth();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(UIManager.getColor("DesktopIcon.borderColor"));
            graphics2D.fillRoundRect(4, 4, n6 - 9, n5 + 8, 8, 8);
            graphics2D.setColor(UIManager.getColor("DesktopIcon.borderRimColor"));
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawRoundRect(4, 4, n6 - 9, n5 + 8, 8, 8);
            if (object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
    }
}

