/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.RendererDescriptionsBase;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class ViewRendererDescriptions
extends RendererDescriptionsBase {
    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        int n = JNRPlatformUtils.getPlatformVersion();
        RendererDescription rendererDescription = super.getSegmentedButtonRendererDescription(segmentedButtonConfiguration);
        if (n < 101300) {
            return rendererDescription;
        }
        int n2 = AquaUIPainterBase.internalGetSegmentedButtonRenderingVersion();
        if (n2 == 3) {
            return this.getSegmentedButtonRendererDescription13new(segmentedButtonConfiguration, rendererDescription);
        }
        if (n2 == 5) {
            return this.getSegmentedButtonRendererDescription14new(segmentedButtonConfiguration, rendererDescription);
        }
        if (n2 == 2) {
            return this.getSegmentedButtonRendererDescription13old(segmentedButtonConfiguration, rendererDescription);
        }
        if (n2 == 4) {
            return this.getSegmentedButtonRendererDescription14old(segmentedButtonConfiguration, rendererDescription);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected RendererDescription getSegmentedButtonRendererDescription13new(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription) {
        float f;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                f = JNRUtils.size2D(size, -1.0f, -2.49f, -4.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                f = JNRUtils.size2D(size, -3.0f, -4.0f, -5.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                f = JNRUtils.size2D(size, -1.0f, -2.0f, -3.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: {
                f = JNRUtils.size2D(size, -1.49f, -2.0f, -3.49f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                f = JNRUtils.size2D(size, -1.49f, -2.0f, -4.49f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return JNRUtils.changeRendererDescription(rendererDescription, -123456.0f, f, -123456.0f, -123456.0f);
    }

    @NotNull
    protected RendererDescription getSegmentedButtonRendererDescription13old(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription) {
        float f;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                f = JNRUtils.size2D(size, -1.0f, -2.49f, -4.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                f = JNRUtils.size2D(size, -3.0f, -4.0f, -5.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                f = JNRUtils.size2D(size, -1.0f, -2.0f, -3.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED: {
                f = JNRUtils.size2D(size, -1.49f, -2.49f, -3.49f);
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                f = JNRUtils.size2D(size, -1.49f, -2.49f, -4.49f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                f = JNRUtils.size2D(size, -1.49f, -2.0f, -1.49f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                f = JNRUtils.size2D(size, -1.0f, -2.49f, -4.49f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return JNRUtils.changeRendererDescription(rendererDescription, -123456.0f, f, -123456.0f, -123456.0f);
    }

    @NotNull
    protected RendererDescription getSegmentedButtonRendererDescription14old(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription) {
        float f;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                f = JNRUtils.size2D(size, -1.0f, -2.49f, -4.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                f = JNRUtils.size2D(size, -3.0f, -4.0f, -5.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                f = JNRUtils.size2D(size, -1.0f, -2.0f, -3.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED: {
                f = JNRUtils.size2D(size, -1.49f, -2.49f, -3.49f);
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                f = JNRUtils.size2D(size, -1.49f, -2.49f, -4.49f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                f = JNRUtils.size2D(size, -1.49f, -2.0f, -1.49f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                f = JNRUtils.size2D(size, -1.0f, -2.49f, -4.49f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return JNRUtils.changeRendererDescription(rendererDescription, -123456.0f, f, -123456.0f, -123456.0f);
    }

    @NotNull
    protected RendererDescription getSegmentedButtonRendererDescription14new(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription) {
        float f;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                f = JNRUtils.size2D(size, -1.0f, -2.0f, -4.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                f = JNRUtils.size2D(size, -3.0f, -4.0f, -5.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                f = JNRUtils.size2D(size, -1.0f, -2.0f, -3.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: {
                f = JNRUtils.size2D(size, -1.49f, -2.49f, -3.49f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                f = JNRUtils.size2D(size, -1.49f, -2.0f, -4.49f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return JNRUtils.changeRendererDescription(rendererDescription, -123456.0f, f, -123456.0f, -123456.0f);
    }

    @Override
    @NotNull
    public RendererDescription getComboBoxRendererDescription(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxConfiguration.getWidget();
        AquaUIPainter.Size size = comboBoxConfiguration.getSize();
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -3.0f, 3.0f, 3.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -1.0f, 3.0f, 1.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 2.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (size) {
            case LARGE: 
            case REGULAR: {
                return new BasicRendererDescription(-0.5f, 0.0f, 3.0f, 1.0f);
            }
            case SMALL: {
                return new BasicRendererDescription(-0.5f, 0.0f, 3.0f, 2.0f);
            }
            case MINI: {
                return new BasicRendererDescription(-0.5f, 0.0f, 2.0f, 2.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getSplitPaneDividerRendererDescription(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        AquaUIPainter.Orientation orientation = splitPaneDividerConfiguration.getOrientation();
        switch (splitPaneDividerConfiguration.getWidget()) {
            case THIN_DIVIDER: {
                return orientation == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 9.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
            case THICK_DIVIDER: {
                return orientation == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f) : new MultiResolutionRendererDescription(new BasicRendererDescription(-4.0f, 0.0f, 6.0f, 0.0f), new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 0.0f));
            }
            case PANE_SPLITTER: {
                return orientation == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f) : new BasicRendererDescription(-5.0f, 0.0f, 10.0f, 0.0f);
            }
        }
        return null;
    }
}

