/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class OverlayScrollBarPainterExtension
implements PainterExtension {
    @NotNull
    private final AquaUILayoutInfo uiLayout;
    @NotNull
    private final ScrollBarConfiguration g;
    @NotNull
    private final AquaUIPainter.ScrollBarKnobWidget kw;
    private final boolean isRollover;
    @NotNull
    private final Colors colors;

    public OverlayScrollBarPainterExtension(@NotNull AquaUILayoutInfo aquaUILayoutInfo, @NotNull ScrollBarConfiguration scrollBarConfiguration, @Nullable VAppearance vAppearance) {
        this.uiLayout = aquaUILayoutInfo;
        this.g = scrollBarConfiguration;
        this.kw = scrollBarConfiguration.getKnobWidget();
        this.isRollover = scrollBarConfiguration.getWidget() == AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER;
        boolean bl = this.getCorrespondingAppearanceIsDark(vAppearance, this.kw);
        boolean bl2 = vAppearance != null && vAppearance.isHighContrast();
        this.colors = Colors.getColors(bl, bl2);
    }

    private boolean getCorrespondingAppearanceIsDark(@Nullable VAppearance vAppearance, @NotNull AquaUIPainter.ScrollBarKnobWidget scrollBarKnobWidget) {
        if (scrollBarKnobWidget == AquaUIPainter.ScrollBarKnobWidget.DEFAULT) {
            return vAppearance != null && vAppearance.isDark();
        }
        return scrollBarKnobWidget == AquaUIPainter.ScrollBarKnobWidget.LIGHT;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        Color color;
        Shape shape;
        boolean bl;
        graphics2D = (Graphics2D)graphics2D.create();
        graphics2D.clip(new Rectangle2D.Float(0.0f, 0.0f, f, f2));
        boolean bl2 = bl = f2 > f;
        if (this.isRollover) {
            shape = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
            graphics2D.setColor(this.getTrackBackgroundColor());
            graphics2D.fill(shape);
            color = this.getInnerBorderColor();
            Color color2 = this.getOuterBorderColor();
            if (color != null || color2 != null) {
                int n = (int)f;
                int n2 = (int)f2;
                if (bl) {
                    if (color != null) {
                        graphics2D.setColor(color);
                        graphics2D.fillRect(0, 0, 1, n2);
                    }
                    if (color2 != null) {
                        graphics2D.setColor(color2);
                        graphics2D.fillRect(n - 1, 0, 1, n2);
                    }
                } else {
                    if (color != null) {
                        graphics2D.setColor(color);
                        graphics2D.fillRect(0, 0, n, 1);
                    }
                    if (color2 != null) {
                        graphics2D.setColor(color2);
                        graphics2D.fillRect(0, n2 - 1, n, 1);
                    }
                }
            }
        }
        if (this.kw != AquaUIPainter.ScrollBarKnobWidget.NONE) {
            shape = this.createThumbShape(f, f2);
            graphics2D.setColor(this.getThumbColor());
            graphics2D.fill(shape);
            color = this.getThumbBorderColor();
            if (color != null) {
                float f3 = this.getThumbBorderThickness();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f3 * 1.5f));
                Shape shape2 = this.createThumbShape(f, f2);
                graphics2D.clip(shape);
                graphics2D.draw(shape2);
            }
        }
        graphics2D.dispose();
    }

    @NotNull
    protected Shape createThumbShape(float f, float f2) {
        boolean bl = f2 > f;
        double d = 3.5;
        double d2 = 1.5;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        Rectangle2D rectangle2D = this.uiLayout.getScrollBarThumbBounds(float_, this.g);
        if (bl) {
            double d3 = (double)f - d - d2;
            return new RoundRectangle2D.Double(d, rectangle2D.getY(), d3, rectangle2D.getHeight(), d3, d3);
        }
        double d4 = (double)f2 - d - d2;
        return new RoundRectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d4, d4, d4);
    }

    @Nullable
    protected Color getInnerBorderColor() {
        return this.colors.get("overlayScrollTrackBorder");
    }

    @Nullable
    protected Color getOuterBorderColor() {
        return this.colors.get("overlayScrollTrackBorder");
    }

    protected float getThumbBorderThickness() {
        switch (this.kw) {
            case LIGHT: {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    @NotNull
    protected Color getTrackBackgroundColor() {
        return this.colors.get("overlayScrollTrack");
    }

    @NotNull
    protected Color getThumbColor() {
        Color color;
        if (this.isRollover && (color = this.colors.getOptional("overlayThumb_rollover")) != null) {
            return color;
        }
        return this.colors.get("overlayThumb");
    }

    @Nullable
    protected Color getThumbBorderColor() {
        Color color;
        if (this.isRollover && (color = this.colors.getOptional("overlayThumbBorder_rollover")) != null) {
            return color;
        }
        return this.colors.getOptional("overlayThumbBorder");
    }
}

