/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.coreui.ColorWellRenderer;
import org.violetlib.jnr.aqua.coreui.CoreUIPainter;
import org.violetlib.jnr.aqua.impl.CircularSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.LegacyScrollBarPainterExtension;
import org.violetlib.jnr.aqua.impl.LinearSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.OverlayScrollBarPainterExtension;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainter;
import org.violetlib.jnr.aqua.impl.PullDownArrowPainter;
import org.violetlib.jnr.aqua.impl.TableColumnHeaderCellPainterExtension;
import org.violetlib.jnr.aqua.impl.ThinSplitPaneDividerPainterExtension;
import org.violetlib.jnr.impl.AdjustDarkToolbarButtonRenderer;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.DarkGroupBoxRenderer;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class AugmentedCoreUIPainter
extends CoreUIPainter {
    public AugmentedCoreUIPainter() {
    }

    public AugmentedCoreUIPainter(boolean bl) {
        super(bl);
    }

    @Override
    @NotNull
    public AugmentedCoreUIPainter copy() {
        return new AugmentedCoreUIPainter(this.useJRS);
    }

    @Override
    @NotNull
    protected Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration groupBoxConfiguration) {
        if (this.appearance != null && this.appearance.isDark()) {
            Renderer renderer = super.getGroupBoxRenderer(groupBoxConfiguration);
            BasicRenderer basicRenderer = renderer.getBasicRenderer();
            assert (basicRenderer != null);
            DarkGroupBoxRenderer darkGroupBoxRenderer = new DarkGroupBoxRenderer(basicRenderer, this.appearance);
            return Renderer.create(darkGroupBoxRenderer, renderer.getRendererDescription());
        }
        return super.getGroupBoxRenderer(groupBoxConfiguration);
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration buttonConfiguration) {
        Renderer renderer = super.getButtonRenderer(buttonConfiguration);
        if (buttonConfiguration.getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return new ColorWellRenderer(buttonConfiguration, renderer);
        }
        return renderer;
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget;
        Renderer renderer = super.getComboBoxButtonRenderer(comboBoxConfiguration);
        if (this.appearance != null && this.appearance.isDark() && (comboBoxWidget = comboBoxConfiguration.getWidget()) == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            BasicRenderer basicRenderer = renderer.getBasicRenderer();
            assert (basicRenderer != null);
            AdjustDarkToolbarButtonRenderer adjustDarkToolbarButtonRenderer = new AdjustDarkToolbarButtonRenderer(basicRenderer);
            renderer = Renderer.create(adjustDarkToolbarButtonRenderer, renderer.getRendererDescription());
        }
        return renderer;
    }

    @Override
    @Nullable
    public Renderer getBasicPopupButtonRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget;
        Renderer renderer = super.getBasicPopupButtonRenderer(popupButtonConfiguration);
        if (renderer != null && this.appearance != null && this.appearance.isDark() && ((popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget()) == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR)) {
            BasicRenderer basicRenderer = renderer.getBasicRenderer();
            assert (basicRenderer != null);
            AdjustDarkToolbarButtonRenderer adjustDarkToolbarButtonRenderer = new AdjustDarkToolbarButtonRenderer(basicRenderer);
            renderer = Renderer.create(adjustDarkToolbarButtonRenderer, renderer.getRendererDescription());
        }
        return renderer;
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget;
        Renderer renderer = super.getSegmentedButtonRenderer(segmentedButtonConfiguration);
        if (this.appearance != null && this.appearance.isDark() && ((segmentedButtonWidget = segmentedButtonConfiguration.getWidget()) == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR || segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR)) {
            BasicRenderer basicRenderer = renderer.getBasicRenderer();
            assert (basicRenderer != null);
            AdjustDarkToolbarButtonRenderer adjustDarkToolbarButtonRenderer = new AdjustDarkToolbarButtonRenderer(basicRenderer);
            renderer = Renderer.create(adjustDarkToolbarButtonRenderer, renderer.getRendererDescription());
        }
        if (this.isCustomSegmentedButtonRendererNeeded(segmentedButtonConfiguration)) {
            return this.createCustomSegmentedButtonRenderer(segmentedButtonConfiguration, renderer);
        }
        return renderer;
    }

    protected boolean isCustomSegmentedButtonRendererNeeded(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        if (segmentedButtonConfiguration.getPosition() == AquaUIPainter.Position.ONLY) {
            return false;
        }
        return segmentedButtonConfiguration.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE || segmentedButtonConfiguration.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
    }

    @Nullable
    protected SegmentedButtonAdjustment getSegmentedButtonAdjustment(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, int n) {
        if (segmentedButtonConfiguration.getPosition() == AquaUIPainter.Position.ONLY) {
            return null;
        }
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        if (segmentedButtonWidget.isSeparated() && n == 2) {
            return null;
        }
        if (n > 2) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        if (segmentedButtonConfiguration.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE) {
            n2 = n;
        }
        if (segmentedButtonConfiguration.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE) {
            n3 = n;
        }
        SegmentedButtonAdjustment segmentedButtonAdjustment = this.getSegmentedDividerAvailable(segmentedButtonConfiguration, n);
        int n4 = n2 > 0 ? segmentedButtonAdjustment.leftDividerActual : 0;
        int n5 = n3 > 0 ? segmentedButtonAdjustment.rightDividerActual : 0;
        return new SegmentedButtonAdjustment(n4, n2, n5, n3);
    }

    @NotNull
    private SegmentedButtonAdjustment getSegmentedDividerAvailable(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, int n) {
        int n2;
        int n3;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        int n4 = this.getSegmentedButtonRenderingVersion();
        if (n == 1) {
            if (n4 == 0 || n4 == 1 || n4 == 2) {
                if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE) {
                    n3 = 1;
                    n2 = 1;
                } else {
                    n3 = 0;
                    n2 = 1;
                }
            } else {
                n3 = 0;
                n2 = 1;
            }
        } else if (n4 == 2 || n4 == 3) {
            if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE) {
                n3 = 2;
                n2 = 2;
            } else if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED || segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE) {
                n3 = 2;
                n2 = 0;
            } else {
                n3 = 1;
                n2 = 1;
            }
        } else {
            n3 = 1;
            n2 = 1;
        }
        return new SegmentedButtonAdjustment(n3, 0, n2, 0);
    }

    @NotNull
    protected Renderer createCustomSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull Renderer renderer) {
        return new MySegmentedButtonRenderer(segmentedButtonConfiguration, renderer);
    }

    @NotNull
    protected SegmentedRendering createFlippedRendering(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, int n, int n2) {
        SegmentedButtonConfiguration segmentedButtonConfiguration2 = new SegmentedButtonConfiguration(segmentedButtonConfiguration.getWidget(), segmentedButtonConfiguration.getSize(), segmentedButtonConfiguration.getState(), segmentedButtonConfiguration.isSelected(), segmentedButtonConfiguration.isFocused(), segmentedButtonConfiguration.getDirection(), AquaUIPainter.Position.MIDDLE, segmentedButtonConfiguration.getRightDividerState(), segmentedButtonConfiguration.getLeftDividerState());
        int n3 = 100;
        Renderer renderer = AugmentedCoreUIPainter.super.getSegmentedButtonRenderer(segmentedButtonConfiguration2);
        ReusableCompositor reusableCompositor = new ReusableCompositor();
        reusableCompositor.reset(n3, n, n2);
        renderer.composeTo(reusableCompositor);
        ReusableCompositor reusableCompositor2 = reusableCompositor.createHorizontallyFlippedCopy();
        SegmentedButtonAdjustment segmentedButtonAdjustment = this.getSegmentedDividerAvailable(segmentedButtonConfiguration2, n2);
        SegmentedButtonAdjustment segmentedButtonAdjustment2 = new SegmentedButtonAdjustment(segmentedButtonAdjustment.rightDividerActual, segmentedButtonAdjustment.leftDividerActual);
        return new SegmentedRendering(reusableCompositor2, segmentedButtonAdjustment2);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        if (splitPaneDividerConfiguration.getWidget() == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            ThinSplitPaneDividerPainterExtension thinSplitPaneDividerPainterExtension = new ThinSplitPaneDividerPainterExtension(splitPaneDividerConfiguration, this.appearance);
            return Renderer.create(thinSplitPaneDividerPainterExtension);
        }
        return super.getSplitPaneDividerRenderer(splitPaneDividerConfiguration);
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        TableColumnHeaderCellPainterExtension tableColumnHeaderCellPainterExtension = new TableColumnHeaderCellPainterExtension(tableColumnHeaderConfiguration, this.appearance);
        return Renderer.create(tableColumnHeaderCellPainterExtension);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        Renderer renderer = super.getSliderRenderer(sliderConfiguration);
        if (sliderConfiguration.getWidget() == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            Renderer renderer2 = Renderer.create(new CircularSliderPainterExtension(sliderConfiguration, this.appearance));
            return Renderer.createCompositeRenderer(renderer, renderer2);
        }
        return renderer;
    }

    @Override
    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        if (sliderConfiguration.getWidget() != AquaUIPainter.SliderWidget.SLIDER_CIRCULAR && sliderConfiguration.hasTickMarks()) {
            return Renderer.create(new LinearSliderPainterExtension(uiLayout, sliderConfiguration, this.appearance));
        }
        return null;
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        int n = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.ScrollBarWidget scrollBarWidget = scrollBarConfiguration.getWidget();
        if (n < 101400) {
            return super.getScrollBarRenderer(scrollBarConfiguration);
        }
        if (scrollBarWidget == AquaUIPainter.ScrollBarWidget.LEGACY) {
            return Renderer.create(new LegacyScrollBarPainterExtension(uiLayout, scrollBarConfiguration, this.appearance));
        }
        return Renderer.create(new OverlayScrollBarPainterExtension(uiLayout, scrollBarConfiguration, this.appearance));
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        Renderer renderer = super.getPopupArrowRenderer(popupButtonConfiguration);
        if (this.isArrowNeeded(popupButtonConfiguration)) {
            if (popupButtonConfiguration.isPopUp()) {
                return Renderer.create(new PopUpArrowPainter(popupButtonConfiguration, this.appearance));
            }
            return Renderer.create(new PullDownArrowPainter(popupButtonConfiguration, this.appearance));
        }
        return renderer;
    }

    private boolean isArrowNeeded(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        return popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED;
    }

    @Override
    @NotNull
    public String toString() {
        return "Augmented " + super.toString();
    }

    protected static class SegmentedRendering {
        @NotNull
        public final ReusableCompositor rendering;
        @NotNull
        public final SegmentedButtonAdjustment dividers;

        public SegmentedRendering(@NotNull ReusableCompositor reusableCompositor, @NotNull SegmentedButtonAdjustment segmentedButtonAdjustment) {
            this.rendering = reusableCompositor;
            this.dividers = segmentedButtonAdjustment;
        }
    }

    protected class MySegmentedButtonRenderer
    extends Renderer {
        @NotNull
        private final SegmentedButtonConfiguration g;
        @NotNull
        private final Renderer r;

        public MySegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, Renderer renderer) {
            this.g = segmentedButtonConfiguration;
            this.r = renderer;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
            int n = reusableCompositor.getScaleFactor();
            SegmentedButtonAdjustment segmentedButtonAdjustment = AugmentedCoreUIPainter.this.getSegmentedButtonAdjustment(this.g, n);
            if (segmentedButtonAdjustment == null) {
                this.r.composeTo(reusableCompositor);
            } else {
                int n2;
                int n3;
                int n4;
                int n5;
                ReusableCompositor reusableCompositor2;
                int n6;
                int n7 = reusableCompositor.getRasterWidth();
                int n8 = reusableCompositor.getRasterHeight();
                int n9 = 0;
                int n10 = 0;
                ReusableCompositor reusableCompositor3 = reusableCompositor.createSimilar();
                this.r.composeTo(reusableCompositor3);
                if (segmentedButtonAdjustment.leftDividerRequested > segmentedButtonAdjustment.leftDividerActual) {
                    n9 = segmentedButtonAdjustment.leftDividerRequested;
                }
                if (segmentedButtonAdjustment.rightDividerRequested > segmentedButtonAdjustment.rightDividerActual) {
                    n10 = segmentedButtonAdjustment.rightDividerRequested;
                }
                reusableCompositor.composeFrom(reusableCompositor3, n9, 0, n9, 0, n7 - n9 - n10, n8);
                SegmentedRendering segmentedRendering = null;
                if (n9 > 0) {
                    n6 = segmentedButtonAdjustment.leftDividerRequested;
                    reusableCompositor2 = reusableCompositor3;
                    n5 = 0;
                    n4 = segmentedButtonAdjustment.leftDividerActual;
                    if (n4 == 0) {
                        segmentedRendering = AugmentedCoreUIPainter.this.createFlippedRendering(this.g, n8, n);
                        reusableCompositor2 = segmentedRendering.rendering;
                        n4 = segmentedRendering.dividers.leftDividerActual;
                    }
                    if (n4 > 0) {
                        n3 = 0;
                        while (n6 > 0) {
                            n2 = Math.min(n6, n4);
                            reusableCompositor.composeFrom(reusableCompositor2, n5, 0, n3, 0, n2, n8);
                            n6 -= n2;
                            n3 += n2;
                        }
                    } else {
                        System.err.println("Unsupported left divider from right:" + this.g);
                    }
                }
                if (n10 > 0) {
                    n6 = segmentedButtonAdjustment.rightDividerRequested;
                    reusableCompositor2 = reusableCompositor3;
                    n5 = n7 - segmentedButtonAdjustment.rightDividerActual;
                    n4 = segmentedButtonAdjustment.rightDividerActual;
                    if (n4 == 0) {
                        if (segmentedRendering == null) {
                            segmentedRendering = AugmentedCoreUIPainter.this.createFlippedRendering(this.g, n8, n);
                        }
                        reusableCompositor2 = segmentedRendering.rendering;
                        n4 = segmentedRendering.dividers.rightDividerActual;
                        n5 = reusableCompositor2.getRasterWidth() - n4;
                    }
                    if (n4 > 0) {
                        n3 = n7 - segmentedButtonAdjustment.rightDividerRequested;
                        while (n6 > 0) {
                            n2 = Math.min(n6, n4);
                            reusableCompositor.composeFrom(reusableCompositor2, n5, 0, n3, 0, n2, n8);
                            n6 -= n2;
                            n3 += n2;
                        }
                    } else {
                        System.err.println("Unsupported right divider from left: " + this.g);
                    }
                }
            }
        }
    }

    protected static class SegmentedButtonAdjustment {
        public final int leftDividerActual;
        public final int leftDividerRequested;
        public final int rightDividerActual;
        public final int rightDividerRequested;

        public SegmentedButtonAdjustment(int n, int n2, int n3, int n4) {
            this.leftDividerActual = n;
            this.leftDividerRequested = n2;
            this.rightDividerActual = n3;
            this.rightDividerRequested = n4;
        }

        public SegmentedButtonAdjustment(int n, int n2) {
            this.leftDividerActual = n;
            this.rightDividerActual = n2;
            this.leftDividerRequested = 0;
            this.rightDividerRequested = 0;
        }
    }
}

