/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ViewportUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaViewportUI
extends ViewportUI
implements AquaComponentUI {
    @Nullable
    protected JViewport viewport;
    @NotNull
    protected final BasicContextualColors colors = AquaColors.CONTROL_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaViewportUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.viewport = (JViewport)jComponent;
        AquaVibrantSupport.installVibrantStyle(jComponent);
        AppearanceManager.installListener(jComponent);
        this.configureAppearanceContext(null);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        AppearanceManager.uninstallListener(jComponent);
        AquaVibrantSupport.uninstallVibrantStyle(jComponent);
        this.viewport = null;
        super.uninstallUI(jComponent);
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        assert (this.viewport != null);
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.viewport);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        AquaColors.installColors(this.viewport, this.appearanceContext, this.colors);
        this.viewport.repaint();
    }

    protected AquaUIPainter.State getState() {
        return AquaFocusHandler.isActive(this.viewport) ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
    }

    @Override
    public final void update(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        if (jComponent.isOpaque() || AquaVibrantSupport.isVibrant(jComponent)) {
            AquaUtils.fillRect(graphics, jComponent, 2);
        }
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }
}

