/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaLabelUI
extends BasicLabelUI
implements AquaComponentUI {
    private static AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    @NotNull
    protected BasicContextualColors colors;
    @Nullable
    protected AppearanceContext appearanceContext;
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaLabelUI();
    }

    public AquaLabelUI() {
        this.colors = AquaColors.CLEAR_CONTROL_COLORS;
    }

    @Override
    protected void installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
        this.configureAppearanceContext(null, jLabel);
    }

    @Override
    protected void installListeners(JLabel jLabel) {
        super.installListeners(jLabel);
        AquaUtilControlSize.addSizePropertyListener(jLabel);
        AppearanceManager.installListener(jLabel);
    }

    @Override
    protected void uninstallListeners(JLabel jLabel) {
        AppearanceManager.uninstallListener(jLabel);
        AquaUtilControlSize.removeSizePropertyListener(jLabel);
        super.uninstallListeners(jLabel);
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance, (JLabel)jComponent);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance, @NotNull JLabel jLabel) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(jLabel);
        }
        AquaUIPainter.State state = AquaUIPainter.State.ACTIVE;
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        if (cellEditorPolicy.getCellStatus(jLabel) == null) {
            AquaColors.installColors(jLabel, this.appearanceContext, this.colors);
        }
        jLabel.repaint();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.getParent() != null) {
            AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
            super.update(graphics, jComponent);
            AppearanceManager.restoreCurrentAppearance(aquaAppearance);
        } else {
            super.update(graphics, jComponent);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = jLabel.getFontMetrics(graphics.getFont());
        String string2 = this.layout(jLabel, fontMetrics, jComponent.getWidth(), jComponent.getHeight());
        if (icon != null) {
            Image image;
            if (icon instanceof ImageIcon && AquaImageFactory.isTemplateImage(image = ((ImageIcon)(object = (ImageIcon)icon)).getImage())) {
                Color color = jLabel.getForeground();
                Image image2 = AquaImageFactory.getProcessedImage(image, (Object)color);
                icon = new ImageIcon(image2);
            }
            icon.paintIcon(jComponent, graphics, this.paintIconR.x, this.paintIconR.y);
        }
        if (string != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, this.paintTextR);
            } else {
                int n = this.paintTextR.x;
                int n2 = this.paintTextR.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics, string2, n, n2);
                } else {
                    this.paintDisabledText(jLabel, graphics, string2, n, n2);
                }
            }
        }
    }

    @NotNull
    private String layout(JLabel jLabel, FontMetrics fontMetrics, int n, int n2) {
        Insets insets = jLabel.getInsets(null);
        String string = jLabel.getText();
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        Rectangle rectangle = new Rectangle();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = n - (insets.left + insets.right);
        rectangle.height = n2 - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(jLabel, fontMetrics, string, icon, rectangle, this.paintIconR, this.paintTextR);
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        this.paintText(jLabel, graphics, string, n, n2);
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        this.paintText(jLabel, graphics, string, n, n2);
    }

    private void paintText(@NotNull JLabel jLabel, @NotNull Graphics graphics, @NotNull String string, int n, int n2) {
        Color color;
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (AquaMnemonicHandler.isMnemonicHidden()) {
            n3 = -1;
        }
        Color color2 = jLabel.getForeground();
        if (jLabel.getParent() == null && color2 == (color = UIManager.getColor("TitledBorder.titleColor"))) {
            AquaAppearance aquaAppearance = AppearanceManager.getCurrentAppearance();
            color2 = aquaAppearance.getColor("controlText");
        }
        graphics.setColor(color2);
        JavaSupport.drawStringUnderlineCharAt(jLabel, (Graphics2D)graphics, string, n3, n, n2);
    }
}

