/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.LayoutInfo;

public class BasicLayoutInfo
implements LayoutInfo {
    private final float fixedWidth;
    private final float fixedHeight;
    private final float minimumWidth;
    private final float minimumHeight;
    @NotNull
    private static final LayoutInfo EMPTY = new BasicLayoutInfo(0.0f, 0.0f, 0.0f, 0.0f);

    @NotNull
    public static LayoutInfo getInstance() {
        return EMPTY;
    }

    @NotNull
    public static LayoutInfo createFixedWidth(float f) {
        return new BasicLayoutInfo(f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public static LayoutInfo createFixedHeight(float f) {
        return new BasicLayoutInfo(0.0f, f, 0.0f, 0.0f);
    }

    @NotNull
    public static LayoutInfo createFixed(float f, float f2) {
        return new BasicLayoutInfo(f, f2, 0.0f, 0.0f);
    }

    @NotNull
    public static LayoutInfo createMinimumWidth(float f) {
        return new BasicLayoutInfo(0.0f, 0.0f, f, 0.0f);
    }

    @NotNull
    public static LayoutInfo createMinimumHeight(float f) {
        return new BasicLayoutInfo(0.0f, 0.0f, 0.0f, f);
    }

    @NotNull
    public static LayoutInfo createMinimum(float f, float f2) {
        return new BasicLayoutInfo(0.0f, 0.0f, f, f2);
    }

    @NotNull
    public static LayoutInfo create(boolean bl, float f, boolean bl2, float f2) {
        float f3 = bl ? f : 0.0f;
        float f4 = bl2 ? f2 : 0.0f;
        float f5 = bl ? 0.0f : f;
        float f6 = bl2 ? 0.0f : f2;
        return new BasicLayoutInfo(f3, f4, f5, f6);
    }

    private BasicLayoutInfo(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Invalid negative fixed width");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative fixed height");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative minimum width");
        }
        if (f4 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative minimum height");
        }
        if (f3 > 0.0f && f > 0.0f && f3 != f) {
            throw new IllegalArgumentException("Incompatible fixed and minimum width");
        }
        if (f4 > 0.0f && f2 > 0.0f && f4 != f2) {
            throw new IllegalArgumentException("Incompatible fixed and minimum height");
        }
        this.fixedWidth = f;
        this.fixedHeight = f2;
        this.minimumWidth = f3 > 0.0f ? f3 : f;
        this.minimumHeight = f4 > 0.0f ? f4 : f2;
    }

    @Override
    public float getFixedVisualWidth() {
        return this.fixedWidth;
    }

    @Override
    public float getFixedVisualHeight() {
        return this.fixedHeight;
    }

    @Override
    public float getMinimumVisualWidth() {
        return this.minimumWidth;
    }

    @Override
    public float getMinimumVisualHeight() {
        return this.minimumHeight;
    }
}

