/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.vappearances.VAppearance;

public class SliderCircularIndicatorPainter {
    @NotNull
    protected final Color DIMPLE_COLOR = new Color(160, 160, 160);
    @NotNull
    protected final Color DIMPLE_TOP = new Color(105, 105, 105);
    @NotNull
    protected final Color DARK_DIMPLE_COLOR = new Color(231, 231, 231);
    protected final double x;
    protected final double y;
    protected final double radius;
    protected final double zeroAngle;
    protected final double p;
    protected final boolean isDark;

    public SliderCircularIndicatorPainter(double d, double d2, double d3, double d4, double d5, @Nullable VAppearance vAppearance) {
        this.x = d;
        this.y = d2;
        this.radius = d3;
        this.zeroAngle = d4;
        this.p = d5;
        this.isDark = vAppearance != null && vAppearance.isDark();
    }

    public void paint(@NotNull Graphics2D graphics2D) {
        double d = 5.0;
        double d2 = this.zeroAngle - this.p * 2.0 * Math.PI;
        double d3 = this.x + Math.cos(d2) * this.radius;
        double d4 = this.y - Math.sin(d2) * this.radius;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d3 - d / 2.0, d4 - d / 2.0, d, d);
        graphics2D.setColor(this.isDark ? this.DARK_DIMPLE_COLOR : this.DIMPLE_COLOR);
        graphics2D.fill(double_);
        if (!this.isDark) {
            double_ = new Ellipse2D.Double(d3 - d / 4.0, d4 - d / 2.0, d / 2.0, d / 2.0);
            graphics2D.setColor(this.DIMPLE_TOP);
            graphics2D.fill(double_);
        }
    }
}

