/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Color;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ImageIconUIResource;

public class OSXFile {
    public static final int FILE_TYPE_ALIAS = 2;
    public static final int FILE_TYPE_DIRECTORY = 1;
    public static final int FILE_TYPE_FILE = 0;
    public static final int FILE_TYPE_UNKNOWN = -1;
    private static volatile Color[][] labelColors;
    private static String computerModel;
    private static boolean computerModelInitialized;
    private static ImageIcon computerSidebarIcon;
    private static final int kLSItemInfoIsPlainFile = 1;
    private static final int kLSItemInfoIsPackage = 2;
    private static final int kLSItemInfoIsApplication = 4;
    private static final int kLSItemInfoIsContainer = 8;
    private static final int kLSItemInfoIsAliasFile = 16;
    private static final int kLSItemInfoIsSymlink = 32;
    private static final int kLSItemInfoIsInvisible = 64;
    private static final int kLSItemInfoIsNativeApp = 128;
    private static final int kLSItemInfoIsClassicApp = 256;
    private static final int kLSItemInfoAppPrefersNative = 512;
    private static final int kLSItemInfoAppPrefersClassic = 1024;
    private static final int kLSItemInfoAppIsScriptable = 2048;
    private static final int kLSItemInfoIsVolume = 4096;
    private static final int kLSItemInfoExtensionIsHidden = 0x100000;
    private static final RecyclableFileIcon aliasBadgeIcon;
    private static final RecyclableFileIcon directoryIcon;
    private static final RecyclableFileIcon fileIcon;
    private static final RecyclableFileIcon networkIcon;
    private static final RecyclableSidebarIcon genericFileSidebarIcon;
    private static String[] nonTraversableDirectories;
    private static String computerName;
    private static boolean haveFetchedComputerName;
    public static final int SIDEBAR_FAVORITES = 0;
    public static final int SIDEBAR_VOLUMES = 1;
    private static final SharedFileList[] sharedFileLists;

    private static RecyclableFileIcon createIcon(@NotNull String string) {
        return OSXFile.createIcon(string, false);
    }

    private static RecyclableFileIcon createIcon(@NotNull String string, boolean bl) {
        String string2 = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/";
        return new RecyclableFileIcon(string2 + string + ".icns", bl);
    }

    private static RecyclableSidebarIcon createSidebarIcon(@NotNull String string) {
        String string2 = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/Sidebar";
        RecyclableSidebarIcon recyclableSidebarIcon = new RecyclableSidebarIcon(string2 + string + ".icns");
        return recyclableSidebarIcon;
    }

    public static ImageIcon getAliasBadgeIcon() {
        return aliasBadgeIcon.getInstance();
    }

    public static ImageIcon getDirectoryIcon() {
        return directoryIcon.getInstance();
    }

    public static Image getDirectoryIconImage(int n) {
        return directoryIcon.asImage(n);
    }

    public static ImageIcon getFileIcon() {
        return fileIcon.getInstance();
    }

    public static Image getFileIconImage(int n) {
        return fileIcon.asImage(n);
    }

    public static ImageIcon getNetworkIcon() {
        return networkIcon.getInstance();
    }

    public static ImageIcon getGenericFileSidebarIcon() {
        return genericFileSidebarIcon.getInstance();
    }

    private static boolean isNativeCodeAvailable() {
        return AquaNativeSupport.load();
    }

    private OSXFile() {
    }

    @NotNull
    public static File getAbsoluteFile(@NotNull File file) {
        if (!file.isAbsolute()) {
            file = new File(AquaUtils.getProperty("user.home") + File.separatorChar + file.getPath());
        }
        if (File.separatorChar == '\\') {
            return file;
        }
        StringBuffer stringBuffer = new StringBuffer(file.getPath().length());
        int n = 0;
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            String string = file2.getName();
            if (string.equals(".")) {
                if (n <= 0) continue;
                --n;
                continue;
            }
            if (string.equals("..")) {
                ++n;
                continue;
            }
            if (n > 0) {
                --n;
                continue;
            }
            stringBuffer.insert(0, string);
            stringBuffer.insert(0, File.separatorChar);
        }
        return file.getPath().equals(stringBuffer.toString()) ? file : new File(stringBuffer.toString());
    }

    public static boolean isAvailable() {
        return OSXFile.isNativeCodeAvailable();
    }

    public static int getFileType(@NotNull File file) {
        if (OSXFile.isNativeCodeAvailable()) {
            int n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            if ((n & 0x10) != 0) {
                if (file.getParent().equals("/Volumes")) {
                    return 1;
                }
                return 2;
            }
            if ((n & 8) != 0) {
                return 1;
            }
            if ((n & 1) != 0) {
                return 0;
            }
            return -1;
        }
        return file.isDirectory() ? 1 : (file.isFile() ? 0 : -1);
    }

    @NotNull
    public static File resolvePath(@NotNull String string, @Nullable File file) {
        if (string.startsWith("/")) {
            return new File(string);
        }
        if (string.startsWith("~")) {
            if ((string = string.substring(1)).startsWith("/")) {
                String string2 = System.getProperty("user.home");
                return new File(string2 + string);
            }
            if (string.isEmpty()) {
                String string3 = System.getProperty("user.home");
                return new File(string3);
            }
            return new File("/Users/" + string);
        }
        if (file == null) {
            String string4 = System.getProperty("user.home");
            file = new File(string4);
        }
        return new File(file, string);
    }

    @Nullable
    public static File resolve(@NotNull File file) {
        return OSXFile.resolveAlias(file, true);
    }

    @Nullable
    public static File resolveAlias(@NotNull File file, boolean bl) {
        if (OSXFile.isNativeCodeAvailable()) {
            String string = OSXFile.nativeResolveAlias(file.getAbsolutePath(), bl);
            if (string == null) {
                return null;
            }
            file = new File(string);
            if (OSXFile.getFileType(file) != 2) {
                return file;
            }
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    @Nullable
    public static File resolveAlias(byte[] byArray, boolean bl) {
        if (OSXFile.isNativeCodeAvailable()) {
            String string = OSXFile.nativeResolveAlias(byArray, bl);
            return string == null ? null : new File(string);
        }
        return null;
    }

    public static int getLabel(@Nullable File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            return OSXFile.nativeGetLabel(file.getAbsolutePath());
        }
        return -1;
    }

    @Nullable
    public static String getTagColorName(int n) {
        switch (n) {
            case 1: {
                return "systemGray";
            }
            case 2: {
                return "systemGreen";
            }
            case 3: {
                return "systemPurple";
            }
            case 4: {
                return "systemBlue";
            }
            case 5: {
                return "systemYellow";
            }
            case 6: {
                return "systemRed";
            }
            case 7: {
                return "systemOrange";
            }
        }
        return null;
    }

    @NotNull
    public static Image getIconImage(@Nullable File file, int n, boolean bl) throws UnsupportedOperationException {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            FileIconCreator fileIconCreator = new FileIconCreator(file, n, bl, true);
            return fileIconCreator.getImage();
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Image getThumbnailImage(@Nullable File file, int n) throws UnsupportedOperationException {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            FileIconCreator fileIconCreator = new FileIconCreator(file, n, true, false);
            return fileIconCreator.getImage();
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static String getKindString(@Nullable File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            return OSXFile.nativeGetKindString(file.getAbsolutePath());
        }
        return null;
    }

    public static boolean isVirtualFile(@Nullable File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            int n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            return (n & 2) != 0;
        }
        return false;
    }

    public static boolean isInvisible(@NotNull File file) {
        if (OSXFile.isNativeCodeAvailable()) {
            int n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            return (n & 0x40) != 0;
        }
        return file.isHidden();
    }

    public static boolean isTraversable(@Nullable File file) {
        return OSXFile.isTraversable(file, false, false);
    }

    public static boolean isTraversable(@Nullable File file, boolean bl, boolean bl2) {
        if (file == null) {
            return false;
        }
        if (OSXFile.isNativeCodeAvailable()) {
            int n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            if ((n & 0x10) != 0) {
                if ((file = OSXFile.resolve(file)) == null) {
                    return false;
                }
                n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            }
            if ((n & 9) == 8) {
                boolean bl3;
                boolean bl4 = (n & 2) != 0;
                boolean bl5 = bl3 = (n & 4) != 0;
                if (bl3) {
                    return bl2;
                }
                if (bl4) {
                    return bl;
                }
                return OSXFile.basicIsTraversable(file);
            }
            if ((n & 1) != 0) {
                return OSXFile.basicIsTraversable(file);
            }
            return OSXFile.isVolumes(file.getParent());
        }
        return OSXFile.basicIsTraversable(file);
    }

    private static boolean isVolumes(@Nullable String string) {
        return string != null && string.equals("/Volumes");
    }

    private static boolean basicIsTraversable(@NotNull File file) {
        String string = file.getName();
        if (file.isDirectory()) {
            for (String string2 : nonTraversableDirectories) {
                if (!string2.equals(string)) continue;
                return false;
            }
            return true;
        }
        return OSXFile.isSavedSearch(file);
    }

    public static boolean isSavedSearch(@NotNull File file) {
        return file.getName().endsWith(".savedSearch");
    }

    private static native int nativeGetFileType(String var0);

    private static native String nativeResolveAlias(String var0, boolean var1);

    private static native String nativeResolveAlias(byte[] var0, boolean var1);

    private static native int nativeGetLabel(String var0);

    private static native String nativeGetKindString(String var0);

    private static native int nativeGetBasicItemInfoFlags(String var0);

    @Nullable
    public static String getComputerName() {
        if (!haveFetchedComputerName) {
            haveFetchedComputerName = true;
            String[] stringArray = new String[]{"/usr/sbin/scutil", "--get", "ComputerName"};
            Charset charset = Charset.forName("UTF-8");
            String string = OSXFile.exec(stringArray, charset);
            computerName = string != null ? string.trim() : null;
        }
        return computerName;
    }

    @NotNull
    public static String getDisplayName(@NotNull File file) {
        String string;
        if (OSXFile.isNativeCodeAvailable() && (string = OSXFile.nativeGetDisplayName(file.getAbsolutePath())) != null) {
            return string;
        }
        return file.getName();
    }

    @Nullable
    public static Date getLastUsedDate(@NotNull File file) {
        if (OSXFile.isNativeCodeAvailable()) {
            long l = OSXFile.nativeGetLastUsedDate(file.getAbsolutePath());
            return l > 0L ? new Date(l) : null;
        }
        return null;
    }

    @Nullable
    public static File[] executedSavedSearch(@NotNull File file) {
        String string = file.getAbsolutePath();
        String[] stringArray = OSXFile.nativeExecuteSavedSearch(string);
        if (stringArray != null) {
            int n = stringArray.length;
            File[] fileArray = new File[n];
            for (int i = 0; i < n; ++i) {
                fileArray[i] = new File(stringArray[i]);
            }
            return fileArray;
        }
        return null;
    }

    @NotNull
    public static List<SystemItemInfo> getSidebarFiles(int n) {
        return sharedFileLists[n].getResults();
    }

    @Nullable
    public static String exec(@NotNull String[] stringArray, Charset charset) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
            StreamCollector streamCollector = new StreamCollector(inputStreamReader);
            streamCollector.start();
            int n = process.waitFor();
            streamCollector.join();
            return streamCollector.getContents();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static native String nativeGetDisplayName(String var0);

    private static native long nativeGetLastUsedDate(String var0);

    @Nullable
    private static native String[] nativeExecuteSavedSearch(String var0);

    @Nullable
    private static native Object[] nativeGetSidebarFiles(int var0, int var1, int var2);

    private static native boolean nativeRenderFileImage(@NotNull String var0, boolean var1, boolean var2, int[][] var3, int var4, int var5);

    static {
        aliasBadgeIcon = OSXFile.createIcon("AliasBadgeIcon");
        directoryIcon = OSXFile.createIcon("GenericFolderIcon");
        fileIcon = OSXFile.createIcon("GenericDocumentIcon", false);
        networkIcon = OSXFile.createIcon("GenericNetworkIcon");
        genericFileSidebarIcon = OSXFile.createSidebarIcon("GenericFile");
        nonTraversableDirectories = new String[]{".Spotlight-V100", ".DocumentRevisions", ".Trashes"};
        sharedFileLists = new SharedFileList[]{new SharedFileList(0, "Sidebar Favorites"), new SharedFileList(1, "Sidebar Volumes")};
    }

    private static class StreamCollector
    extends Thread {
        private BufferedReader br;
        private String result;

        public StreamCollector(Reader reader) {
            this.br = new BufferedReader(reader);
        }

        @Nullable
        public synchronized String getContents() {
            return this.result;
        }

        private synchronized void setContents(@NotNull String string) {
            this.result = string;
            this.notifyAll();
        }

        @Override
        public void run() {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[1000];
            block4: while (true) {
                try {
                    int n;
                    while ((n = this.br.read(cArray, 0, cArray.length)) >= 0) {
                        if (n > 0) {
                            stringBuilder.append(cArray, 0, n);
                            continue;
                        }
                        try {
                            Thread.sleep(200L);
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                    break;
                }
            }
            String string = stringBuilder.toString();
            this.setContents(string);
        }
    }

    private static class SharedFileList {
        private String name;
        private int which;
        private int lastSeed = -1;
        private List<SystemItemInfo> lastResults;

        public SharedFileList(int n, String string) {
            this.which = n;
            this.name = string;
            this.lastResults = new ArrayList<SystemItemInfo>();
        }

        @NotNull
        public List<SystemItemInfo> getResults() {
            int n = 18;
            Object[] objectArray = OSXFile.nativeGetSidebarFiles(this.which, 18, this.lastSeed);
            if (objectArray == null) {
                return this.lastResults;
            }
            this.lastSeed = (Integer)objectArray[0];
            int n2 = 0;
            ArrayList<SystemItemInfo> arrayList = new ArrayList<SystemItemInfo>();
            for (int i = 1; i < objectArray.length; i += 6) {
                String string = (String)objectArray[i];
                if (string == null) continue;
                Integer n3 = (Integer)objectArray[i + 1];
                Integer n4 = (Integer)objectArray[i + 2];
                String string2 = (String)objectArray[i + 3];
                int[] nArray = (int[])objectArray[i + 4];
                int[] nArray2 = (int[])objectArray[i + 5];
                if (string2 != null && (string.equals("Computer") || !string2.isEmpty() && !string2.endsWith(".cannedSearch"))) {
                    boolean bl = n4 == 0;
                    ImageIcon imageIcon = null;
                    if (nArray != null) {
                        imageIcon = new ImageIcon(AquaMultiResolutionImage.createImage(n, n, nArray, nArray2));
                    }
                    SystemItemInfo systemItemInfo = new SystemItemInfo(string, string2, n2++, bl, n3, imageIcon);
                    arrayList.add(systemItemInfo);
                    continue;
                }
                System.err.println("Skipping " + string);
            }
            this.lastResults = arrayList;
            return arrayList;
        }
    }

    public static class SystemItemInfo {
        @NotNull
        private final String name;
        @NotNull
        private final String path;
        private final int sequenceNumber;
        private final boolean isVisible;
        private int id;
        @Nullable
        private final Icon icon;
        private final boolean isComputer;

        public SystemItemInfo(@NotNull String string, @NotNull String string2, int n, boolean bl, int n2, @Nullable Icon icon) {
            boolean bl2 = this.isComputer = n2 == 1 || string.equals("Computer") && string2.isEmpty();
            if (this.isComputer && string2.isEmpty()) {
                string2 = "/Volumes";
            }
            if (string2.isEmpty()) {
                throw new IllegalArgumentException("Empty path");
            }
            this.name = SystemItemInfo.determineName(string, this.isComputer);
            this.path = string2;
            this.sequenceNumber = this.isComputer ? -2 : n;
            this.isVisible = bl;
            this.id = n2;
            this.icon = icon;
        }

        @NotNull
        private static String determineName(@NotNull String string, boolean bl) {
            String string2;
            if (bl && (string2 = OSXFile.getComputerName()) != null) {
                return string2;
            }
            return string;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        public boolean isComputer() {
            return this.isComputer;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public int getId() {
            return this.id;
        }

        @Nullable
        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            String string = this.sequenceNumber + ": " + this.name + " " + this.path + " " + this.id;
            if (!this.isVisible) {
                string = string + " (hidden)";
            }
            return string;
        }
    }

    private static class FileIconCreator {
        private final File file;
        private final int size;
        private final boolean useQuickLook;
        private final boolean useIconMode;
        private Image result;

        public FileIconCreator(@NotNull File file, int n, boolean bl, boolean bl2) {
            this.file = file;
            this.size = n;
            this.useQuickLook = bl;
            this.useIconMode = bl2;
        }

        @NotNull
        public Image getImage() {
            if (this.result == null) {
                int[][] nArrayArray;
                String string = this.file.getAbsolutePath();
                if (!OSXFile.nativeRenderFileImage(string, this.useQuickLook, this.useIconMode, nArrayArray = new int[2][], this.size, this.size)) {
                    if (AquaImageFactory.debugNativeRendering) {
                        System.err.println("Failed to render image for " + string);
                    }
                    throw new UnsupportedOperationException();
                }
                if (AquaImageFactory.debugNativeRendering) {
                    System.err.println("Rendered image for " + string);
                }
                this.result = AquaMultiResolutionImage.createImage(this.size, this.size, nArrayArray[0], nArrayArray[1]);
            }
            return this.result;
        }
    }

    private static class RecyclableSidebarIcon
    extends AquaUtils.RecyclableSingleton<ImageIcon> {
        @NotNull
        private final File file;

        public RecyclableSidebarIcon(@NotNull File file) {
            this.file = file;
        }

        public RecyclableSidebarIcon(@NotNull String string) {
            this.file = new File(string);
        }

        @Override
        protected ImageIcon getInstance() {
            return new ImageIcon(AquaImageFactory.getImage(this.file, 18));
        }
    }

    private static class RecyclableFileIcon
    extends AquaUtils.RecyclableSingleton<ImageIconUIResource> {
        @NotNull
        private final File file;
        private final boolean shouldConvertToTemplate;

        public RecyclableFileIcon(@NotNull File file, boolean bl) {
            this.file = file;
            this.shouldConvertToTemplate = bl;
        }

        public RecyclableFileIcon(@NotNull String string, boolean bl) {
            this.file = new File(string);
            this.shouldConvertToTemplate = bl;
        }

        @Override
        protected ImageIconUIResource getInstance() {
            Image image = AquaImageFactory.getImage(this.file, 16);
            if (this.shouldConvertToTemplate && !AquaImageFactory.isTemplateImage(image)) {
                image = AquaImageFactory.generateTemplateImage(image);
            }
            return new ImageIconUIResource(image);
        }

        public Image asImage(int n) {
            Image image = AquaImageFactory.getImage(this.file, n);
            if (this.shouldConvertToTemplate && !AquaImageFactory.isTemplateImage(image)) {
                image = AquaImageFactory.generateTemplateImage(image);
            }
            return image;
        }
    }
}

