/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FileChooserUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaCustomStyledWindow;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaUtils;

public class AquaSheetSupport {
    public static void showOptionPaneAsSheet(JDialog jDialog, final JOptionPane jOptionPane, final Consumer<Integer> consumer) throws UnsupportedOperationException {
        Runnable runnable = null;
        if (consumer != null) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    consumer.accept(AquaSheetSupport.getOption(jOptionPane));
                }
            };
        }
        AquaSheetSupport.displayAsSheet(jDialog, runnable);
    }

    private static int getOption(JOptionPane jOptionPane) {
        Object object = jOptionPane.getValue();
        if (object == null) {
            return -1;
        }
        Object[] objectArray = jOptionPane.getOptions();
        if (objectArray == null) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return -1;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static void showFileChooserAsSheet(Window window, final JFileChooser jFileChooser, final Consumer<Integer> consumer) throws UnsupportedOperationException {
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        String string = fileChooserUI.getDialogTitle(jFileChooser);
        jFileChooser.putClientProperty("AccessibleDescription", string);
        final JDialog jDialog = window instanceof Frame ? new JDialog((Window)((Frame)window), string, Dialog.ModalityType.MODELESS) : new JDialog((Window)((Dialog)window), string, Dialog.ModalityType.MODELESS);
        jDialog.setComponentOrientation(jFileChooser.getComponentOrientation());
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jFileChooser, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(window);
        final FileChooserActionListener fileChooserActionListener = new FileChooserActionListener(jDialog);
        jFileChooser.addActionListener(fileChooserActionListener);
        jFileChooser.rescanCurrentDirectory();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = fileChooserActionListener.returnValue;
                jFileChooser.removeActionListener(fileChooserActionListener);
                jDialog.getContentPane().removeAll();
                jDialog.dispose();
                if (consumer != null) {
                    consumer.accept(n);
                }
            }
        };
        try {
            AquaSheetSupport.displayAsSheet(jDialog, runnable);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            jDialog.getContentPane().removeAll();
            jDialog.dispose();
            throw unsupportedOperationException;
        }
    }

    public static void displayAsSheet(Window window, Runnable runnable) throws UnsupportedOperationException {
        int n;
        Window window2;
        Container container;
        Window window3 = window.getOwner();
        if (window3 == null) {
            throw new UnsupportedOperationException("Unable to display as sheet: no owner window");
        }
        if (!window3.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: owner window is not visible");
        }
        if (window.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: the window must not be visible");
        }
        if (window instanceof Dialog) {
            container = (Dialog)window;
            ((Dialog)container).setModalityType(Dialog.ModalityType.MODELESS);
        }
        AquaUtils.ensureWindowPeer(window);
        container = AquaUtils.getRootPane(window);
        Object object = null;
        Dimension dimension = window.getSize();
        if (container != null) {
            object = ((JComponent)container).getClientProperty("Aqua.backgroundStyle");
        }
        boolean bl = false;
        if (window instanceof Dialog) {
            window2 = (Dialog)window;
            if (!((Dialog)window2).isUndecorated()) {
                bl = true;
            }
        } else if (window instanceof Frame && !((Frame)(window2 = (Frame)window)).isUndecorated()) {
            bl = true;
        }
        int n2 = 0;
        AquaCustomStyledWindow aquaCustomStyledWindow = null;
        String string = null;
        if (bl && (aquaCustomStyledWindow = AquaUtils.getCustomStyledWindow(window)) != null && aquaCustomStyledWindow.getStyle() != 6) {
            assert (container != null);
            string = AquaRootPaneUI.getWindowStyleKey((JRootPane)container);
            ((JComponent)container).putClientProperty("Aqua.windowStyle", null);
        }
        if (bl) {
            try {
                n2 = AquaUtils.unsetTitledWindowStyle(window);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new UnsupportedOperationException("Unable to display as sheet: " + unsupportedOperationException.getMessage());
            }
        }
        if (container != null) {
            ((JComponent)container).putClientProperty("Aqua.backgroundStyle", "vibrantSheet");
            if (string != null) {
                ((JComponent)container).putClientProperty("Aqua.windowStyle", "undecorated");
            }
            window.validate();
            AquaUtils.paintImmediately(window, (JComponent)container);
        }
        SheetCloser sheetCloser = new SheetCloser(window, runnable, object, string, n2, dimension);
        if ("true".equals(System.getProperty("VAqua.injectSheetDisplayFailure"))) {
            System.err.println("Injected failure to display sheet");
            n = -1;
        } else {
            n = (int)AquaUtils.execute(window, l -> AquaSheetSupport.displayAsSheet(l, window3));
        }
        if (n != 0) {
            sheetCloser.dispose();
            throw new UnsupportedOperationException("Unable to display as sheet");
        }
        window.setVisible(true);
    }

    private static long displayAsSheet(long l, Window window) {
        return AquaUtils.execute(window, l2 -> AquaSheetSupport.nativeDisplayAsSheet(l, l2));
    }

    public static boolean isSheet(Window window) {
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        return jRootPane != null && AquaSheetSupport.isSheet(jRootPane);
    }

    public static boolean isSheet(@NotNull JComponent jComponent) {
        JRootPane jRootPane = jComponent.getRootPane();
        if (jRootPane != null) {
            Object object = jRootPane.getClientProperty("Aqua.backgroundStyle");
            return AquaSheetSupport.isSheetFromBackgroundStyle(object);
        }
        return false;
    }

    public static void registerIsSheetChangeListener(JRootPane jRootPane, ChangeListener changeListener) {
        jRootPane.addPropertyChangeListener("Aqua.backgroundStyle", new SheetPropertyChangeListener(jRootPane, changeListener));
    }

    public static void unregisterIsSheetChangeListener(JRootPane jRootPane, ChangeListener changeListener) {
        PropertyChangeListener[] propertyChangeListenerArray;
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = jRootPane.getPropertyChangeListeners("Aqua.backgroundStyle")) {
            SheetPropertyChangeListener sheetPropertyChangeListener;
            if (!(propertyChangeListener instanceof SheetPropertyChangeListener) || (sheetPropertyChangeListener = (SheetPropertyChangeListener)propertyChangeListener).rp != jRootPane || sheetPropertyChangeListener.l != changeListener) continue;
            jRootPane.removePropertyChangeListener("Aqua.backgroundStyle", sheetPropertyChangeListener);
        }
    }

    private static boolean isSheetFromBackgroundStyle(Object object) {
        return "vibrantSheet".equals(object);
    }

    private static native int nativeDisplayAsSheet(long var0, long var2);

    private static class SheetCloser
    extends WindowAdapter
    implements HierarchyListener {
        @NotNull
        private final Window w;
        @Nullable
        private final Runnable closeHandler;
        @Nullable
        private final Object oldBackgroundStyle;
        @Nullable
        private final String windowStyle;
        private final int oldTop;
        @NotNull
        private final Dimension originalSize;
        private boolean hasClosed = false;

        public SheetCloser(@NotNull Window window, @Nullable Runnable runnable, @Nullable Object object, @Nullable String string, int n, @NotNull Dimension dimension) {
            this.w = window;
            this.closeHandler = runnable;
            this.oldBackgroundStyle = object;
            this.windowStyle = string;
            this.oldTop = n;
            this.originalSize = dimension;
            window.addWindowListener(this);
            window.addHierarchyListener(this);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (hierarchyEvent.getChangeFlags() == 4L && !this.w.isVisible()) {
                this.completed();
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.completed();
        }

        private void completed() {
            if (!this.hasClosed) {
                this.hasClosed = true;
                this.dispose();
                if (this.closeHandler != null) {
                    this.closeHandler.run();
                }
            }
        }

        public void dispose() {
            this.w.removeWindowListener(this);
            this.w.removeHierarchyListener(this);
            JRootPane jRootPane = AquaUtils.getRootPane(this.w);
            if (jRootPane != null) {
                jRootPane.putClientProperty("Aqua.backgroundStyle", this.oldBackgroundStyle);
                if (this.oldTop > 0) {
                    AquaUtils.restoreTitledWindowStyle(this.w, this.oldTop, this.originalSize);
                    AquaUtils.syncAWTView(this.w);
                }
                if (this.windowStyle != null) {
                    jRootPane.putClientProperty("Aqua.windowStyle", this.windowStyle);
                }
            }
        }
    }

    private static class SheetPropertyChangeListener
    implements PropertyChangeListener {
        private JRootPane rp;
        private ChangeListener l;

        public SheetPropertyChangeListener(JRootPane jRootPane, ChangeListener changeListener) {
            this.rp = jRootPane;
            this.l = changeListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = AquaSheetSupport.isSheetFromBackgroundStyle(propertyChangeEvent.getOldValue());
            boolean bl2 = AquaSheetSupport.isSheetFromBackgroundStyle(propertyChangeEvent.getNewValue());
            if (bl2 != bl) {
                this.l.stateChanged(new ChangeEvent(this.rp));
            }
        }
    }

    private static class FileChooserActionListener
    implements ActionListener {
        private JDialog d;
        int returnValue = -1;

        public FileChooserActionListener(JDialog jDialog) {
            this.d = jDialog;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ApproveSelection")) {
                this.returnValue = 0;
                this.d.setVisible(false);
            } else if (string.equals("CancelSelection")) {
                this.returnValue = 1;
                this.d.setVisible(false);
            }
        }
    }
}

