/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaScrollPaneUI;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;

public class AquaScrollBarUI
extends ScrollBarUI
implements AquaComponentUI {
    public static final String INTERNAL_STYLE_CLIENT_PROPERTY_KEY = "JScrollBar.style";
    public static final String INTERNAL_THUMB_STYLE_CLIENT_PROPERTY_KEY = "JScrollBar.thumbStyle";
    private static final int kInitialDelay = 300;
    private static final int kNormalDelay = 100;
    protected float currentThumbPosition;
    protected boolean fIsDragging;
    @Nullable
    protected ScrollBarPart hitPart;
    protected boolean fisRolloverDisplay;
    protected Timer fScrollTimer;
    protected ScrollListener fScrollListener;
    protected TrackListener fTrackListener;
    protected ScrollBarPart fTrackHighlight = ScrollBarPart.NONE;
    protected ScrollBarPart fMousePart = ScrollBarPart.NONE;
    protected JScrollBar fScrollBar;
    protected ModelListener fModelListener;
    protected PropertyChangeListener fPropertyChangeListener;
    protected float alpha = 1.0f;
    protected final AquaUIPainter painter = AquaPainting.create();

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaScrollBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.fScrollBar = (JScrollBar)jComponent;
        this.installListeners();
        this.configureScrollBarColors();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.fScrollBar = null;
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected void installListeners() {
        this.fTrackListener = this.createTrackListener();
        this.fModelListener = this.createModelListener();
        this.fPropertyChangeListener = this.createPropertyChangeListener();
        this.fScrollBar.addMouseListener(this.fTrackListener);
        this.fScrollBar.addMouseMotionListener(this.fTrackListener);
        this.fScrollBar.getModel().addChangeListener(this.fModelListener);
        this.fScrollBar.addPropertyChangeListener(this.fPropertyChangeListener);
        AppearanceManager.installListener(this.fScrollBar);
        this.fScrollListener = this.createScrollListener();
        this.fScrollTimer = new Timer(100, this.fScrollListener);
        this.fScrollTimer.setInitialDelay(300);
    }

    protected void uninstallListeners() {
        this.fScrollTimer.stop();
        this.fScrollTimer = null;
        AppearanceManager.uninstallListener(this.fScrollBar);
        this.fScrollBar.getModel().removeChangeListener(this.fModelListener);
        this.fScrollBar.removeMouseListener(this.fTrackListener);
        this.fScrollBar.removeMouseMotionListener(this.fTrackListener);
        this.fScrollBar.removePropertyChangeListener(this.fPropertyChangeListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
    }

    protected void configureScrollBarColors() {
        LookAndFeel.installColors(this.fScrollBar, "ScrollBar.background", "ScrollBar.foreground");
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.ensureAppearance(jComponent);
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.alpha == 0.0f) {
            return;
        }
        Graphics2D graphics2D = null;
        if (this.alpha < 1.0f) {
            graphics2D = (Graphics2D)graphics.create();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
            graphics = graphics2D;
        }
        int n = this.fScrollBar.getWidth();
        int n2 = this.fScrollBar.getHeight();
        ScrollBarConfiguration scrollBarConfiguration = this.getConfiguration(false);
        int n3 = 0;
        int n4 = 0;
        if (scrollBarConfiguration.getWidget() == AquaUIPainter.ScrollBarWidget.OVERLAY) {
            int n5 = this.getScrollBarThickness(scrollBarConfiguration);
            if (scrollBarConfiguration.getOrientation() == AquaUIPainter.Orientation.HORIZONTAL) {
                n4 = n2 - n5;
                n2 = n5;
            } else if (!AquaScrollPaneUI.isRTLSupported || AquaUtils.isLeftToRight(this.fScrollBar)) {
                n3 = n - n5;
                n = n5;
            } else {
                n = n5;
            }
        }
        AquaUtils.configure(this.painter, jComponent, n, n2);
        Painter painter = this.painter.getPainter(scrollBarConfiguration);
        painter.paint(graphics, n3, n4);
        if (graphics2D != null) {
            graphics2D.dispose();
        }
    }

    protected ScrollBarConfiguration getConfiguration(boolean bl) {
        AquaUIPainter.ScrollBarWidget scrollBarWidget = this.getScrollBarWidget(bl);
        AquaUIPainter.ScrollBarKnobWidget scrollBarKnobWidget = this.getScrollBarKnobWidget(scrollBarWidget);
        AquaUIPainter.Size size = this.getScrollBarSize();
        AquaUIPainter.State state = this.getScrollBarState(scrollBarWidget);
        AquaUIPainter.Orientation orientation = this.getScrollBarOrientation();
        float f = this.getCurrentThumbPosition();
        float f2 = this.getCurrentThumbExtent();
        if ((double)f2 >= 0.999) {
            scrollBarKnobWidget = AquaUIPainter.ScrollBarKnobWidget.NONE;
        }
        Object object = this.fScrollBar.getClientProperty(INTERNAL_STYLE_CLIENT_PROPERTY_KEY);
        boolean bl2 = "sidebar".equals(object);
        return new ScrollBarConfiguration(scrollBarWidget, scrollBarKnobWidget, size, state, orientation, f, f2, bl2);
    }

    protected float getCurrentThumbPosition() {
        float f = Math.max(0, this.fScrollBar.getMaximum() - this.fScrollBar.getMinimum());
        float f2 = f - (float)this.fScrollBar.getModel().getExtent();
        this.currentThumbPosition = f2 <= 0.0f ? 0.0f : (float)(this.fScrollBar.getValue() - this.fScrollBar.getMinimum()) / f2;
        return this.currentThumbPosition;
    }

    protected float getCurrentThumbExtent() {
        float f = Math.max(0, this.fScrollBar.getMaximum() - this.fScrollBar.getMinimum());
        return f <= 0.0f ? 0.0f : (float)this.fScrollBar.getModel().getExtent() / f;
    }

    protected int getValueFromThumbPosition(float f) {
        int n = this.fScrollBar.getMinimum();
        int n2 = this.fScrollBar.getMaximum();
        int n3 = this.fScrollBar.getModel().getExtent();
        if (f <= 0.0f) {
            return n;
        }
        if (f >= 1.0f) {
            return n2 - n3;
        }
        float f2 = Math.max(0, n2 - n);
        float f3 = f2 - (float)n3;
        return Math.round((float)n + f * f3);
    }

    protected AquaUIPainter.ScrollBarWidget getScrollBarWidget(boolean bl) {
        if (this.isOverlayStyle()) {
            return this.fisRolloverDisplay || bl ? AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER : AquaUIPainter.ScrollBarWidget.OVERLAY;
        }
        return AquaUIPainter.ScrollBarWidget.LEGACY;
    }

    protected boolean isOverlayStyle() {
        Object object = this.fScrollBar.getClientProperty(INTERNAL_THUMB_STYLE_CLIENT_PROPERTY_KEY);
        if (object instanceof String) {
            String string = (String)object;
            return string.equals("overlayDark") || string.equals("overlayLight");
        }
        return false;
    }

    public boolean isDragging() {
        return this.fIsDragging;
    }

    protected AquaUIPainter.ScrollBarKnobWidget getScrollBarKnobWidget(AquaUIPainter.ScrollBarWidget scrollBarWidget) {
        String string;
        if (scrollBarWidget == AquaUIPainter.ScrollBarWidget.LEGACY) {
            return AquaUIPainter.ScrollBarKnobWidget.DEFAULT;
        }
        Object object = this.fScrollBar.getClientProperty(INTERNAL_THUMB_STYLE_CLIENT_PROPERTY_KEY);
        if (object instanceof String && (string = (String)object).equals("overlayLight")) {
            return AquaUIPainter.ScrollBarKnobWidget.LIGHT;
        }
        return AquaUIPainter.ScrollBarKnobWidget.DARK;
    }

    protected AquaUIPainter.Size getScrollBarSize() {
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(this.fScrollBar);
        return size == AquaUIPainter.Size.REGULAR ? AquaUIPainter.Size.REGULAR : AquaUIPainter.Size.SMALL;
    }

    protected AquaUIPainter.State getScrollBarState(@NotNull AquaUIPainter.ScrollBarWidget scrollBarWidget) {
        if (!this.fScrollBar.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (!AquaFocusHandler.isActive(this.fScrollBar)) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (this.fIsDragging) {
            return AquaUIPainter.State.PRESSED;
        }
        if (this.hitPart != null) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    protected AquaUIPainter.Orientation getScrollBarOrientation() {
        return this.isHorizontal() ? AquaUIPainter.Orientation.HORIZONTAL : AquaUIPainter.Orientation.VERTICAL;
    }

    protected int getThumbTrackPosition() {
        int n = this.fScrollBar.getWidth();
        int n2 = this.fScrollBar.getHeight();
        ScrollBarConfiguration scrollBarConfiguration = this.getConfiguration(false);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        AquaUILayoutInfo aquaUILayoutInfo = this.painter.getLayoutInfo();
        Rectangle2D rectangle2D = aquaUILayoutInfo.getScrollBarThumbBounds(rectangle, scrollBarConfiguration);
        return (int)(scrollBarConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL ? rectangle2D.getY() : rectangle2D.getX());
    }

    protected ScrollBarPart getPartHit(int n, int n2) {
        float f = this.getExtendedTrackPosition(n, n2);
        if (f < 0.0f) {
            return ScrollBarPart.TRACK_MIN;
        }
        if (f > 1.0f) {
            return ScrollBarPart.TRACK_MAX;
        }
        int n3 = this.fScrollBar.getWidth();
        int n4 = this.fScrollBar.getHeight();
        AquaUtils.configure(this.painter, this.fScrollBar, n3, n4);
        ScrollBarConfiguration scrollBarConfiguration = this.getConfiguration(false);
        boolean bl = this.isHorizontal();
        int n5 = bl ? n : n2;
        ScrollBarThumbConfiguration scrollBarThumbConfiguration = new ScrollBarThumbConfiguration(scrollBarConfiguration, n5);
        int n6 = this.painter.getScrollBarThumbHit(scrollBarThumbConfiguration);
        switch (n6) {
            case -1: {
                return ScrollBarPart.TRACK_MIN;
            }
            case 0: {
                return ScrollBarPart.THUMB;
            }
            case 1: {
                return ScrollBarPart.TRACK_MAX;
            }
        }
        return ScrollBarPart.NONE;
    }

    private float getExtendedTrackPosition(int n, int n2) {
        int n3 = this.fScrollBar.getWidth();
        int n4 = this.fScrollBar.getHeight();
        boolean bl = this.isHorizontal();
        int n5 = bl ? n : n2;
        AquaUIPainter.ScrollBarWidget scrollBarWidget = this.getScrollBarWidget(false);
        AquaUIPainter.Size size = this.getScrollBarSize();
        AquaUIPainter.Orientation orientation = this.getScrollBarOrientation();
        float f = this.getCurrentThumbExtent();
        ScrollBarThumbLayoutConfiguration scrollBarThumbLayoutConfiguration = new ScrollBarThumbLayoutConfiguration(scrollBarWidget, size, orientation, f, n5);
        AquaUtils.configure(this.painter, this.fScrollBar, n3, n4);
        return this.painter.getScrollBarThumbPosition(scrollBarThumbLayoutConfiguration, false);
    }

    public void layoutContainer(Container container) {
        this.fScrollBar.repaint();
        this.fScrollBar.revalidate();
    }

    protected Rectangle getTrackBounds() {
        return new Rectangle(0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight());
    }

    protected void setMouseHit(@Nullable ScrollBarPart scrollBarPart) {
        if (scrollBarPart != this.hitPart) {
            this.hitPart = scrollBarPart;
            this.fScrollBar.repaint();
        }
    }

    protected void startTimer(boolean bl) {
        this.fScrollTimer.setInitialDelay(bl ? 300 : 100);
        this.fScrollTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollByBlock(int n) {
        JScrollBar jScrollBar = this.fScrollBar;
        synchronized (jScrollBar) {
            int n2 = this.fScrollBar.getValue();
            int n3 = this.fScrollBar.getBlockIncrement(n);
            int n4 = n3 * (n > 0 ? 1 : -1);
            this.fScrollBar.setValue(n2 + n4);
            this.fTrackHighlight = n > 0 ? ScrollBarPart.TRACK_MAX : ScrollBarPart.TRACK_MIN;
            this.fScrollBar.repaint();
            this.fScrollListener.setDirection(n);
            this.fScrollListener.setScrollByBlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollByUnit(int n) {
        JScrollBar jScrollBar = this.fScrollBar;
        synchronized (jScrollBar) {
            int n2 = this.fScrollBar.getUnitIncrement(n);
            if (n <= 0) {
                n2 = -n2;
            }
            this.fScrollBar.setValue(n2 + this.fScrollBar.getValue());
            this.fScrollBar.repaint();
            this.fScrollListener.setDirection(n);
            this.fScrollListener.setScrollByBlock(false);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n = this.getScrollBarThickness();
        return this.isHorizontal() ? new Dimension(96, n) : new Dimension(n, 96);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        int n = this.getScrollBarThickness();
        return this.isHorizontal() ? new Dimension(54, n) : new Dimension(n, 54);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        int n = this.getScrollBarThickness();
        return this.isHorizontal() ? new Dimension(100000, n) : new Dimension(n, 100000);
    }

    public int getScrollBarThickness() {
        ScrollBarConfiguration scrollBarConfiguration = this.getConfiguration(true);
        return this.getScrollBarThickness(scrollBarConfiguration);
    }

    protected int getScrollBarThickness(LayoutConfiguration layoutConfiguration) {
        AquaUILayoutInfo aquaUILayoutInfo = this.painter.getLayoutInfo();
        LayoutInfo layoutInfo = aquaUILayoutInfo.getLayoutInfo(layoutConfiguration);
        float f = this.isHorizontal() ? layoutInfo.getMinimumVisualHeight() : layoutInfo.getMinimumVisualWidth();
        return (int)Math.ceil(f);
    }

    public void setRolloverDisplayState(boolean bl) {
        if (this.fisRolloverDisplay != bl) {
            this.fisRolloverDisplay = bl;
            this.fScrollBar.repaint();
        }
        this.hitPart = null;
    }

    public void setAlpha(float f) {
        if (f != this.alpha) {
            this.alpha = f;
            this.fScrollBar.repaint();
        }
    }

    protected boolean isHorizontal() {
        return this.fScrollBar.getOrientation() == 0;
    }

    static class HitUtil {
        HitUtil() {
        }

        static boolean isIncrement(ScrollBarPart scrollBarPart) {
            return scrollBarPart == ScrollBarPart.ARROW_MAX;
        }

        static boolean isDecrement(ScrollBarPart scrollBarPart) {
            return scrollBarPart == ScrollBarPart.ARROW_MIN;
        }

        static boolean isArrow(ScrollBarPart scrollBarPart) {
            return HitUtil.isIncrement(scrollBarPart) || HitUtil.isDecrement(scrollBarPart);
        }

        static boolean isTrack(ScrollBarPart scrollBarPart) {
            return scrollBarPart == ScrollBarPart.TRACK_MAX || scrollBarPart == ScrollBarPart.TRACK_MIN;
        }
    }

    protected class ScrollListener
    implements ActionListener {
        boolean fUseBlockIncrement;
        int fDirection = 1;

        protected ScrollListener() {
        }

        void setDirection(int n) {
            this.fDirection = n;
        }

        void setScrollByBlock(boolean bl) {
            this.fUseBlockIncrement = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fUseBlockIncrement) {
                ScrollBarPart scrollBarPart = AquaScrollBarUI.this.getPartHit(AquaScrollBarUI.this.fTrackListener.fCurrentMouseX, AquaScrollBarUI.this.fTrackListener.fCurrentMouseY);
                if (scrollBarPart == ScrollBarPart.TRACK_MIN || scrollBarPart == ScrollBarPart.TRACK_MAX) {
                    int n;
                    int n2 = n = scrollBarPart == ScrollBarPart.TRACK_MAX ? 1 : -1;
                    if (this.fDirection != n) {
                        this.fDirection = n;
                    }
                }
                AquaScrollBarUI.this.scrollByBlock(this.fDirection);
                scrollBarPart = AquaScrollBarUI.this.getPartHit(AquaScrollBarUI.this.fTrackListener.fCurrentMouseX, AquaScrollBarUI.this.fTrackListener.fCurrentMouseY);
                if (scrollBarPart == ScrollBarPart.THUMB) {
                    ((Timer)actionEvent.getSource()).stop();
                }
            } else {
                AquaScrollBarUI.this.scrollByUnit(this.fDirection);
            }
            if (this.fDirection > 0 && AquaScrollBarUI.this.fScrollBar.getValue() + AquaScrollBarUI.this.fScrollBar.getVisibleAmount() >= AquaScrollBarUI.this.fScrollBar.getMaximum()) {
                ((Timer)actionEvent.getSource()).stop();
            } else if (this.fDirection < 0 && AquaScrollBarUI.this.fScrollBar.getValue() <= AquaScrollBarUI.this.fScrollBar.getMinimum()) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected transient int fCurrentMouseX;
        protected transient int fCurrentMouseY;
        protected transient boolean fInArrows;
        protected transient boolean fStillInArrow = false;
        protected transient boolean fStillInTrack = false;
        protected transient int fFirstThumbTrackPosition;
        protected transient int fHitTrackPosition;

        protected TrackListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            if (this.fInArrows) {
                this.mouseReleasedInArrows(mouseEvent);
            } else {
                this.mouseReleasedInTrack(mouseEvent);
            }
            this.fInArrows = false;
            this.fStillInArrow = false;
            this.fStillInTrack = false;
            AquaScrollBarUI.this.fScrollBar.repaint();
            AquaScrollBarUI.this.fScrollBar.revalidate();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AquaScrollBarUI.this.fisRolloverDisplay = true;
            this.updateHit(mouseEvent);
            AquaScrollBarUI.this.fScrollBar.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AquaScrollBarUI.this.setMouseHit(null);
            AquaScrollBarUI.this.fScrollBar.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateHit(mouseEvent);
        }

        protected void updateHit(MouseEvent mouseEvent) {
            if (AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                ScrollBarPart scrollBarPart = AquaScrollBarUI.this.getPartHit(mouseEvent.getX(), mouseEvent.getY());
                AquaScrollBarUI.this.setMouseHit(scrollBarPart);
            } else {
                AquaScrollBarUI.this.setMouseHit(null);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            ScrollBarPart scrollBarPart = AquaScrollBarUI.this.getPartHit(mouseEvent.getX(), mouseEvent.getY());
            this.fInArrows = HitUtil.isArrow(scrollBarPart);
            if (this.fInArrows) {
                this.mousePressedInArrows(mouseEvent, scrollBarPart);
            } else if (scrollBarPart == ScrollBarPart.NONE) {
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.NONE;
            } else {
                this.mousePressedInTrack(mouseEvent, scrollBarPart);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            if (this.fInArrows) {
                this.mouseDraggedInArrows(mouseEvent);
            } else if (AquaScrollBarUI.this.fIsDragging) {
                this.mouseDraggedInTrack(mouseEvent);
            } else {
                ScrollBarPart scrollBarPart = AquaScrollBarUI.this.getPartHit(this.fCurrentMouseX, this.fCurrentMouseY);
                if (!HitUtil.isTrack(scrollBarPart)) {
                    this.fStillInTrack = false;
                }
                this.fCurrentMouseX = mouseEvent.getX();
                this.fCurrentMouseY = mouseEvent.getY();
                ScrollBarPart scrollBarPart2 = AquaScrollBarUI.this.getPartHit(mouseEvent.getX(), mouseEvent.getY());
                boolean bl = HitUtil.isTrack(scrollBarPart2);
                if (bl == this.fStillInTrack) {
                    return;
                }
                this.fStillInTrack = bl;
                if (!this.fStillInTrack) {
                    AquaScrollBarUI.this.fScrollTimer.stop();
                } else {
                    AquaScrollBarUI.this.fScrollListener.actionPerformed(new ActionEvent(AquaScrollBarUI.this.fScrollTimer, 0, ""));
                    AquaScrollBarUI.this.startTimer(false);
                }
            }
        }

        int getDragValue(int n, int n2, boolean bl) {
            float f = Math.max(0, AquaScrollBarUI.this.fScrollBar.getMaximum() - AquaScrollBarUI.this.fScrollBar.getMinimum());
            float f2 = f - (float)AquaScrollBarUI.this.fScrollBar.getModel().getExtent();
            if (f2 <= 0.0f) {
                return AquaScrollBarUI.this.fScrollBar.getMinimum();
            }
            AquaUIPainter.ScrollBarWidget scrollBarWidget = AquaScrollBarUI.this.getScrollBarWidget(false);
            AquaUIPainter.Size size = AquaScrollBarUI.this.getScrollBarSize();
            float f3 = AquaScrollBarUI.this.getCurrentThumbExtent();
            AquaUIPainter.Orientation orientation = AquaScrollBarUI.this.getScrollBarOrientation();
            boolean bl2 = orientation == AquaUIPainter.Orientation.HORIZONTAL;
            int n3 = bl2 ? n : n2;
            int n4 = n3 - this.fHitTrackPosition;
            int n5 = this.fFirstThumbTrackPosition + n4;
            AquaUtils.configure(AquaScrollBarUI.this.painter, AquaScrollBarUI.this.fScrollBar, AquaScrollBarUI.this.fScrollBar.getWidth(), AquaScrollBarUI.this.fScrollBar.getHeight());
            ScrollBarThumbLayoutConfiguration scrollBarThumbLayoutConfiguration = new ScrollBarThumbLayoutConfiguration(scrollBarWidget, size, orientation, f3, n5);
            float f4 = AquaScrollBarUI.this.painter.getScrollBarThumbPosition(scrollBarThumbLayoutConfiguration, bl);
            return AquaScrollBarUI.this.getValueFromThumbPosition(f4);
        }

        void mousePressedInArrows(MouseEvent mouseEvent, ScrollBarPart scrollBarPart) {
            int n = HitUtil.isIncrement(scrollBarPart) ? 1 : -1;
            this.fStillInArrow = true;
            AquaScrollBarUI.this.scrollByUnit(n);
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fScrollListener.setDirection(n);
            AquaScrollBarUI.this.fScrollListener.setScrollByBlock(false);
            AquaScrollBarUI.this.fMousePart = scrollBarPart;
            AquaScrollBarUI.this.startTimer(true);
        }

        void mouseReleasedInArrows(MouseEvent mouseEvent) {
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fMousePart = ScrollBarPart.NONE;
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(false);
        }

        void mouseDraggedInArrows(MouseEvent mouseEvent) {
            ScrollBarPart scrollBarPart = AquaScrollBarUI.this.getPartHit(mouseEvent.getX(), mouseEvent.getY());
            if (AquaScrollBarUI.this.fMousePart == scrollBarPart && this.fStillInArrow) {
                return;
            }
            if (AquaScrollBarUI.this.fMousePart != scrollBarPart && !HitUtil.isArrow(scrollBarPart)) {
                AquaScrollBarUI.this.fScrollTimer.stop();
                this.fStillInArrow = false;
                AquaScrollBarUI.this.fScrollBar.repaint();
            } else {
                AquaScrollBarUI.this.fMousePart = scrollBarPart;
                AquaScrollBarUI.this.fScrollListener.setDirection(HitUtil.isIncrement(scrollBarPart) ? 1 : -1);
                this.fStillInArrow = true;
                AquaScrollBarUI.this.fScrollListener.actionPerformed(new ActionEvent(AquaScrollBarUI.this.fScrollTimer, 0, ""));
                AquaScrollBarUI.this.startTimer(false);
            }
            AquaScrollBarUI.this.fScrollBar.repaint();
        }

        void mouseReleasedInTrack(MouseEvent mouseEvent) {
            if (AquaScrollBarUI.this.fTrackHighlight != ScrollBarPart.NONE) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            }
            AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.NONE;
            AquaScrollBarUI.this.fIsDragging = false;
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(false);
        }

        void mousePressedInTrack(MouseEvent mouseEvent, ScrollBarPart scrollBarPart) {
            boolean bl;
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(true);
            boolean bl2 = AquaScrollBarUI.this.isHorizontal();
            boolean bl3 = bl = scrollBarPart != ScrollBarPart.THUMB && OSXSystemProperties.isScrollToClick();
            if (mouseEvent.isAltDown()) {
                boolean bl4 = bl = !bl;
            }
            if (bl) {
                this.fFirstThumbTrackPosition = AquaScrollBarUI.this.getThumbTrackPosition();
                this.fHitTrackPosition = bl2 ? mouseEvent.getX() : mouseEvent.getY();
                this.moveToMouse(mouseEvent, false);
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.THUMB;
                AquaScrollBarUI.this.fIsDragging = true;
                return;
            }
            this.fCurrentMouseX = mouseEvent.getX();
            this.fCurrentMouseY = mouseEvent.getY();
            int n = 0;
            if (scrollBarPart == ScrollBarPart.TRACK_MIN) {
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.TRACK_MIN;
                n = -1;
            } else if (scrollBarPart == ScrollBarPart.TRACK_MAX) {
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.TRACK_MAX;
                n = 1;
            } else {
                this.fFirstThumbTrackPosition = AquaScrollBarUI.this.getThumbTrackPosition();
                this.fHitTrackPosition = bl2 ? mouseEvent.getX() : mouseEvent.getY();
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.THUMB;
                AquaScrollBarUI.this.fIsDragging = true;
                return;
            }
            AquaScrollBarUI.this.fIsDragging = false;
            this.fStillInTrack = true;
            AquaScrollBarUI.this.scrollByBlock(n);
            ScrollBarPart scrollBarPart2 = AquaScrollBarUI.this.getPartHit(this.fCurrentMouseX, this.fCurrentMouseY);
            if (scrollBarPart2 == ScrollBarPart.TRACK_MIN || scrollBarPart2 == ScrollBarPart.TRACK_MAX) {
                AquaScrollBarUI.this.fScrollTimer.stop();
                AquaScrollBarUI.this.fScrollListener.setDirection(scrollBarPart2 == ScrollBarPart.TRACK_MAX ? 1 : -1);
                AquaScrollBarUI.this.fScrollListener.setScrollByBlock(true);
                AquaScrollBarUI.this.startTimer(true);
            }
        }

        void mouseDraggedInTrack(MouseEvent mouseEvent) {
            this.moveToMouse(mouseEvent, true);
        }

        void moveToMouse(MouseEvent mouseEvent, boolean bl) {
            this.fCurrentMouseX = mouseEvent.getX();
            this.fCurrentMouseY = mouseEvent.getY();
            int n = AquaScrollBarUI.this.fScrollBar.getValue();
            int n2 = this.getDragValue(this.fCurrentMouseX, this.fCurrentMouseY, bl);
            if (n2 == n) {
                return;
            }
            AquaScrollBarUI.this.fScrollBar.setValue(n2);
            Rectangle rectangle = AquaScrollBarUI.this.getTrackBounds();
            AquaScrollBarUI.this.fScrollBar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AquaScrollBarUI.this.layoutContainer(AquaScrollBarUI.this.fScrollBar);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("model".equals(string)) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                BoundedRangeModel boundedRangeModel2 = (BoundedRangeModel)propertyChangeEvent.getNewValue();
                boundedRangeModel.removeChangeListener(AquaScrollBarUI.this.fModelListener);
                boundedRangeModel2.addChangeListener(AquaScrollBarUI.this.fModelListener);
                AquaScrollBarUI.this.fScrollBar.repaint();
                AquaScrollBarUI.this.fScrollBar.revalidate();
            } else if ("Frame.active".equals(string)) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            } else if (AquaScrollBarUI.INTERNAL_THUMB_STYLE_CLIENT_PROPERTY_KEY.equals(string)) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            }
        }
    }

    public static enum ScrollBarPart {
        NONE,
        THUMB,
        TRACK_MIN,
        TRACK_MAX,
        ARROW_MIN,
        ARROW_MAX;

    }
}

