/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ImageIconUIResource;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.aqua.ProcessedImageCache;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaImageFactory {
    public static final Object DARKEN_FOR_SELECTION = new Object();
    public static final Object DARKEN_FOR_PRESSED = new Object();
    public static final Object LIGHTEN_FOR_DISABLED = new Object();
    public static final Object LIGHTEN_100 = new LightenOperator(100);
    public static final Object LIGHTEN_50 = new LightenOperator(50);
    public static final Object LIGHTEN_25 = new LightenOperator(25);
    public static final Object INVERT_FOR_DARK_MODE = new Object();
    public static boolean debugNativeRendering = false;
    private static final int kAlertIconSize = 64;
    private static final AquaImageCache imageCache = new AquaImageCache();
    private static ImageIcon regularPopupMenuCheckIcon;
    private static ImageIcon smallPopupMenuCheckIcon;
    private static ImageIcon miniPopupMenuCheckIcon;
    private static final AppIconCompositor appIconCompositor;
    private static final TreeFolderIconUIResourceSingleton treeFolderIconResource;
    private static final TreeOpenFolderIconUIResourceSingleton treeOpenFolderIconResource;
    private static final TreeDocumentIconUIResourceSingleton treeDocumentIconResource;
    protected static final NamedImageSingleton northArrow;
    protected static final IconUIResourceSingleton northArrowIcon;
    protected static final NamedImageSingleton southArrow;
    protected static final IconUIResourceSingleton southArrowIcon;
    protected static final NamedImageSingleton westArrow;
    protected static final IconUIResourceSingleton westArrowIcon;
    protected static final NamedImageSingleton eastArrow;
    protected static final IconUIResourceSingleton eastArrowIcon;

    public static IconUIResource getComputerIcon() {
        return new IconUIResource(new AquaIcon.CachingScalingIcon(16, 16){

            @Override
            Image createImage() {
                return AquaImageFactory.getNSIcon("NSComputer");
            }
        });
    }

    public static IconUIResource getConfirmImageIcon() {
        return new IconUIResource(new AquaIcon.CachingScalingIcon(64, 64){

            @Override
            Image createImage() {
                return AquaImageFactory.getGenericJavaIcon();
            }
        });
    }

    public static ImageIconUIResource getCautionImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.getCautionIconImage());
    }

    public static ImageIconUIResource getStopImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.getStopIconImage());
    }

    public static ImageIconUIResource getLockImageIcon() {
        Image image = Toolkit.getDefaultToolkit().getImage("NSImage://NSSecurity");
        return AquaImageFactory.getAppIconCompositedOn(image);
    }

    static Image getGenericJavaIcon() {
        return AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return JavaSupport.getDockIconImage();
            }
        });
    }

    protected static ImageIconUIResource getAppIconCompositedOn(Image image) {
        return new ImageIconUIResource(AquaImageFactory.applyMapper(image, appIconCompositor));
    }

    public static Image applyMapper(Image image, AquaMultiResolutionImage.Mapper mapper) {
        return AquaMultiResolutionImage.apply(image, mapper);
    }

    private static BufferedImage getAppIconImageCompositedOn(Image image, int n) {
        int n2 = image.getWidth(null) * n;
        int n3 = (int)((double)n2 * 0.5);
        int n4 = n2 - n3;
        AquaIcon.CachingScalingIcon cachingScalingIcon = new AquaIcon.CachingScalingIcon(n3, n3){

            @Override
            Image createImage() {
                return AquaImageFactory.getGenericJavaIcon();
            }
        };
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 3);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n2, n2, null);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        cachingScalingIcon.paintIcon(null, graphics, n4, n4);
        graphics.dispose();
        return bufferedImage;
    }

    public static Image loadResource(String string) {
        URL uRL = AquaImageFactory.class.getResource(string);
        return uRL != null ? Toolkit.getDefaultToolkit().createImage(uRL) : null;
    }

    @Nullable
    public static Image getImage(@Nullable File file, int n) {
        if (file != null) {
            ImageFileIconCreator imageFileIconCreator = new ImageFileIconCreator(file, n, n);
            return imageFileIconCreator.getImage();
        }
        return null;
    }

    public static ImageIconUIResource getTreeFolderIcon() {
        return treeFolderIconResource.getInstance();
    }

    public static ImageIconUIResource getTreeOpenFolderIcon() {
        return treeOpenFolderIconResource.getInstance();
    }

    public static ImageIconUIResource getTreeDocumentIcon() {
        return treeDocumentIconResource.getInstance();
    }

    @Nullable
    public static Image getArrowImageForDirection(int n) {
        switch (n) {
            case 1: {
                return (Image)northArrow.get();
            }
            case 5: {
                return (Image)southArrow.get();
            }
            case 3: {
                return (Image)eastArrow.get();
            }
            case 7: {
                return (Image)westArrow.get();
            }
        }
        return null;
    }

    public static Icon getMenuUpArrowIcon() {
        return (Icon)northArrowIcon.get();
    }

    public static Icon getMenuDownArrowIcon() {
        return (Icon)southArrowIcon.get();
    }

    public static Icon getMenuArrowIcon() {
        return new ImageIcon(AquaImageFactory.getProcessedImage((Image)eastArrow.get(), LIGHTEN_25));
    }

    public static Icon getPopupMenuItemCheckIcon(AquaUIPainter.Size size) {
        if (size == AquaUIPainter.Size.SMALL) {
            return AquaImageFactory.getSmallPopupMenuItemCheckIcon();
        }
        if (size == AquaUIPainter.Size.MINI) {
            return AquaImageFactory.getMiniPopupMenuItemCheckIcon();
        }
        return AquaImageFactory.getRegularPopupMenuItemCheckIcon();
    }

    private static Icon getRegularPopupMenuItemCheckIcon() {
        if (regularPopupMenuCheckIcon == null) {
            regularPopupMenuCheckIcon = AquaImageFactory.getPopupMenuItemCheckIcon(10);
        }
        return regularPopupMenuCheckIcon;
    }

    private static Icon getSmallPopupMenuItemCheckIcon() {
        if (smallPopupMenuCheckIcon == null) {
            smallPopupMenuCheckIcon = AquaImageFactory.getPopupMenuItemCheckIcon(8);
        }
        return smallPopupMenuCheckIcon;
    }

    private static Icon getMiniPopupMenuItemCheckIcon() {
        if (miniPopupMenuCheckIcon == null) {
            miniPopupMenuCheckIcon = AquaImageFactory.getPopupMenuItemCheckIcon(6);
        }
        return miniPopupMenuCheckIcon;
    }

    private static ImageIcon getPopupMenuItemCheckIcon(int n) {
        Image image = AquaImageFactory.getNSImage("NSMenuCheckmark", n, n);
        return new ImageIcon(image);
    }

    public static Icon getMenuItemCheckIcon() {
        return new ImageIcon(AquaImageFactory.getProcessedImage(AquaImageFactory.getNSIcon("NSMenuCheckmark"), LIGHTEN_25));
    }

    public static Icon getMenuItemDashIcon() {
        return new ImageIcon(AquaImageFactory.getProcessedImage(AquaImageFactory.getNSIcon("NSMenuMixedState"), LIGHTEN_25));
    }

    @Nullable
    private static Image getNSImage(@NotNull String string, int n, int n2) {
        return AquaImageFactory.getNativeImage(string, n, n2);
    }

    private static Image getNSIcon(String string) {
        Image image = Toolkit.getDefaultToolkit().getImage("NSImage://" + string);
        return image;
    }

    @Nullable
    private static native Image getNativeImage(String var0, int var1, int var2);

    private static native boolean nativeRenderImageFile(String var0, int[][] var1, int var2, int var3);

    @NotNull
    public static Object getLightenOperator(int n) {
        return new LightenOperator(n);
    }

    @NotNull
    private static Image createProcessedImage(@NotNull Image image, @NotNull Object object) {
        if (object == DARKEN_FOR_SELECTION) {
            return AquaImageFactory.applyFilter(image, new GenerateSelectedDarkFilter());
        }
        if (object == DARKEN_FOR_PRESSED) {
            return AquaImageFactory.applyFilter(image, new GeneratePressedDarkFilter());
        }
        if (object == LIGHTEN_FOR_DISABLED) {
            return AquaImageFactory.applyFilter(image, new GenerateDisabledLightFilter());
        }
        if (object instanceof LightenOperator) {
            int n = ((LightenOperator)object).percent;
            GrayFilter grayFilter = new GrayFilter(true, n);
            return AquaMultiResolutionImage.apply(image, grayFilter);
        }
        if (object == INVERT_FOR_DARK_MODE) {
            if (AquaImageFactory.isTemplateImage(image)) {
                return image;
            }
            return AquaImageFactory.applyFilter(image, new InvertImageForDarkModeFilter());
        }
        return image;
    }

    public static boolean isTemplateImage(Image image) {
        return imageCache.isTemplateImage(image);
    }

    private static boolean determineTemplateImageStatus(@NotNull Image image) {
        TemplateFilter templateFilter = new TemplateFilter(Color.BLACK, true);
        new ImageIcon(image);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        Image image2 = JavaSupport.getResolutionVariant(image, n * 2, n2 * 2);
        Image image3 = AquaImageFactory.applyFilter(image2, templateFilter);
        new ImageIcon(image3);
        return templateFilter.isTemplate();
    }

    @NotNull
    public static Image generateTemplateImage(@NotNull Image image) {
        return AquaImageFactory.applyFilter(image, new GenerateTemplateFilter());
    }

    @NotNull
    public static Image getProcessedImage(@NotNull Image image, @NotNull Object object) {
        return imageCache.getProcessedImage(image, object);
    }

    @Nullable
    public static Image getProcessedImage(@NotNull Icon icon, @Nullable Object object) {
        return imageCache.getProcessedImage(icon, object);
    }

    private static Image createImageFromTemplate(Image image, Color color) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcIn);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image applyFilter(Image image, ImageFilter imageFilter) {
        return JavaSupport.applyFilter(image, imageFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Image waitForImage(@NotNull Image image2) {
        boolean[] blArray = new boolean[]{false};
        ImageObserver imageObserver = (image, n, n2, n3, n4, n5) -> {
            if (n4 != -1 && n5 != -1 && (n & 0x20) != 0 || (n & 0x80) != 0) {
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    blArray[0] = true;
                    blArray.notify();
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return false;
                }
            }
            return true;
        };
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            while (!blArray[0] && image2.getWidth(imageObserver) == -1) {
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return image2;
        }
    }

    static {
        appIconCompositor = new AppIconCompositor();
        treeFolderIconResource = new TreeFolderIconUIResourceSingleton();
        treeOpenFolderIconResource = new TreeOpenFolderIconUIResourceSingleton();
        treeDocumentIconResource = new TreeDocumentIconUIResourceSingleton();
        northArrow = new NamedImageSingleton("NSMenuScrollUp");
        northArrowIcon = new IconUIResourceSingleton(northArrow);
        southArrow = new NamedImageSingleton("NSMenuScrollDown");
        southArrowIcon = new IconUIResourceSingleton(southArrow);
        westArrow = new NamedImageSingleton("NSMenuSubmenuLeft");
        westArrowIcon = new IconUIResourceSingleton(westArrow);
        eastArrow = new NamedImageSingleton("NSMenuSubmenu");
        eastArrowIcon = new IconUIResourceSingleton(eastArrow);
    }

    private static class InvertImageForDarkModeFilter
    extends RGBImageFilter {
        public InvertImageForDarkModeFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = (int)((0.3 * (double)(n3 >> 16 & 0xFF) + 0.59 * (double)(n3 >> 8 & 0xFF) + 0.11 * (double)(n3 & 0xFF)) / 3.0);
            if ((n4 = (int)((double)(255 - n4) * 0.7)) < 0) {
                n4 = 0;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            return n3 & 0xFF000000 | n4 << 16 | n4 << 8 | n4 << 0;
        }
    }

    private static class GenerateTemplateFilter
    extends RGBImageFilter {
        public GenerateTemplateFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 24 & 0xFF;
            int n5 = n3 & 0xFFFFFF;
            if (n5 > 0) {
                n4 = n4 * (n5 &= 0xFF) / 255;
            }
            return n4 << 24;
        }
    }

    private static class TemplateFilter
    extends RGBImageFilter {
        private final int replacementAlpha;
        private final int replacementRGB;
        private final boolean isForTesting;
        private boolean isTemplate;

        public TemplateFilter(Color color, boolean bl) {
            this.replacementRGB = color.getRGB() & 0xFFFFFF;
            this.replacementAlpha = color.getAlpha();
            this.isForTesting = bl;
            this.canFilterIndexColorModel = true;
            this.isTemplate = true;
        }

        @Override
        public Object clone() {
            if (this.isForTesting) {
                return this;
            }
            return super.clone();
        }

        public boolean isTemplate() {
            return this.isTemplate;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 24 & 0xFF;
            int n5 = n3 & 0xFFFFFF;
            if (n4 != 0 && n5 != 0) {
                this.isTemplate = false;
            }
            n4 = n4 * this.replacementAlpha / 255;
            return n4 << 24 | this.replacementRGB;
        }
    }

    private static abstract class IconImageFilter
    extends RGBImageFilter {
        IconImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            int n7 = this.getGreyFor((int)((0.3 * (double)n4 + 0.59 * (double)n5 + 0.11 * (double)n6) / 3.0));
            return n3 & 0xFF000000 | IconImageFilter.grayTransform(n4, n7) << 16 | IconImageFilter.grayTransform(n5, n7) << 8 | IconImageFilter.grayTransform(n6, n7) << 0;
        }

        private static int grayTransform(int n, int n2) {
            int n3 = n - n2;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            return n3;
        }

        abstract int getGreyFor(int var1);
    }

    private static class GenerateDisabledLightFilter
    extends RGBImageFilter {
        public GenerateDisabledLightFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            return n3 & 0xFF000000 | this.transform(n4) << 16 | this.transform(n5) << 8 | this.transform(n6) << 0;
        }

        protected int transform(int n) {
            int n2 = 255 - (255 - n) * 50 / 100;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            return n2;
        }
    }

    private static class GeneratePressedDarkFilter
    extends RGBImageFilter {
        public GeneratePressedDarkFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            return n3 & 0xFF000000 | this.transform(n4) << 16 | this.transform(n5) << 8 | this.transform(n6) << 0;
        }

        protected int transform(int n) {
            int n2 = n * 40 / 100;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            return n2;
        }
    }

    private static class GenerateSelectedDarkFilter
    extends IconImageFilter {
        private GenerateSelectedDarkFilter() {
        }

        @Override
        int getGreyFor(int n) {
            return n * 75 / 100;
        }
    }

    private static class LightenOperator {
        int percent;

        public LightenOperator(int n) {
            this.percent = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LightenOperator lightenOperator = (LightenOperator)object;
            return this.percent == lightenOperator.percent;
        }

        public int hashCode() {
            return Objects.hash(this.percent);
        }
    }

    public static class SlicedImageControl {
        protected final BufferedImage NW;
        protected final BufferedImage N;
        protected final BufferedImage NE;
        protected final BufferedImage W;
        protected final BufferedImage C;
        protected final BufferedImage E;
        protected final BufferedImage SW;
        protected final BufferedImage S;
        protected final BufferedImage SE;
        protected final NineSliceMetrics metrics;
        protected final int totalWidth;
        protected final int totalHeight;
        protected final int centerColWidth;
        protected final int centerRowHeight;

        public SlicedImageControl(Image image, int n, int n2, int n3, int n4) {
            this(image, n, n2, n3, n4, true);
        }

        public SlicedImageControl(Image image, int n, int n2, int n3, int n4, boolean bl) {
            this(image, n, n2, n3, n4, bl, true, true);
        }

        public SlicedImageControl(Image image, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
            this(image, new NineSliceMetrics(image.getWidth(null), image.getHeight(null), n, n2, n3, n4, bl, bl2, bl3));
        }

        public SlicedImageControl(Image image, NineSliceMetrics nineSliceMetrics) {
            this.metrics = nineSliceMetrics;
            if (image.getWidth(null) != nineSliceMetrics.minW || image.getHeight(null) != nineSliceMetrics.minH) {
                throw new IllegalArgumentException("SlicedImageControl: template image and NineSliceMetrics don't agree on minimum dimensions");
            }
            this.totalWidth = nineSliceMetrics.minW;
            this.totalHeight = nineSliceMetrics.minH;
            this.centerColWidth = this.totalWidth - nineSliceMetrics.wCut - nineSliceMetrics.eCut;
            this.centerRowHeight = this.totalHeight - nineSliceMetrics.nCut - nineSliceMetrics.sCut;
            this.NW = SlicedImageControl.createSlice(image, 0, 0, nineSliceMetrics.wCut, nineSliceMetrics.nCut);
            this.N = SlicedImageControl.createSlice(image, nineSliceMetrics.wCut, 0, this.centerColWidth, nineSliceMetrics.nCut);
            this.NE = SlicedImageControl.createSlice(image, this.totalWidth - nineSliceMetrics.eCut, 0, nineSliceMetrics.eCut, nineSliceMetrics.nCut);
            this.W = SlicedImageControl.createSlice(image, 0, nineSliceMetrics.nCut, nineSliceMetrics.wCut, this.centerRowHeight);
            this.C = nineSliceMetrics.showMiddle ? SlicedImageControl.createSlice(image, nineSliceMetrics.wCut, nineSliceMetrics.nCut, this.centerColWidth, this.centerRowHeight) : null;
            this.E = SlicedImageControl.createSlice(image, this.totalWidth - nineSliceMetrics.eCut, nineSliceMetrics.nCut, nineSliceMetrics.eCut, this.centerRowHeight);
            this.SW = SlicedImageControl.createSlice(image, 0, this.totalHeight - nineSliceMetrics.sCut, nineSliceMetrics.wCut, nineSliceMetrics.sCut);
            this.S = SlicedImageControl.createSlice(image, nineSliceMetrics.wCut, this.totalHeight - nineSliceMetrics.sCut, this.centerColWidth, nineSliceMetrics.sCut);
            this.SE = SlicedImageControl.createSlice(image, this.totalWidth - nineSliceMetrics.eCut, this.totalHeight - nineSliceMetrics.sCut, nineSliceMetrics.eCut, nineSliceMetrics.sCut);
        }

        static BufferedImage createSlice(Image image, int n, int n2, int n3, int n4) {
            if (n3 == 0 || n4 == 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, n3, n4, n, n2, n + n3, n2 + n4, null);
            graphics2D.dispose();
            return bufferedImage;
        }

        public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (n3 < this.totalWidth || n4 < this.totalHeight) {
                this.paintCompressed(graphics, n3, n4);
            } else {
                this.paintStretchedMiddles(graphics, n3, n4);
            }
            graphics.translate(-n, -n2);
        }

        void paintStretchedMiddles(Graphics graphics, int n, int n2) {
            int n3;
            int n4 = this.metrics.stretchH ? 0 : n / 2 - this.totalWidth / 2;
            int n5 = this.metrics.stretchV ? 0 : n2 / 2 - this.totalHeight / 2;
            int n6 = this.metrics.stretchH ? n : this.totalWidth;
            int n7 = n3 = this.metrics.stretchV ? n2 : this.totalHeight;
            if (this.NW != null) {
                graphics.drawImage(this.NW, n4, n5, null);
            }
            if (this.N != null) {
                graphics.drawImage(this.N, n4 + this.metrics.wCut, n5, n6 - this.metrics.eCut - this.metrics.wCut, this.metrics.nCut, null);
            }
            if (this.NE != null) {
                graphics.drawImage(this.NE, n4 + n6 - this.metrics.eCut, n5, null);
            }
            if (this.W != null) {
                graphics.drawImage(this.W, n4, n5 + this.metrics.nCut, this.metrics.wCut, n3 - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.C != null) {
                graphics.drawImage(this.C, n4 + this.metrics.wCut, n5 + this.metrics.nCut, n6 - this.metrics.eCut - this.metrics.wCut, n3 - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.E != null) {
                graphics.drawImage(this.E, n4 + n6 - this.metrics.eCut, n5 + this.metrics.nCut, this.metrics.eCut, n3 - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.SW != null) {
                graphics.drawImage(this.SW, n4, n5 + n3 - this.metrics.sCut, null);
            }
            if (this.S != null) {
                graphics.drawImage(this.S, n4 + this.metrics.wCut, n5 + n3 - this.metrics.sCut, n6 - this.metrics.eCut - this.metrics.wCut, this.metrics.sCut, null);
            }
            if (this.SE != null) {
                graphics.drawImage(this.SE, n4 + n6 - this.metrics.eCut, n5 + n3 - this.metrics.sCut, null);
            }
        }

        void paintCompressed(Graphics graphics, int n, int n2) {
            double d = n2 > this.totalHeight ? 1.0 : (double)n2 / (double)this.totalHeight;
            double d2 = n > this.totalWidth ? 1.0 : (double)n / (double)this.totalWidth;
            int n3 = (int)((double)this.metrics.nCut * d);
            int n4 = (int)((double)this.metrics.sCut * d);
            int n5 = n2 - n3 - n4;
            int n6 = (int)((double)this.metrics.wCut * d2);
            int n7 = (int)((double)this.metrics.eCut * d2);
            int n8 = n - n6 - n7;
            if (this.NW != null) {
                graphics.drawImage(this.NW, 0, 0, n6, n3, null);
            }
            if (this.N != null) {
                graphics.drawImage(this.N, n6, 0, n8, n3, null);
            }
            if (this.NE != null) {
                graphics.drawImage(this.NE, n - n7, 0, n7, n3, null);
            }
            if (this.W != null) {
                graphics.drawImage(this.W, 0, n3, n6, n5, null);
            }
            if (this.C != null) {
                graphics.drawImage(this.C, n6, n3, n8, n5, null);
            }
            if (this.E != null) {
                graphics.drawImage(this.E, n - n7, n3, n7, n5, null);
            }
            if (this.SW != null) {
                graphics.drawImage(this.SW, 0, n2 - n4, n6, n4, null);
            }
            if (this.S != null) {
                graphics.drawImage(this.S, n6, n2 - n4, n8, n4, null);
            }
            if (this.SE != null) {
                graphics.drawImage(this.SE, n - n7, n2 - n4, n7, n4, null);
            }
        }
    }

    public static class NineSliceMetrics {
        public final int wCut;
        public final int eCut;
        public final int nCut;
        public final int sCut;
        public final int minW;
        public final int minH;
        public final boolean showMiddle;
        public final boolean stretchH;
        public final boolean stretchV;

        public NineSliceMetrics(int n, int n2, int n3, int n4, int n5, int n6) {
            this(n, n2, n3, n4, n5, n6, true);
        }

        public NineSliceMetrics(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            this(n, n2, n3, n4, n5, n6, bl, true, true);
        }

        public NineSliceMetrics(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3) {
            this.wCut = n3;
            this.eCut = n4;
            this.nCut = n5;
            this.sCut = n6;
            this.minW = n;
            this.minH = n2;
            this.showMiddle = bl;
            this.stretchH = bl2;
            this.stretchV = bl3;
        }
    }

    static class IconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<ImageIconUIResource> {
        protected final NamedImageSingleton holder;

        public IconUIResourceSingleton(NamedImageSingleton namedImageSingleton) {
            this.holder = namedImageSingleton;
        }

        @Override
        protected ImageIconUIResource getInstance() {
            return new ImageIconUIResource((Image)this.holder.get());
        }
    }

    static class NamedImageSingleton
    extends AquaUtils.RecyclableSingleton<Image> {
        protected final String namedImage;

        NamedImageSingleton(String string) {
            this.namedImage = string;
        }

        @Override
        protected Image getInstance() {
            return AquaImageFactory.getNSIcon(this.namedImage);
        }
    }

    private static class TreeDocumentIconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<ImageIconUIResource> {
        private TreeDocumentIconUIResourceSingleton() {
        }

        @Override
        protected ImageIconUIResource getInstance() {
            Image image = OSXFile.getFileIconImage(20);
            return new ImageIconUIResource(image);
        }
    }

    private static class TreeOpenFolderIconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<ImageIconUIResource> {
        private TreeOpenFolderIconUIResourceSingleton() {
        }

        @Override
        protected ImageIconUIResource getInstance() {
            return AquaIcon.getOpenFolderIcon();
        }
    }

    private static class TreeFolderIconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<ImageIconUIResource> {
        private TreeFolderIconUIResourceSingleton() {
        }

        @Override
        protected ImageIconUIResource getInstance() {
            Image image = OSXFile.getDirectoryIconImage(20);
            return new ImageIconUIResource(image);
        }
    }

    private static class ImageFileIconCreator {
        private String path;
        private int width;
        private int height;
        private Image result;

        public ImageFileIconCreator(File file, int n, int n2) {
            this.path = file.getAbsolutePath();
            this.width = n;
            this.height = n2;
        }

        public Image getImage() {
            if (this.result == null) {
                AquaNativeSupport.load();
                int[][] nArrayArray = new int[2][];
                if (!AquaImageFactory.nativeRenderImageFile(this.path, nArrayArray, this.width, this.height)) {
                    if (debugNativeRendering) {
                        System.err.println("Failed to render image file " + this.path);
                    }
                    throw new UnsupportedOperationException();
                }
                if (debugNativeRendering) {
                    System.err.println("Rendered image file " + this.path);
                }
                this.result = AquaMultiResolutionImage.createImage(this.width, this.height, nArrayArray[0], nArrayArray[1]);
            }
            return this.result;
        }
    }

    private static class AppIconCompositor
    implements AquaMultiResolutionImage.Mapper {
        private AppIconCompositor() {
        }

        @Override
        public BufferedImage map(Image image, int n) {
            return AquaImageFactory.getAppIconImageCompositedOn(image, n);
        }
    }

    static class AquaImageCache
    extends ProcessedImageCache {
        AquaImageCache() {
        }

        @Override
        protected boolean determineTemplateImage(@NotNull Image image) {
            return AquaImageFactory.determineTemplateImageStatus(image);
        }

        @Override
        @NotNull
        protected Image createImageFromTemplate(@NotNull Image image, @NotNull Color color) {
            return AquaImageFactory.createImageFromTemplate(image, color);
        }

        @Override
        @NotNull
        protected Image createProcessedImage(@NotNull Image image, @NotNull Object object) {
            return AquaImageFactory.createProcessedImage(image, object);
        }
    }
}

