/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaAppearances;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;

public class AppearanceManager {
    public static final String AQUA_APPEARANCE_NAME_KEY = "Aqua.appearanceName";
    public static final String AQUA_APPEARANCE_KEY = "Aqua.appearance";
    private static final AppearanceManagerHierarchyListener hierarchyListener = new AppearanceManagerHierarchyListener();
    private static final ActiveStateListener activeStateListener = new ActiveStateListener();
    @Nullable
    private static AquaAppearance currentAppearance;
    private static Set<Class> notifiedClasses;

    @NotNull
    public static AquaAppearance getCurrentAppearance() {
        if (currentAppearance != null) {
            return currentAppearance;
        }
        return AquaAppearances.getDefaultAppearance();
    }

    @Nullable
    public static AquaAppearance registerCurrentAppearance(@NotNull JComponent jComponent) {
        Class<?> clazz;
        AquaAppearance aquaAppearance = AppearanceManager.getRegisteredAppearance(jComponent);
        if (aquaAppearance != null && aquaAppearance != currentAppearance) {
            currentAppearance = aquaAppearance;
        } else if (aquaAppearance == null && !notifiedClasses.contains(clazz = jComponent.getClass())) {
            notifiedClasses.add(clazz);
            System.err.println("No appearance for: " + clazz.getName() + " should ensure appearance?");
        }
        return currentAppearance;
    }

    public static void restoreCurrentAppearance(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance != currentAppearance) {
            currentAppearance = aquaAppearance;
            System.err.println("Restored appearance: " + currentAppearance);
        }
    }

    public static void installListener(@NotNull JComponent jComponent) {
        AquaComponentUI aquaComponentUI = AquaUtils.getUI(jComponent, AquaComponentUI.class);
        if (aquaComponentUI == null) {
            throw new IllegalArgumentException("Component must support AquaComponentUI");
        }
        jComponent.addHierarchyListener(hierarchyListener);
        jComponent.addPropertyChangeListener("Frame.active", activeStateListener);
    }

    public static void uninstallListener(@NotNull Component component) {
        component.removeHierarchyListener(hierarchyListener);
        component.removePropertyChangeListener("Frame.active", activeStateListener);
    }

    public static void installAppearance(@NotNull JComponent jComponent, @Nullable AquaAppearance aquaAppearance) {
        AquaAppearance aquaAppearance2;
        if (aquaAppearance != null && aquaAppearance != (aquaAppearance2 = AppearanceManager.getRegisteredAppearance(jComponent))) {
            try {
                jComponent.putClientProperty(AQUA_APPEARANCE_KEY, aquaAppearance);
            }
            catch (Throwable throwable) {
                System.err.println("Error setting appearance property. Check for failure in a property change listener");
                throwable.printStackTrace();
            }
            AppearanceManager.appearanceHasChanged(jComponent, aquaAppearance);
        }
    }

    public static void uninstallAppearance(@NotNull JComponent jComponent) {
        try {
            jComponent.putClientProperty(AQUA_APPEARANCE_KEY, null);
        }
        catch (Throwable throwable) {
            System.err.println("Error uninstalling appearance property. Check for failure in a property change listener");
            throwable.printStackTrace();
        }
    }

    public static void updateAppearancesInSubtree(@NotNull Component component) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            AppearanceManager.ensureAppearance(container);
        }
        if (component instanceof Container) {
            container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                AppearanceManager.updateAppearancesInSubtree(component2);
            }
        }
    }

    @NotNull
    public static AquaAppearance ensureAppearance(@NotNull Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            AquaAppearance aquaAppearance = AppearanceManager.getRegisteredAppearance(jComponent);
            AquaAppearance aquaAppearance2 = AppearanceManager.getAppearanceForJComponent(jComponent);
            if (aquaAppearance2 != aquaAppearance) {
                AppearanceManager.installAppearance(jComponent, aquaAppearance2);
            }
            return aquaAppearance2;
        }
        return AppearanceManager.getInheritedAppearance(component);
    }

    @NotNull
    private static AquaAppearance getAppearanceForComponent(@NotNull Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            return AppearanceManager.getAppearanceForJComponent(jComponent);
        }
        return AppearanceManager.getInheritedAppearance(component);
    }

    @NotNull
    private static AquaAppearance getAppearanceForJComponent(@NotNull JComponent jComponent) {
        boolean bl = AquaVibrantSupport.isVibrant(jComponent) && !(jComponent instanceof JRootPane);
        String string = AppearanceManager.getRegisteredAppearanceName(jComponent);
        if (string != null) {
            AquaAppearance aquaAppearance = AquaAppearances.get(string);
            if (bl) {
                aquaAppearance = AquaAppearances.getVibrantAppearance(aquaAppearance);
            }
            return aquaAppearance;
        }
        AquaAppearance aquaAppearance = AppearanceManager.getInheritedAppearance(jComponent);
        if (bl) {
            aquaAppearance = AquaAppearances.getVibrantAppearance(aquaAppearance);
        }
        return aquaAppearance;
    }

    @NotNull
    private static AquaAppearance getAppearanceForComponent(@NotNull Component component, @NotNull AquaAppearance aquaAppearance) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            boolean bl = AquaVibrantSupport.isVibrant(jComponent) && !(jComponent instanceof JRootPane);
            String string = AppearanceManager.getRegisteredAppearanceName(jComponent);
            if (string != null) {
                AquaAppearance aquaAppearance2 = AquaAppearances.get(string);
                if (bl) {
                    aquaAppearance2 = AquaAppearances.getVibrantAppearance(aquaAppearance2);
                }
                return aquaAppearance2;
            }
        }
        return aquaAppearance;
    }

    @NotNull
    private static AquaAppearance getInheritedAppearance(@NotNull Component component) {
        Container container = component.getParent();
        if (container == null) {
            String string = AquaUtils.nativeGetApplicationAppearanceName();
            if (string != null) {
                return AquaAppearances.get(string);
            }
            return AquaAppearances.getDefaultAppearance();
        }
        return AppearanceManager.getAppearanceForComponent(container);
    }

    @NotNull
    public static AquaAppearance getAppearance(@NotNull Component component) {
        AquaAppearance aquaAppearance = AppearanceManager.getRegisteredAppearance(component);
        return aquaAppearance != null ? aquaAppearance : AquaAppearances.getDefaultAppearance();
    }

    @Nullable
    public static AquaAppearance getRegisteredAppearance(@NotNull Component component) {
        JComponent jComponent;
        Object object;
        if (component instanceof JComponent && (object = (jComponent = (JComponent)component).getClientProperty(AQUA_APPEARANCE_KEY)) instanceof AquaAppearance) {
            return (AquaAppearance)object;
        }
        return null;
    }

    @Nullable
    private static String getRegisteredAppearanceName(@NotNull Component component) {
        JComponent jComponent;
        Object object;
        if (component instanceof JComponent && (object = (jComponent = (JComponent)component).getClientProperty(AQUA_APPEARANCE_NAME_KEY)) instanceof String) {
            return (String)object;
        }
        return null;
    }

    private static void appearanceHasChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        Object object;
        if (jComponent instanceof JMenuBar) {
            Color color;
            object = (JMenuBar)jComponent;
            Color color2 = ((Component)object).getBackground();
            if (color2 instanceof ColorUIResource) {
                ((JComponent)object).setBackground(aquaAppearance.getColor("controlBackground"));
            }
            if ((color = ((Component)object).getForeground()) instanceof ColorUIResource) {
                ((JComponent)object).setForeground(aquaAppearance.getColor("control"));
            }
        }
        if ((object = AquaUtils.getUI(jComponent, AquaComponentUI.class)) != null) {
            object.appearanceChanged(jComponent, aquaAppearance);
        }
    }

    private static void parentChanged(@NotNull JComponent jComponent) {
        Container container = jComponent.getParent();
        if (container == null) {
            AppearanceManager.uninstallAppearancesInTree(jComponent);
        } else {
            String string = AppearanceManager.getRegisteredAppearanceName(jComponent);
            if (string != null) {
                AquaAppearance aquaAppearance = AquaAppearances.get(string);
                aquaAppearance = AppearanceManager.getVariant(jComponent, aquaAppearance);
                AppearanceManager.installAppearance(jComponent, aquaAppearance);
                AppearanceManager.installAppearancesInNewlyAttachedTree(jComponent);
                return;
            }
            AquaAppearance aquaAppearance = AppearanceManager.getInheritedAppearanceForAttachment(jComponent);
            if (aquaAppearance == null) {
                AppearanceManager.uninstallAppearancesInTree(jComponent);
            } else {
                aquaAppearance = AppearanceManager.getVariant(jComponent, aquaAppearance);
                AppearanceManager.installAppearance(jComponent, aquaAppearance);
                AppearanceManager.installAppearancesInNewlyAttachedTree(jComponent);
            }
        }
    }

    @Nullable
    private static AquaAppearance getInheritedAppearanceForAttachment(@NotNull JComponent jComponent) {
        Container container = jComponent;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof JComponent)) continue;
            Container container2 = container;
            return AppearanceManager.getRegisteredAppearance(container2);
        }
        return null;
    }

    private static void installAppearancesInNewlyAttachedTree(@NotNull Component component) {
        Window window;
        AquaAppearance aquaAppearance = AppearanceManager.getRegisteredAppearance(component);
        if (aquaAppearance != null && (window = SwingUtilities.getWindowAncestor(component)) != null) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                AppearanceManager.installAppearancesInTree(component2, aquaAppearance);
            }
        }
    }

    private static void installAppearancesInTree(@NotNull Component component, @NotNull AquaAppearance aquaAppearance) {
        if (component instanceof Container) {
            Container container = (Container)component;
            AquaAppearance aquaAppearance2 = AppearanceManager.getAppearanceForComponent(component, aquaAppearance);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                AppearanceManager.installAppearance(jComponent, aquaAppearance2);
            }
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                AppearanceManager.installAppearancesInTree(component2, aquaAppearance2);
            }
        }
    }

    private static void uninstallAppearancesInTree(@NotNull Component component) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            AppearanceManager.uninstallAppearance((JComponent)container);
        }
        if (component instanceof Container) {
            container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                AppearanceManager.uninstallAppearancesInTree(component2);
            }
        }
    }

    @NotNull
    private static AquaAppearance getVariant(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        boolean bl;
        boolean bl2 = bl = AquaVibrantSupport.isVibrant(jComponent) && !(jComponent instanceof JRootPane);
        if (bl) {
            aquaAppearance = AquaAppearances.getVibrantAppearance(aquaAppearance);
        }
        return aquaAppearance;
    }

    static {
        notifiedClasses = new HashSet<Class>();
    }

    private static class AppearanceManagerHierarchyListener
    implements HierarchyListener {
        private AppearanceManagerHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(@NotNull HierarchyEvent hierarchyEvent) {
            Component component;
            long l = hierarchyEvent.getChangeFlags();
            if ((l & 1L) != 0L && (component = hierarchyEvent.getChanged()) instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                AppearanceManager.parentChanged(jComponent);
            }
        }
    }

    private static class ActiveStateListener
    implements PropertyChangeListener {
        private ActiveStateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            JComponent jComponent;
            AquaComponentUI aquaComponentUI;
            Object object2 = propertyChangeEvent.getSource();
            if (object2 instanceof JComponent && (aquaComponentUI = AquaUtils.getUI(jComponent = (JComponent)object2, AquaComponentUI.class)) != null && (object = propertyChangeEvent.getNewValue()) instanceof Boolean) {
                Boolean bl = (Boolean)object;
                aquaComponentUI.activeStateChanged(jComponent, bl);
            }
        }
    }
}

