/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Images;
import org.violetlib.aqua.fc.ListStateIcon;

public class OSXFile {
    public static final int FILE_TYPE_ALIAS = 2;
    public static final int FILE_TYPE_DIRECTORY = 1;
    public static final int FILE_TYPE_FILE = 0;
    public static final int FILE_TYPE_UNKNOWN = -1;
    private static volatile Color[][] labelColors;
    private static String computerModel;
    private static boolean computerModelInitialized;
    private static Icon computerSidebarIcon;
    private static final int kLSItemInfoIsPlainFile = 1;
    private static final int kLSItemInfoIsPackage = 2;
    private static final int kLSItemInfoIsApplication = 4;
    private static final int kLSItemInfoIsContainer = 8;
    private static final int kLSItemInfoIsAliasFile = 16;
    private static final int kLSItemInfoIsSymlink = 32;
    private static final int kLSItemInfoIsInvisible = 64;
    private static final int kLSItemInfoIsNativeApp = 128;
    private static final int kLSItemInfoIsClassicApp = 256;
    private static final int kLSItemInfoAppPrefersNative = 512;
    private static final int kLSItemInfoAppPrefersClassic = 1024;
    private static final int kLSItemInfoAppIsScriptable = 2048;
    private static final int kLSItemInfoIsVolume = 4096;
    private static final int kLSItemInfoExtensionIsHidden = 0x100000;
    private static final RecyclableFileIcon aliasBadgeIcon;
    private static final RecyclableFileIcon genericComputerIcon;
    private static final RecyclableFileIcon directoryIcon;
    private static final RecyclableFileIcon fileIcon;
    private static final RecyclableFileIcon networkIcon;
    private static final RecyclableSidebarIcon airDropSidebarIcon;
    private static final RecyclableSidebarIcon allMyFilesSidebarIcon;
    private static final RecyclableSidebarIcon applicationsSidebarIcon;
    private static final RecyclableSidebarIcon desktopSidebarIcon;
    private static final RecyclableSidebarIcon documentsSidebarIcon;
    private static final RecyclableSidebarIcon downloadsSidebarIcon;
    private static final RecyclableSidebarIcon dropboxSidebarIcon;
    private static final RecyclableSidebarIcon genericFileSidebarIcon;
    private static final RecyclableSidebarIcon genericFolderSidebarIcon;
    private static final RecyclableSidebarIcon homeSidebarIcon;
    private static final RecyclableSidebarIcon moviesSidebarIcon;
    private static final RecyclableSidebarIcon musicSidebarIcon;
    private static final RecyclableSidebarIcon networkSidebarIcon;
    private static final RecyclableSidebarIcon picturesSidebarIcon;
    private static final RecyclableSidebarIcon smartFolderSidebarIcon;
    private static final RecyclableSidebarIcon timeMachineSidebarIcon;
    private static final RecyclableSidebarIcon utilitiesSidebarIcon;
    private static final RecyclableSidebarIcon genericVolumeSidebarIcon;
    private static final RecyclableSidebarIcon iMacSidebarIcon;
    private static final RecyclableSidebarIcon macMiniSidebarIcon;
    private static final RecyclableSidebarIcon macProSidebarIcon;
    private static final RecyclableSidebarIcon macProCylinderSidebarIcon;
    private static final RecyclableSidebarIcon pcSidebarIcon;
    private static final RecyclableSidebarIcon laptopSidebarIcon;
    private static String[] nonTraversableDirectories;
    private static String computerName;
    private static boolean haveFetchedComputerName;
    public static final int SIDEBAR_FAVORITES = 0;
    public static final int SIDEBAR_VOLUMES = 1;
    private static final SharedFileList[] sharedFileLists;

    private static Icon createSidebarIcon(Image image) {
        Color color = UIManager.getColor("Tree.sideBar.foreground");
        Color color2 = UIManager.getColor("Tree.sideBar.selectionForeground");
        Image image2 = OSXFile.createSidebarImage(image, color);
        Image image3 = OSXFile.createSidebarImage(image, color2);
        return new ListStateIcon(new ImageIcon(image2), new ImageIcon(image3));
    }

    protected static Image createSidebarImage(Image image, Color color) {
        if (image instanceof AquaMultiResolutionImage) {
            AquaMultiResolutionImage aquaMultiResolutionImage = (AquaMultiResolutionImage)image;
            SidebarImageMapper sidebarImageMapper = new SidebarImageMapper(color);
            return aquaMultiResolutionImage.map(sidebarImageMapper);
        }
        BufferedImage bufferedImage = Images.toBufferedImage(image);
        return OSXFile.basicCreateSidebarImage(bufferedImage, color);
    }

    protected static BufferedImage basicCreateSidebarImage(BufferedImage bufferedImage, Color color) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcIn);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static RecyclableFileIcon createIcon(String string) {
        String string2 = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/";
        return new RecyclableFileIcon(string2 + string + ".icns");
    }

    private static RecyclableSidebarIcon createSidebarIcon(String string) {
        String string2 = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/Sidebar";
        RecyclableSidebarIcon recyclableSidebarIcon = new RecyclableSidebarIcon(string2 + string + ".icns");
        return recyclableSidebarIcon;
    }

    public static Icon getAliasBadgeIcon() {
        return aliasBadgeIcon.getInstance();
    }

    public static Icon getDirectoryIcon() {
        return directoryIcon.getInstance();
    }

    public static Image getDirectoryIconImage(int n) {
        return directoryIcon.asImage(n);
    }

    public static Icon getFileIcon() {
        return fileIcon.getInstance();
    }

    public static Image getFileIconImage(int n) {
        return fileIcon.asImage(n);
    }

    public static Icon getGenericComputerIcon() {
        return genericComputerIcon.getInstance();
    }

    public static Icon getNetworkIcon() {
        return networkIcon.getInstance();
    }

    public static Icon getAirDropSidebarIcon() {
        return airDropSidebarIcon.getInstance();
    }

    public static Icon getAllMyFilesSidebarIcon() {
        return allMyFilesSidebarIcon.getInstance();
    }

    public static Icon getApplicationsSidebarIcon() {
        return applicationsSidebarIcon.getInstance();
    }

    public static Icon getDesktopSidebarIcon() {
        return desktopSidebarIcon.getInstance();
    }

    public static Icon getDocumentsSidebarIcon() {
        return documentsSidebarIcon.getInstance();
    }

    public static Icon getDownloadsSidebarIcon() {
        return downloadsSidebarIcon.getInstance();
    }

    public static Icon getDropboxSidebarIcon() {
        return dropboxSidebarIcon.getInstance();
    }

    public static Icon getGenericFileSidebarIcon() {
        return genericFileSidebarIcon.getInstance();
    }

    public static Icon getGenericFolderSidebarIcon() {
        return genericFolderSidebarIcon.getInstance();
    }

    public static Icon getGenericVolumeSidebarIcon() {
        return genericVolumeSidebarIcon.getInstance();
    }

    public static Icon getHomeSidebarIcon() {
        return homeSidebarIcon.getInstance();
    }

    public static Icon getMoviesSidebarIcon() {
        return moviesSidebarIcon.getInstance();
    }

    public static Icon getMusicSidebarIcon() {
        return musicSidebarIcon.getInstance();
    }

    public static Icon getNetworkSidebarIcon() {
        return networkSidebarIcon.getInstance();
    }

    public static Icon getPicturesSidebarIcon() {
        return picturesSidebarIcon.getInstance();
    }

    public static Icon getSmartFolderSidebarIcon() {
        return smartFolderSidebarIcon.getInstance();
    }

    public static Icon getTimeMachineSidebarIcon() {
        return timeMachineSidebarIcon.getInstance();
    }

    public static Icon getUtilitiesSidebarIcon() {
        return utilitiesSidebarIcon.getInstance();
    }

    public static Icon getiMacSidebarIcon() {
        return iMacSidebarIcon.getInstance();
    }

    public static Icon getMacMiniSidebarIcon() {
        return macMiniSidebarIcon.getInstance();
    }

    public static Icon getMacProSidebarIcon() {
        return macProSidebarIcon.getInstance();
    }

    public static Icon getMacProCylinderSidebarIcon() {
        return macProCylinderSidebarIcon.getInstance();
    }

    public static Icon getLaptopSidebarIcon() {
        return laptopSidebarIcon.getInstance();
    }

    public static Icon getPCSidebarIcon() {
        return pcSidebarIcon.getInstance();
    }

    private static boolean isNativeCodeAvailable() {
        return AquaNativeSupport.load();
    }

    private OSXFile() {
    }

    public static File getAbsoluteFile(File file) {
        if (!file.isAbsolute()) {
            file = new File(AquaUtils.getProperty("user.home") + File.separatorChar + file.getPath());
        }
        if (File.separatorChar == '\\') {
            return file;
        }
        StringBuffer stringBuffer = new StringBuffer(file.getPath().length());
        int n = 0;
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            String string = file2.getName();
            if (string.equals(".")) {
                if (n <= 0) continue;
                --n;
                continue;
            }
            if (string.equals("..")) {
                ++n;
                continue;
            }
            if (n > 0) {
                --n;
                continue;
            }
            stringBuffer.insert(0, string);
            stringBuffer.insert(0, File.separatorChar);
        }
        return file.getPath().equals(stringBuffer.toString()) ? file : new File(stringBuffer.toString());
    }

    public static boolean isAvailable() {
        return OSXFile.isNativeCodeAvailable();
    }

    public static int getFileType(File file) {
        if (OSXFile.isNativeCodeAvailable()) {
            int n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            if ((n & 0x10) != 0) {
                if (file.getParent().equals("/Volumes")) {
                    return 1;
                }
                return 2;
            }
            if ((n & 8) != 0) {
                return 1;
            }
            if ((n & 1) != 0) {
                return 0;
            }
            return -1;
        }
        return file.isDirectory() ? 1 : (file.isFile() ? 0 : -1);
    }

    public static File resolvePath(String string, File file) {
        if (string.startsWith("/")) {
            return new File(string);
        }
        if (string.startsWith("~")) {
            if ((string = string.substring(1)).startsWith("/")) {
                String string2 = System.getProperty("user.home");
                return new File(string2 + string);
            }
            if (string.isEmpty()) {
                String string3 = System.getProperty("user.home");
                return new File(string3);
            }
            return new File("/Users/" + string);
        }
        if (file == null) {
            String string4 = System.getProperty("user.home");
            file = new File(string4);
        }
        return new File(file, string);
    }

    public static File resolve(File file) {
        return OSXFile.resolveAlias(file, true);
    }

    public static File resolveAlias(File file, boolean bl) {
        if (OSXFile.isNativeCodeAvailable()) {
            String string = OSXFile.nativeResolveAlias(file.getAbsolutePath(), bl);
            if (string == null) {
                return null;
            }
            file = new File(string);
            if (OSXFile.getFileType(file) != 2) {
                return file;
            }
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public static File resolveAlias(byte[] byArray, boolean bl) {
        if (OSXFile.isNativeCodeAvailable()) {
            String string = OSXFile.nativeResolveAlias(byArray, bl);
            return string == null ? null : new File(string);
        }
        return null;
    }

    public static int getLabel(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            return OSXFile.nativeGetLabel(file.getAbsolutePath());
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Color getLabelColor(int n, int n2) {
        if (labelColors == null) {
            Class<OSXFile> clazz = OSXFile.class;
            // MONITORENTER : org.violetlib.aqua.fc.OSXFile.class
            if (labelColors == null) {
                labelColors = new Color[][]{{null, null, null, null}, {new Color(0xB7B7B7), new Color(0xD8D8D8), new Color(0xE9E9E9), new Color(0xF3F3F3)}, {new Color(12704094), new Color(14609324), new Color(15529422), new Color(16120550)}, {new Color(13345759), new Color(15191534), new Color(15786742), new Color(16249082)}, {new Color(7190013), new Color(12114942), new Color(13756671), new Color(15332607)}, {new Color(15916384), new Color(16511660), new Color(16578254), new Color(16710886)}, {new Color(16480880), new Color(16561325), new Color(16766675), new Color(16771302)}, {new Color(16234075), new Color(16504484), new Color(16705996), new Color(0xFFF3E3)}};
            }
            // MONITOREXIT : clazz
        }
        if (n == -1) {
            return null;
        }
        Color color = labelColors[n][n2];
        return color;
    }

    public static Image getIconImage(File file, int n, boolean bl) throws UnsupportedOperationException {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            FileIconCreator fileIconCreator = new FileIconCreator(file, n, bl, true);
            return fileIconCreator.getImage();
        }
        throw new UnsupportedOperationException();
    }

    public static Image getThumbnailImage(File file, int n) throws UnsupportedOperationException {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            FileIconCreator fileIconCreator = new FileIconCreator(file, n, true, false);
            return fileIconCreator.getImage();
        }
        throw new UnsupportedOperationException();
    }

    public static String getKindString(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            return OSXFile.nativeGetKindString(file.getAbsolutePath());
        }
        return null;
    }

    public static boolean isVirtualFile(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            int n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            return (n & 2) != 0;
        }
        return false;
    }

    public static boolean isInvisible(File file) {
        if (file != null) {
            if (OSXFile.isNativeCodeAvailable()) {
                int n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
                return (n & 0x40) != 0;
            }
            return file.isHidden();
        }
        return false;
    }

    public static boolean isTraversable(File file) {
        return OSXFile.isTraversable(file, false, false);
    }

    public static boolean isTraversable(File file, boolean bl, boolean bl2) {
        if (file == null) {
            return false;
        }
        if (OSXFile.isNativeCodeAvailable()) {
            int n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            if ((n & 0x10) != 0) {
                file = OSXFile.resolve(file);
                n = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            }
            if ((n & 9) == 8) {
                boolean bl3;
                boolean bl4 = (n & 2) != 0;
                boolean bl5 = bl3 = (n & 4) != 0;
                if (bl3) {
                    return bl2;
                }
                if (bl4) {
                    return bl;
                }
                return OSXFile.basicIsTraversable(file);
            }
            if ((n & 1) != 0) {
                return OSXFile.basicIsTraversable(file);
            }
            return OSXFile.isVolumes(file.getParent());
        }
        return OSXFile.basicIsTraversable(file);
    }

    private static boolean isVolumes(String string) {
        return string != null && string.equals("/Volumes");
    }

    private static boolean basicIsTraversable(File file) {
        String string = file.getName();
        if (file.isDirectory()) {
            for (String string2 : nonTraversableDirectories) {
                if (!string2.equals(string)) continue;
                return false;
            }
            return true;
        }
        return OSXFile.isSavedSearch(file);
    }

    public static boolean isSavedSearch(File file) {
        return file.getName().endsWith(".savedSearch");
    }

    public static Icon getSidebarComputerIcon() {
        if (computerSidebarIcon == null) {
            String string = OSXFile.getComputerModel();
            if (string != null) {
                if (string.startsWith("MacBook")) {
                    computerSidebarIcon = OSXFile.getLaptopSidebarIcon();
                } else if (string.startsWith("MacPro")) {
                    computerSidebarIcon = OSXFile.getMacProSidebarIcon();
                } else if (string.startsWith("Macmini")) {
                    computerSidebarIcon = OSXFile.getMacMiniSidebarIcon();
                }
            }
            if (computerSidebarIcon == null) {
                computerSidebarIcon = OSXFile.getiMacSidebarIcon();
            }
        }
        return computerSidebarIcon;
    }

    private static String getComputerModel() {
        if (!computerModelInitialized) {
            computerModelInitialized = true;
            String[] stringArray = new String[]{"/usr/sbin/sysctl", "hw.model"};
            Charset charset = Charset.forName("UTF-8");
            String string = OSXFile.exec(stringArray, charset);
            if (string != null) {
                int n = string.indexOf(":");
                computerModel = string.substring(n + 1).trim();
            }
        }
        return computerModel;
    }

    private static native int nativeGetFileType(String var0);

    private static native String nativeResolveAlias(String var0, boolean var1);

    private static native String nativeResolveAlias(byte[] var0, boolean var1);

    private static native int nativeGetLabel(String var0);

    private static native String nativeGetKindString(String var0);

    private static native int nativeGetBasicItemInfoFlags(String var0);

    public static String getComputerName() {
        if (!haveFetchedComputerName) {
            haveFetchedComputerName = true;
            String[] stringArray = new String[]{"/usr/sbin/scutil", "--get", "ComputerName"};
            Charset charset = Charset.forName("UTF-8");
            String string = OSXFile.exec(stringArray, charset);
            computerName = string != null ? string.trim() : null;
        }
        return computerName;
    }

    public static String getDisplayName(File file) {
        if (OSXFile.isNativeCodeAvailable()) {
            return OSXFile.nativeGetDisplayName(file.getAbsolutePath());
        }
        return file.getName();
    }

    public static Date getLastUsedDate(File file) {
        if (OSXFile.isNativeCodeAvailable()) {
            long l = OSXFile.nativeGetLastUsedDate(file.getAbsolutePath());
            return l > 0L ? new Date(l) : null;
        }
        return null;
    }

    public static File[] executedSavedSearch(File file) {
        String string = file.getAbsolutePath();
        String[] stringArray = OSXFile.nativeExecuteSavedSearch(string);
        if (stringArray != null) {
            int n = stringArray.length;
            File[] fileArray = new File[n];
            for (int i = 0; i < n; ++i) {
                fileArray[i] = new File(stringArray[i]);
            }
            return fileArray;
        }
        return null;
    }

    public static List<SystemItemInfo> getSidebarFiles(int n) {
        return sharedFileLists[n].getResults();
    }

    public static String exec(String[] stringArray, Charset charset) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
            StreamCollector streamCollector = new StreamCollector(inputStreamReader);
            streamCollector.start();
            int n = process.waitFor();
            streamCollector.join();
            return streamCollector.getContents();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private static native String nativeGetDisplayName(String var0);

    private static native long nativeGetLastUsedDate(String var0);

    private static native String[] nativeExecuteSavedSearch(String var0);

    private static native Object[] nativeGetSidebarFiles(int var0, int var1, int var2);

    private static native boolean nativeRenderFileImage(String var0, boolean var1, boolean var2, int[][] var3, int var4, int var5);

    static {
        aliasBadgeIcon = OSXFile.createIcon("AliasBadgeIcon");
        genericComputerIcon = OSXFile.createIcon("public.generic-pc");
        directoryIcon = OSXFile.createIcon("GenericFolderIcon");
        fileIcon = OSXFile.createIcon("GenericDocumentIcon");
        networkIcon = OSXFile.createIcon("GenericNetworkIcon");
        applicationsSidebarIcon = OSXFile.createSidebarIcon("ApplicationsFolder");
        desktopSidebarIcon = OSXFile.createSidebarIcon("DesktopFolder");
        documentsSidebarIcon = OSXFile.createSidebarIcon("DocumentsFolder");
        downloadsSidebarIcon = OSXFile.createSidebarIcon("DownloadsFolder");
        dropboxSidebarIcon = OSXFile.createSidebarIcon("DropBoxFolder");
        genericFileSidebarIcon = OSXFile.createSidebarIcon("GenericFile");
        genericFolderSidebarIcon = OSXFile.createSidebarIcon("GenericFolder");
        genericVolumeSidebarIcon = OSXFile.createSidebarIcon("InternalDisk");
        homeSidebarIcon = OSXFile.createSidebarIcon("HomeFolder");
        moviesSidebarIcon = OSXFile.createSidebarIcon("MoviesFolder");
        musicSidebarIcon = OSXFile.createSidebarIcon("MusicFolder");
        networkSidebarIcon = OSXFile.createSidebarIcon("Network");
        picturesSidebarIcon = OSXFile.createSidebarIcon("PicturesFolder");
        smartFolderSidebarIcon = OSXFile.createSidebarIcon("SmartFolder");
        timeMachineSidebarIcon = OSXFile.createSidebarIcon("TimeMachine");
        utilitiesSidebarIcon = OSXFile.createSidebarIcon("UtilitiesFolder");
        iMacSidebarIcon = OSXFile.createSidebarIcon("iMac");
        macMiniSidebarIcon = OSXFile.createSidebarIcon("MacMini");
        macProSidebarIcon = OSXFile.createSidebarIcon("MacPro");
        macProCylinderSidebarIcon = OSXFile.createSidebarIcon("MacProCylinder");
        pcSidebarIcon = OSXFile.createSidebarIcon("PC");
        laptopSidebarIcon = OSXFile.createSidebarIcon("Laptop");
        airDropSidebarIcon = OSXFile.createSidebarIcon("AirDrop");
        allMyFilesSidebarIcon = OSXFile.createSidebarIcon("AllMyFiles");
        nonTraversableDirectories = new String[]{".Spotlight-V100", ".DocumentRevisions", ".Trashes"};
        sharedFileLists = new SharedFileList[]{new SharedFileList(0, "Sidebar Favorites"), new SharedFileList(1, "Sidebar Volumes")};
    }

    private static class StreamCollector
    extends Thread {
        private BufferedReader br;
        private String result;

        public StreamCollector(Reader reader) {
            this.br = new BufferedReader(reader);
        }

        public synchronized String getContents() {
            return this.result;
        }

        private synchronized void setContents(String string) {
            this.result = string;
            this.notifyAll();
        }

        @Override
        public void run() {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[1000];
            block4: while (true) {
                try {
                    int n;
                    while ((n = this.br.read(cArray, 0, cArray.length)) >= 0) {
                        if (n > 0) {
                            stringBuilder.append(cArray, 0, n);
                            continue;
                        }
                        try {
                            Thread.sleep(200L);
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                    break;
                }
            }
            String string = stringBuilder.toString();
            this.setContents(string);
        }
    }

    private static class SharedFileList {
        private String name;
        private int which;
        private int lastSeed = -1;
        private List<SystemItemInfo> lastResults;

        public SharedFileList(int n, String string) {
            this.which = n;
            this.name = string;
        }

        public List<SystemItemInfo> getResults() {
            int n = 18;
            Object[] objectArray = OSXFile.nativeGetSidebarFiles(this.which, 18, this.lastSeed);
            if (objectArray == null) {
                return this.lastResults;
            }
            this.lastSeed = (Integer)objectArray[0];
            int n2 = 0;
            ArrayList<SystemItemInfo> arrayList = new ArrayList<SystemItemInfo>();
            for (int i = 1; i < objectArray.length; i += 6) {
                String string = (String)objectArray[i];
                if (string == null) continue;
                Integer n3 = (Integer)objectArray[i + 1];
                Integer n4 = (Integer)objectArray[i + 2];
                String string2 = (String)objectArray[i + 3];
                int[] nArray = (int[])objectArray[i + 4];
                int[] nArray2 = (int[])objectArray[i + 5];
                SystemItemInfo systemItemInfo = new SystemItemInfo();
                systemItemInfo.name = string;
                systemItemInfo.path = string2;
                systemItemInfo.sequenceNumber = n2++;
                systemItemInfo.isVisible = n4 == 0;
                systemItemInfo.id = n3;
                if (nArray != null) {
                    systemItemInfo.icon = OSXFile.createSidebarIcon(AquaMultiResolutionImage.createImage(n, n, nArray, nArray2));
                }
                arrayList.add(systemItemInfo);
            }
            this.lastResults = arrayList;
            return arrayList;
        }
    }

    public static class SystemItemInfo {
        public String name;
        public String path;
        int sequenceNumber;
        boolean isVisible;
        int id;
        Icon icon;

        public String toString() {
            String string = this.sequenceNumber + ": " + this.name;
            string = this.path != null ? string + " " + this.path : string + " (unresolved)";
            string = string + " " + this.id;
            if (!this.isVisible) {
                string = string + " (hidden)";
            }
            return string;
        }
    }

    private static class FileIconCreator {
        private final File file;
        private final int size;
        private final boolean useQuickLook;
        private final boolean useIconMode;
        private Image result;

        public FileIconCreator(File file, int n, boolean bl, boolean bl2) {
            this.file = file;
            this.size = n;
            this.useQuickLook = bl;
            this.useIconMode = bl2;
        }

        public Image getImage() {
            if (this.result == null) {
                int[][] nArrayArray;
                String string = this.file.getAbsolutePath();
                if (!OSXFile.nativeRenderFileImage(string, this.useQuickLook, this.useIconMode, nArrayArray = new int[2][], this.size, this.size)) {
                    if (AquaImageFactory.debugNativeRendering) {
                        System.err.println("Failed to render image for " + string);
                    }
                    throw new UnsupportedOperationException();
                }
                if (AquaImageFactory.debugNativeRendering) {
                    System.err.println("Rendered image for " + string);
                }
                this.result = AquaMultiResolutionImage.createImage(this.size, this.size, nArrayArray[0], nArrayArray[1]);
            }
            return this.result;
        }
    }

    private static class SidebarImageMapper
    implements AquaMultiResolutionImage.Mapper {
        private final Color color;

        public SidebarImageMapper(Color color) {
            this.color = color;
        }

        @Override
        public BufferedImage map(Image image, int n) {
            BufferedImage bufferedImage = Images.toBufferedImage(image);
            return OSXFile.basicCreateSidebarImage(bufferedImage, this.color);
        }
    }

    private static class RecyclableSidebarIcon
    extends AquaUtils.RecyclableSingleton<Icon> {
        final File file;

        public RecyclableSidebarIcon(File file) {
            this.file = file;
        }

        public RecyclableSidebarIcon(String string) {
            this.file = new File(string);
        }

        @Override
        protected Icon getInstance() {
            Image image = AquaImageFactory.getImage(this.file, 18);
            return OSXFile.createSidebarIcon(image);
        }
    }

    private static class RecyclableFileIcon
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        final File file;

        public RecyclableFileIcon(File file) {
            this.file = file;
        }

        public RecyclableFileIcon(String string) {
            this.file = new File(string);
        }

        @Override
        protected IconUIResource getInstance() {
            Image image = AquaImageFactory.getImage(this.file, 16);
            return new IconUIResource(new ImageIcon(image));
        }

        public Image asImage(int n) {
            return AquaImageFactory.getImage(this.file, n);
        }
    }
}

