/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Rectangle;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JTree;
import javax.swing.tree.TreeSelectionModel;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.SelectionBoundsTracker;

public abstract class TreeSelectionBoundsTracker
implements SelectionBoundsTracker {
    protected JTree tree;
    protected Consumer<SelectionBoundsDescription> consumer;
    private SelectionBoundsDescription currentSelectionDescription;

    public TreeSelectionBoundsTracker(JTree jTree, Consumer<SelectionBoundsDescription> consumer) {
        this.tree = jTree;
        this.consumer = consumer;
        this.update();
        if (consumer != null && this.currentSelectionDescription == null) {
            consumer.accept(null);
        }
    }

    @Override
    public void dispose() {
        this.tree = null;
        this.consumer = null;
    }

    @Override
    public void reset() {
        if (this.currentSelectionDescription != null) {
            this.currentSelectionDescription = null;
            if (this.consumer != null) {
                this.consumer.accept(null);
            }
        }
    }

    @Override
    public void setConsumer(Consumer<SelectionBoundsDescription> consumer) {
        if (consumer != this.consumer) {
            this.consumer = consumer;
            if (consumer != null) {
                consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    @Override
    public void update() {
        if (this.tree != null) {
            int[] nArray;
            TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
            int[] nArray2 = nArray = treeSelectionModel != null ? treeSelectionModel.getSelectionRows() : null;
            if (nArray != null && nArray.length == 0) {
                nArray = null;
            }
            this.updateFromSelectedRows(nArray);
        }
    }

    protected void updateFromSelectedRows(int[] nArray) {
        SelectionBoundsDescription selectionBoundsDescription = this.createSelectionDescription(nArray);
        if (!Objects.equals(selectionBoundsDescription, this.currentSelectionDescription)) {
            this.currentSelectionDescription = selectionBoundsDescription;
            if (this.consumer != null) {
                this.consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    private SelectionBoundsDescription createSelectionDescription(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        SelectionBoundsDescription selectionBoundsDescription = new SelectionBoundsDescription(nArray.length);
        for (int n : nArray) {
            Rectangle rectangle = this.tree.getRowBounds(n);
            int n2 = this.convertRowYCoordinateToSelectionDescription(rectangle.y);
            selectionBoundsDescription.addRegion(n2, rectangle.height);
        }
        return selectionBoundsDescription;
    }

    protected int convertRowYCoordinateToSelectionDescription(int n) {
        return n;
    }
}

