/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaUtils;

public abstract class AquaPopupFactory
extends PopupFactory {
    protected boolean isActive;

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    @Override
    public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
        if (this.isActive) {
            Popup popup = this.getHeavyweightPopup(component, component2, n, n2);
            return this.configure(popup, component2);
        }
        return super.getPopup(component, component2, n, n2);
    }

    protected abstract Popup getHeavyweightPopup(Component var1, Component var2, int var3, int var4);

    protected Popup getDefaultPopup(Component component, Component component2, int n, int n2) {
        return super.getPopup(component, component2, n, n2);
    }

    private Popup configure(Popup popup, Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window.isDisplayable() && window.getWidth() > 0) {
            window.setSize(window.getPreferredSize());
            window.invalidate();
            window.validate();
            if (window instanceof RootPaneContainer) {
                JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                AquaRootPaneUI aquaRootPaneUI = AquaUtils.getUI(jRootPane, AquaRootPaneUI.class);
                if (aquaRootPaneUI != null) {
                    aquaRootPaneUI.configure();
                } else {
                    jRootPane.updateUI();
                }
            }
        }
        return popup;
    }
}

