/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.View;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaSimpleBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.JavaSupport;

public class AquaMenuPainter {
    static final byte kShiftGlyph = 5;
    static final byte kOptionGlyph = 7;
    static final byte kControlGlyph = 6;
    static final byte kPencilGlyph = 15;
    static final byte kCommandMark = 17;
    static final char kUBlackDiamond = '\u25c6';
    static final char kUCheckMark = '\u2713';
    static final char kUControlGlyph = '\u2303';
    static final char kUOptionGlyph = '\u2325';
    static final char kUEnterGlyph = '\u2324';
    static final char kUCommandGlyph = '\u2318';
    static final char kULeftDeleteGlyph = '\u232b';
    static final char kURightDeleteGlyph = '\u2326';
    static final char kUShiftGlyph = '\u21e7';
    static final char kUCapsLockGlyph = '\u21ea';
    static final int ALT_GRAPH_MASK = 32;
    static final int sUnsupportedModifiersMask = -48;
    static final AquaUtils.RecyclableSingleton<AquaMenuPainter> sPainter = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaMenuPainter>(AquaMenuPainter.class);
    static final int defaultMenuItemGap = 2;
    static final int kAcceleratorArrowSpace = 16;
    protected final RecyclableBorder menuBarPainter = new RecyclableBorder("MenuBar.backgroundPainter");
    protected final RecyclableBorder selectedMenuBarItemPainter = new RecyclableBorder("MenuBar.selectedBackgroundPainter");
    protected final RecyclableBorder selectedMenuItemPainter = new RecyclableBorder("MenuItem.selectedBackgroundPainter");

    static String getKeyModifiersText(int n, boolean bl) {
        return AquaMenuPainter.getKeyModifiersUnicode(n, bl);
    }

    private static String getKeyModifiersUnicode(int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(2);
        if (bl) {
            if ((n & 2) != 0) {
                stringBuilder.append('\u2303');
            }
            if ((n & 0x28) != 0) {
                stringBuilder.append('\u2325');
            }
            if ((n & 1) != 0) {
                stringBuilder.append('\u21e7');
            }
            if ((n & 4) != 0) {
                stringBuilder.append('\u2318');
            }
        } else {
            if ((n & 4) != 0) {
                stringBuilder.append('\u2318');
            }
            if ((n & 1) != 0) {
                stringBuilder.append('\u21e7');
            }
            if ((n & 0x28) != 0) {
                stringBuilder.append('\u2325');
            }
            if ((n & 2) != 0) {
                stringBuilder.append('\u2303');
            }
        }
        return stringBuilder.toString();
    }

    static AquaMenuPainter instance() {
        return sPainter.get();
    }

    public void paintMenuBarBackground(Graphics graphics, int n, int n2, JComponent jComponent) {
        graphics.setColor(jComponent == null ? Color.white : jComponent.getBackground());
        graphics.fillRect(0, 0, n, n2);
        ((Border)this.menuBarPainter.get()).paintBorder(null, graphics, 0, 0, n, n2);
    }

    public void paintSelectedMenuTitleBackground(Graphics graphics, int n, int n2) {
        ((Border)this.selectedMenuBarItemPainter.get()).paintBorder(null, graphics, -1, 0, n + 2, n2);
    }

    public void paintSelectedMenuItemBackground(Graphics graphics, int n, int n2) {
        ((Border)this.selectedMenuItemPainter.get()).paintBorder(null, graphics, 0, 0, n, n2);
    }

    protected void paintMenuItem(Client client, Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, Color color3, Color color4, int n, Font font) {
        int n2;
        Container container;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n3 = jMenuItem.getWidth();
        int n4 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(0, 0, n3, n4);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Font font2 = graphics.getFont();
        Color color5 = graphics.getColor();
        Font font3 = jComponent.getFont();
        graphics.setFont(font3);
        FontMetrics fontMetrics = graphics.getFontMetrics(font3);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(font);
        if (jComponent.isOpaque()) {
            client.paintBackground(graphics, jComponent, n3, n4);
        }
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        String string2 = "";
        boolean bl = AquaUtils.isLeftToRight(jComponent);
        if (keyStroke != null) {
            int n5;
            int n6 = keyStroke.getModifiers();
            if (n6 > 0) {
                string = AquaMenuPainter.getKeyModifiersText(n6, bl);
            }
            string2 = (n5 = keyStroke.getKeyCode()) != 0 ? KeyEvent.getKeyText(n5) : string2 + keyStroke.getKeyChar();
        }
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle();
        String string3 = this.layoutMenuItem(jMenuItem, fontMetrics, jMenuItem.getText(), fontMetrics2, string2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, rectangle4, rectangle5, rectangle6, jMenuItem.getText() == null ? 0 : n, n);
        Container container2 = jMenuItem.getParent();
        boolean bl2 = container2 instanceof JMenuBar;
        for (container = container2; container != null && !(container instanceof JPopupMenu); container = container.getParent()) {
        }
        boolean bl3 = buttonModel.isEnabled() && (container == null || container.isVisible());
        boolean bl4 = false;
        if (!bl3) {
            graphics.setColor(color3);
        } else if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(color4);
            bl4 = true;
        } else {
            graphics.setColor(bl2 ? container2.getForeground() : jMenuItem.getForeground());
        }
        if (jMenuItem.getIcon() != null) {
            this.paintIcon(graphics, jMenuItem, rectangle2, bl3);
        }
        if (icon != null) {
            this.paintCheck(graphics, jMenuItem, icon, rectangle5);
        }
        if (string2 != null && !string2.equals("")) {
            int n7 = rectangle4.y + fontMetrics.getAscent();
            if (string.equals("")) {
                JavaSupport.drawString(jComponent, (Graphics2D)graphics, string2, rectangle4.x, n7);
            } else {
                n2 = keyStroke.getModifiers();
                int n8 = 0;
                if ((n2 & 0x20) > 0) {
                    n8 = 8997;
                }
                int n9 = Math.max(fontMetrics.charWidth('M'), SwingUtilities.computeStringWidth(fontMetrics, string2));
                if (bl) {
                    graphics.setFont(font);
                    this.drawString(graphics, jComponent, string, n8, rectangle4.x, n7, bl3, bl4);
                    graphics.setFont(font3);
                    JavaSupport.drawString(jComponent, (Graphics2D)graphics, string2, rectangle4.x + rectangle4.width - n9, n7);
                } else {
                    int n10 = rectangle4.x + n9;
                    graphics.setFont(font);
                    this.drawString(graphics, jComponent, string, n8, n10, n7, bl3, bl4);
                    graphics.setFont(font3);
                    JavaSupport.drawString(jComponent, (Graphics2D)graphics, string2, n10 - fontMetrics.stringWidth(string2), n7);
                }
            }
        }
        if (string3 != null && !string3.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                n2 = AquaMnemonicHandler.isMnemonicHidden() ? -1 : buttonModel.getMnemonic();
                this.drawString(graphics, jComponent, string3, n2, rectangle3.x, rectangle3.y + fontMetrics.getAscent(), bl3, bl4);
            }
        }
        if (icon2 != null) {
            this.paintArrow(graphics, jMenuItem, buttonModel, icon2, rectangle6);
        }
        graphics.setColor(color5);
        graphics.setFont(font2);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n, Font font) {
        Insets insets;
        boolean bl;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        String string3 = "";
        if (keyStroke != null) {
            int n2;
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string3 = AquaMenuPainter.getKeyModifiersText(n3, true);
            }
            string2 = (n2 = keyStroke.getKeyCode()) != 0 ? KeyEvent.getKeyText(n2) : string2 + keyStroke.getKeyChar();
        }
        Font font2 = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font2);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        this.layoutMenuItem(jMenuItem, fontMetrics, string, fontMetrics2, string2, string3, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), rectangle6, rectangle, rectangle2, rectangle3, rectangle4, rectangle5, string == null ? 0 : n, n);
        Rectangle rectangle7 = new Rectangle();
        rectangle7.setBounds(rectangle2);
        rectangle7 = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle7);
        boolean bl2 = bl = string2 == null || string2.equals("");
        if (!bl) {
            rectangle7.width += rectangle3.width;
        }
        if (!AquaMenuPainter.isTopLevelMenu(jMenuItem)) {
            rectangle7.width += rectangle4.width;
            rectangle7.width += n;
            rectangle7.width += n;
            rectangle7.width += rectangle5.width;
        }
        if ((insets = jMenuItem.getInsets()) != null) {
            rectangle7.width += insets.left + insets.right;
            rectangle7.height += insets.top + insets.bottom;
        }
        rectangle7.width += 4 + n;
        rectangle7.height = Math.max(rectangle7.height, 18);
        return rectangle7.getSize();
    }

    protected void paintCheck(Graphics graphics, JMenuItem jMenuItem, Icon icon, Rectangle rectangle) {
        if (AquaMenuPainter.isTopLevelMenu(jMenuItem) || !jMenuItem.isSelected()) {
            return;
        }
        if (jMenuItem.isArmed() && icon instanceof AquaIcon.InvertableIcon) {
            ((AquaIcon.InvertableIcon)icon).getInvertedIcon().paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
        } else {
            icon.paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintIcon(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, boolean bl) {
        Icon icon;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!bl) {
            icon = jMenuItem.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon = jMenuItem.getPressedIcon();
            if (icon == null) {
                icon = jMenuItem.getIcon();
            }
        } else {
            icon = jMenuItem.getIcon();
        }
        if (icon != null) {
            icon.paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintArrow(Graphics graphics, JMenuItem jMenuItem, ButtonModel buttonModel, Icon icon, Rectangle rectangle) {
        if (AquaMenuPainter.isTopLevelMenu(jMenuItem)) {
            return;
        }
        if (jMenuItem instanceof JMenu && (buttonModel.isArmed() || buttonModel.isSelected()) && icon instanceof AquaIcon.InvertableIcon) {
            ((AquaIcon.InvertableIcon)icon).getInvertedIcon().paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
        } else {
            icon.paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
        }
    }

    public void drawString(Graphics graphics, JComponent jComponent, String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = -1;
        if (n != 0) {
            char c = Character.toUpperCase((char)n);
            char c2 = Character.toLowerCase((char)n);
            int n5 = string.indexOf(c);
            int n6 = string.indexOf(c2);
            n4 = n5 == -1 ? n6 : (n6 == -1 ? n5 : (n6 < n5 ? n6 : n5));
        }
        JavaSupport.drawStringUnderlineCharAt(jComponent, (Graphics2D)graphics, string, n4, n2, n3);
    }

    private static boolean isTopLevelMenu(JMenuItem jMenuItem) {
        return jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu();
    }

    private String layoutMenuItem(JMenuItem jMenuItem, FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, String string3, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        boolean bl;
        AquaUtils.layoutCompoundLabel(jMenuItem, fontMetrics, string, icon, n, 2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        boolean bl2 = bl = string2 == null || string2.equals("");
        if (bl) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string3);
            rectangle4.width += Math.max(fontMetrics.charWidth('M'), SwingUtilities.computeStringWidth(fontMetrics, string2));
            rectangle4.height = fontMetrics2.getHeight();
        }
        boolean bl3 = AquaMenuPainter.isTopLevelMenu(jMenuItem);
        if (!bl3) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 16;
                rectangle5.width = 16;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 16;
                rectangle6.width = 16;
            }
            rectangle3.x += 12;
            rectangle2.x += 12;
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        rectangle4.x += rectangle.width - rectangle6.width - rectangle4.width;
        rectangle4.y = rectangle.y + rectangle.height / 2 - rectangle4.height / 2;
        if (!bl3) {
            rectangle6.x = rectangle.width - rectangle6.width + 1;
            rectangle6.y = rectangle.y + rectangle7.height / 2 - rectangle6.height / 2 + 1;
            rectangle5.y = rectangle.y + rectangle7.height / 2 - rectangle5.height / 2;
            rectangle5.x = 5;
            rectangle3.width += 8;
        }
        if (!AquaUtils.isLeftToRight(jMenuItem)) {
            int n7 = rectangle.width;
            rectangle5.x = n7 - (rectangle5.x + rectangle5.width);
            rectangle2.x = n7 - (rectangle2.x + rectangle2.width);
            rectangle3.x = n7 - (rectangle3.x + rectangle3.width);
            rectangle4.x = n7 - (rectangle4.x + rectangle4.width);
            rectangle6.x = n7 - (rectangle6.x + rectangle6.width);
        }
        rectangle3.x += n6;
        rectangle2.x += n6;
        return string;
    }

    public static Border getMenuBarPainter() {
        AquaSimpleBorder aquaSimpleBorder = new AquaSimpleBorder("MenuBar.background", new Color(240, 240, 240));
        return aquaSimpleBorder;
    }

    public static Border getSelectedMenuBarItemPainter() {
        AquaSimpleBorder aquaSimpleBorder = new AquaSimpleBorder("MenuBar.selectionBackground", new Color(44, 143, 245));
        return aquaSimpleBorder;
    }

    public static Border getSelectedMenuItemPainter() {
        AquaSimpleBorder aquaSimpleBorder = new AquaSimpleBorder("MenuItem.selectionBackground", new Color(44, 143, 245));
        return aquaSimpleBorder;
    }

    static class RecyclableBorder
    extends AquaUtils.RecyclableSingleton<Border> {
        final String borderName;

        RecyclableBorder(String string) {
            this.borderName = string;
        }

        @Override
        protected Border getInstance() {
            return UIManager.getBorder(this.borderName);
        }
    }

    static interface Client {
        public void paintBackground(Graphics var1, JComponent var2, int var3, int var4);
    }
}

