/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import org.violetlib.jnr.InsetterNotInvertibleException;
import org.violetlib.jnr.impl.Insetter1;

public class RigidInsetter1
implements Insetter1 {
    private final float regionSize;
    private final float componentSize;
    private final float d1;

    public RigidInsetter1(float f, float f2, float f3) {
        if (f < 0.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region or component size");
        }
        if (f > f2) {
            throw new IllegalArgumentException("Invalid region size exceeds component size");
        }
        if (f3 < 0.0f || f3 > f2 - f) {
            throw new IllegalArgumentException("Invalid offset");
        }
        this.regionSize = f;
        this.componentSize = f2;
        this.d1 = f3;
    }

    @Override
    public float getRegionOrigin(float f) {
        return this.d1;
    }

    @Override
    public float getRegionSize(float f) {
        return this.regionSize;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public float getComponentSize(float f) throws InsetterNotInvertibleException {
        return Math.max(this.componentSize, f + this.getFixedInset1() + this.getFixedInset2());
    }

    @Override
    public float getFixedInset1() {
        return this.d1;
    }

    @Override
    public float getFixedInset2() {
        return this.componentSize - this.regionSize - this.d1;
    }

    @Override
    public float getFixedRegionSize() {
        return this.regionSize;
    }
}

