/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.impl.SliderHorizontalTickPainter;
import org.violetlib.jnr.aqua.impl.SliderVerticalTickPainter;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.PainterExtension;

public class LinearSliderPainterExtension
implements PainterExtension {
    @NotNull
    protected final AquaUILayoutInfo uiLayout;
    @NotNull
    protected final SliderConfiguration sg;
    protected Color TICK_COLOR = new Color(10, 10, 10, 110);

    public LinearSliderPainterExtension(@NotNull AquaUILayoutInfo aquaUILayoutInfo, @NotNull SliderConfiguration sliderConfiguration) {
        this.uiLayout = aquaUILayoutInfo;
        this.sg = sliderConfiguration;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        AquaUIPainter.SliderWidget sliderWidget = this.sg.getWidget();
        if (this.sg.hasTickMarks()) {
            this.paintLinearTickMarks(graphics2D, f, f2);
        }
    }

    protected void paintLinearTickMarks(@NotNull Graphics2D graphics2D, float f, float f2) {
        AquaUIPainter.SliderWidget sliderWidget = this.sg.getWidget();
        AquaUIPainter.Size size = this.sg.getSize();
        boolean bl = sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL || sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT;
        int n = this.sg.getNumberOfTickMarks();
        AquaUIPainter.TickMarkPosition tickMarkPosition = this.sg.getTickMarkPosition();
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        double d = 1.0;
        double d2 = JNRUtils.size(size, 4, 3, 3);
        double d3 = 2.0;
        if (bl) {
            double d4;
            double d5;
            double d6;
            boolean bl2 = tickMarkPosition == AquaUIPainter.TickMarkPosition.ABOVE;
            double d7 = d6 = bl2 ? d3 : (double)f2 - d3 - d2;
            if (n == 1) {
                d4 = d5 = this.uiLayout.getSliderThumbCenter(float_, this.sg, 0.5);
            } else {
                d4 = this.uiLayout.getSliderThumbCenter(float_, this.sg, 0.0);
                d5 = this.uiLayout.getSliderThumbCenter(float_, this.sg, 1.0);
                if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
                    double d8 = d4;
                    d4 = d5;
                    d5 = d8;
                }
            }
            SliderHorizontalTickPainter sliderHorizontalTickPainter = new SliderHorizontalTickPainter(this.TICK_COLOR, d, d2, d4, d5, d6, n);
            sliderHorizontalTickPainter.paint(graphics2D);
        } else {
            double d9;
            double d10;
            double d11;
            boolean bl3 = tickMarkPosition == AquaUIPainter.TickMarkPosition.LEFT;
            double d12 = d11 = bl3 ? d3 : (double)f - d3 - d2;
            if (n == 1) {
                d9 = d10 = this.uiLayout.getSliderThumbCenter(float_, this.sg, 0.5);
            } else {
                d9 = this.uiLayout.getSliderThumbCenter(float_, this.sg, 0.0);
                d10 = this.uiLayout.getSliderThumbCenter(float_, this.sg, 1.0);
                if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
                    double d13 = d9;
                    d9 = d10;
                    d10 = d13;
                }
            }
            SliderVerticalTickPainter sliderVerticalTickPainter = new SliderVerticalTickPainter(this.TICK_COLOR, d, d2, d11, d9, d10, n);
            sliderVerticalTickPainter.paint(graphics2D);
        }
    }
}

