/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class HybridAquaUIPainter
implements AquaUIPainter {
    @NotNull
    protected final AquaUIPainter viewPainter;
    @NotNull
    protected final AquaUIPainter coreUIPainter;
    @Nullable
    protected final AquaUIPainter jrsPainter;
    @NotNull
    private final AquaUILayoutInfo layout;
    private int w;
    private int h;

    public HybridAquaUIPainter(@NotNull AquaUIPainter aquaUIPainter, @NotNull AquaUIPainter aquaUIPainter2, @Nullable AquaUIPainter aquaUIPainter3) {
        this.viewPainter = aquaUIPainter;
        this.coreUIPainter = aquaUIPainter2;
        this.jrsPainter = aquaUIPainter3;
        this.layout = aquaUIPainter.getLayoutInfo();
    }

    @Override
    @NotNull
    public HybridAquaUIPainter copy() {
        return new HybridAquaUIPainter(this.viewPainter, this.coreUIPainter, this.jrsPainter);
    }

    @Override
    public void configure(int n, int n2) {
        this.w = n;
        this.h = n2;
    }

    @Override
    @NotNull
    public Painter getPainter(@NotNull Configuration configuration) throws UnsupportedOperationException {
        AquaUIPainter aquaUIPainter = this.select(configuration);
        aquaUIPainter.configure(this.w, this.h);
        return aquaUIPainter.getPainter(configuration);
    }

    @NotNull
    protected AquaUIPainter select(@NotNull Configuration configuration) {
        if (configuration instanceof ButtonConfiguration) {
            ButtonConfiguration buttonConfiguration = (ButtonConfiguration)configuration;
            AquaUIPainter.ButtonWidget buttonWidget = buttonConfiguration.getButtonWidget();
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
                return this.viewPainter;
            }
            return this.coreUIPainter;
        }
        if (configuration instanceof SegmentedButtonConfiguration) {
            return this.coreUIPainter;
        }
        if (configuration instanceof GradientConfiguration) {
            return this.coreUIPainter;
        }
        if (configuration instanceof ComboBoxConfiguration) {
            int n;
            ComboBoxConfiguration comboBoxConfiguration = (ComboBoxConfiguration)configuration;
            AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxConfiguration.getWidget();
            AquaUIPainter.State state = comboBoxConfiguration.getState();
            AquaUIPainter.Size size = comboBoxConfiguration.getSize();
            if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL ? (n = JNRPlatformUtils.getPlatformVersion()) >= 101200 || size == AquaUIPainter.Size.MINI : state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE || comboBoxConfiguration.getLayoutDirection() == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT || comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
                return this.coreUIPainter;
            }
        } else if (configuration instanceof PopupButtonConfiguration) {
            PopupButtonConfiguration popupButtonConfiguration = (PopupButtonConfiguration)configuration;
            if (popupButtonConfiguration.getLayoutDirection() == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT) {
                return this.coreUIPainter;
            }
            AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
            if (popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR) {
                return this.coreUIPainter;
            }
        } else if (configuration instanceof ProgressIndicatorConfiguration) {
            ProgressIndicatorConfiguration progressIndicatorConfiguration = (ProgressIndicatorConfiguration)configuration;
            if (progressIndicatorConfiguration.getWidget() == AquaUIPainter.ProgressWidget.BAR && progressIndicatorConfiguration.getOrientation() == AquaUIPainter.Orientation.HORIZONTAL) {
                return this.coreUIPainter;
            }
        } else {
            if (configuration instanceof IndeterminateProgressIndicatorConfiguration) {
                IndeterminateProgressIndicatorConfiguration indeterminateProgressIndicatorConfiguration = (IndeterminateProgressIndicatorConfiguration)configuration;
                return this.coreUIPainter;
            }
            if (configuration instanceof TextFieldConfiguration) {
                TextFieldConfiguration textFieldConfiguration = (TextFieldConfiguration)configuration;
                AquaUIPainter.TextFieldWidget textFieldWidget = textFieldConfiguration.getWidget();
                if (textFieldWidget != AquaUIPainter.TextFieldWidget.TEXT_FIELD && textFieldWidget != AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND) {
                    return this.coreUIPainter;
                }
            } else if (configuration instanceof SliderConfiguration) {
                SliderConfiguration sliderConfiguration = (SliderConfiguration)configuration;
                if (!sliderConfiguration.hasTickMarks()) {
                    return this.coreUIPainter;
                }
            } else {
                if (configuration instanceof TitleBarConfiguration) {
                    return this.coreUIPainter;
                }
                if (configuration instanceof ScrollBarConfiguration) {
                    return this.coreUIPainter;
                }
            }
        }
        return this.jrsPainter != null ? this.jrsPainter : this.coreUIPainter;
    }

    @Override
    @NotNull
    public AquaUILayoutInfo getLayoutInfo() {
        return this.layout;
    }

    @Override
    @Nullable
    public Shape getOutline(@NotNull LayoutConfiguration layoutConfiguration) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getOutline(layoutConfiguration);
    }

    @Override
    @NotNull
    public Rectangle2D getComboBoxEditorBounds(@NotNull ComboBoxLayoutConfiguration comboBoxLayoutConfiguration) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getComboBoxEditorBounds(comboBoxLayoutConfiguration);
    }

    @Override
    @NotNull
    public Rectangle2D getComboBoxIndicatorBounds(@NotNull ComboBoxLayoutConfiguration comboBoxLayoutConfiguration) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getComboBoxIndicatorBounds(comboBoxLayoutConfiguration);
    }

    @Override
    @NotNull
    public Rectangle2D getPopupButtonContentBounds(@NotNull PopupButtonLayoutConfiguration popupButtonLayoutConfiguration) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getPopupButtonContentBounds(popupButtonLayoutConfiguration);
    }

    @Override
    @NotNull
    public Rectangle2D getSliderThumbBounds(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderThumbBounds(sliderLayoutConfiguration, d);
    }

    @Override
    public double getSliderThumbPosition(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, int n, int n2) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderThumbPosition(sliderLayoutConfiguration, n, n2);
    }

    @Override
    public float getScrollBarThumbPosition(@NotNull ScrollBarThumbLayoutConfiguration scrollBarThumbLayoutConfiguration, boolean bl) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getScrollBarThumbPosition(scrollBarThumbLayoutConfiguration, bl);
    }

    @Override
    public int getScrollBarThumbHit(@NotNull ScrollBarThumbConfiguration scrollBarThumbConfiguration) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getScrollBarThumbHit(scrollBarThumbConfiguration);
    }

    @Override
    @NotNull
    public Rectangle2D getSliderLabelBounds(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d, @NotNull Dimension dimension) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderLabelBounds(sliderLayoutConfiguration, d, dimension);
    }
}

