/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.OSXFile;

public class SavedSearchFileSystemTreeModel
extends FileSystemTreeModel {
    private File savedSearchFile;

    public SavedSearchFileSystemTreeModel(JFileChooser jFileChooser, File file) {
        super(jFileChooser);
        this.savedSearchFile = file;
        this.root = new SavedSearchNode(file, false);
    }

    @Override
    public TreePath toPath(File file, TreePath treePath) {
        if (this.savedSearchFile.equals(file)) {
            return new TreePath(this.getRoot());
        }
        return this.searchForFile(this.root, file);
    }

    private TreePath searchForFile(FileSystemTreeModel.Node node, File file) {
        File file2 = node.getResolvedFile();
        if (file2 != null) {
            if (file.equals(file2)) {
                return new TreePath(node.getPath());
            }
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreePath treePath;
                FileSystemTreeModel.Node node2 = (FileSystemTreeModel.Node)node.getChildAt(i);
                if (node2 == null || (treePath = this.searchForFile(node2, file)) == null) continue;
                return treePath;
            }
        }
        return null;
    }

    public class SavedSearchNode
    extends FileSystemTreeModel.DirectoryNode {
        public SavedSearchNode(File file, boolean bl) {
            super(file, bl);
            this.setTraversable(true);
        }

        @Override
        public String getFileKind() {
            return "Saved Search";
        }

        @Override
        public boolean isAlias() {
            return false;
        }

        @Override
        protected File[] getFiles() {
            File file = this.getFile();
            File[] fileArray = OSXFile.executedSavedSearch(file);
            return fileArray;
        }
    }
}

