/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Image;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.violetlib.aqua.fc.AquaFileChooserUI;
import org.violetlib.aqua.fc.AquaFileView;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.OSXFile;

public class FileInfoUpdateWorker
implements Runnable {
    protected final FileSystemTreeModel.UpdatableFileNode node;
    protected final File f;
    protected final JFileChooser fc;

    public FileInfoUpdateWorker(FileSystemTreeModel.UpdatableFileNode updatableFileNode) {
        this.node = updatableFileNode;
        this.f = updatableFileNode.getFile();
        this.fc = updatableFileNode.getFileChooser();
    }

    @Override
    public void run() {
        int n = OSXFile.getLabel(this.f);
        this.updateFileLabel(n);
        this.updateIcon();
        this.updateCompleted();
    }

    protected void updateIcon() {
        Image image;
        if (!this.canGetFileIconDirectly()) {
            Icon icon = this.fc.getIcon(this.f);
            this.updateFileIcon(icon);
            return;
        }
        try {
            image = OSXFile.getIconImage(this.f, 16, false);
            this.updateFileIcon(new ImageIcon(image));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            image = OSXFile.getIconImage(this.f, 16, true);
            this.updateFileIcon(new ImageIcon(image));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected boolean canGetFileIconDirectly() {
        if (this.fc.getClass() != JFileChooser.class) {
            return false;
        }
        FileView fileView = this.fc.getFileView();
        if (fileView instanceof AquaFileView) {
            return true;
        }
        if (fileView == null) {
            FileChooserUI fileChooserUI = this.fc.getUI();
            return fileChooserUI instanceof AquaFileChooserUI;
        }
        return false;
    }

    protected void updateFileLabel(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileInfoUpdateWorker.this.node.updateFileLabel(n);
            }
        });
    }

    protected void updateFileIcon(final Icon icon) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileInfoUpdateWorker.this.node.updateFileIcon(icon);
            }
        });
    }

    protected void updateCompleted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileInfoUpdateWorker.this.node.updateCompleted();
            }
        });
    }
}

