/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.fc.JBrowser;

public class DefaultColumnCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel textLabel;
    private JLabel arrowLabel;
    private JBrowser browser;
    protected Icon expandedIcon = null;
    protected Icon selectedExpandedIcon = null;
    protected Icon focusedSelectedExpandedIcon = null;
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Color TRANSPARENT_COLOR = new Color(0, true);

    public DefaultColumnCellRenderer(JBrowser jBrowser) {
        this.browser = jBrowser;
        this.expandedIcon = UIManager.getIcon("Browser.expandedIcon");
        this.selectedExpandedIcon = UIManager.getIcon("Browser.selectedExpandedIcon");
        this.focusedSelectedExpandedIcon = UIManager.getIcon("Browser.focusedSelectedExpandedIcon");
        this.setLayout(new BorderLayout());
        this.textLabel = new LabelRenderer();
        this.arrowLabel = new LabelRenderer();
        this.setOpaque(true);
        this.textLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.textLabel.setOpaque(false);
        this.arrowLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.arrowLabel.setOpaque(false);
        this.add((Component)this.textLabel, "Center");
        this.arrowLabel.setIcon(this.expandedIcon);
        this.add((Component)this.arrowLabel, "East");
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        boolean bl3 = AquaFocusHandler.hasFocus(jList);
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            object2 = !bl3 && UIManager.getColor("List.inactiveSelectionForeground") != null ? UIManager.getColor("List.inactiveSelectionForeground") : jList.getSelectionForeground();
            this.textLabel.setForeground((Color)object2);
            this.arrowLabel.setForeground((Color)object2);
            this.arrowLabel.setIcon(bl3 ? this.focusedSelectedExpandedIcon : this.selectedExpandedIcon);
        } else {
            this.setBackground(TRANSPARENT_COLOR);
            object2 = jList.getForeground();
            this.textLabel.setForeground((Color)object2);
            this.arrowLabel.setForeground((Color)object2);
            this.arrowLabel.setIcon(this.expandedIcon);
        }
        this.textLabel.setText(object == null ? "null" : object.toString());
        this.arrowLabel.setVisible(!this.browser.getModel().isLeaf(object));
        this.textLabel.setEnabled(jList.isEnabled());
        this.textLabel.setFont(jList.getFont());
        object2 = UIManager.getBorder(bl2 ? "List.focusCellHighlightBorder" : "List.cellNoFocusBorder");
        if (object2 == null) {
            object2 = DEFAULT_NO_FOCUS_BORDER;
        }
        this.setBorder((Border)object2);
        return this;
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    private static class LabelRenderer
    extends JLabel {
        private LabelRenderer() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string != null && string.equals("text")) {
                super.firePropertyChange(string, object, object2);
            }
        }

        @Override
        public void firePropertyChange(String string, short s, short s2) {
        }

        @Override
        public void firePropertyChange(String string, int n, int n2) {
        }

        @Override
        public void firePropertyChange(String string, long l, long l2) {
        }

        @Override
        public void firePropertyChange(String string, float f, float f2) {
        }

        @Override
        public void firePropertyChange(String string, double d, double d2) {
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    public static class UIResource
    extends DefaultColumnCellRenderer
    implements javax.swing.plaf.UIResource {
        public UIResource(JBrowser jBrowser) {
            super(jBrowser);
        }
    }
}

