/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.fc.BrowserUI;
import org.violetlib.aqua.fc.CompositeTransferable;
import org.violetlib.aqua.fc.DefaultColumnCellRenderer;
import org.violetlib.aqua.fc.DefaultTransferable;
import org.violetlib.aqua.fc.JBrowser;

public class BasicBrowserUI
extends BrowserUI {
    protected JBrowser browser;
    public Icon sizeHandleIcon;
    private static final TransferHandler defaultTransferHandler = new BrowserTransferHandler();

    @Override
    public void installUI(JComponent jComponent) {
        jComponent.setBackground(UIManager.getColor("List.background"));
        jComponent.setFont(UIManager.getFont("List.font"));
        this.sizeHandleIcon = UIManager.getIcon("Browser.sizeHandleIcon");
        this.browser = (JBrowser)jComponent;
        this.installDefaults();
    }

    protected void installDefaults() {
        TransferHandler transferHandler;
        if (this.browser.getColumnCellRenderer() == null || this.browser.getColumnCellRenderer() instanceof UIResource) {
            this.browser.setColumnCellRenderer(this.createCellRenderer());
        }
        if ((transferHandler = this.browser.getTransferHandler()) == null || transferHandler instanceof UIResource) {
            this.browser.setTransferHandler(defaultTransferHandler);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
    }

    protected void uninstallDefaults() {
        if (this.browser.getTransferHandler() instanceof UIResource) {
            this.browser.setTransferHandler(null);
        }
    }

    @Override
    public Icon getSizeHandleIcon() {
        return this.sizeHandleIcon;
    }

    protected ListCellRenderer createCellRenderer() {
        return new DefaultColumnCellRenderer.UIResource(this.browser);
    }

    static class BrowserTransferHandler
    extends TransferHandler
    implements UIResource {
        private JBrowser browser;

        BrowserTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            while (jComponent != null && !(jComponent instanceof JBrowser)) {
                jComponent = jComponent.getParent() instanceof JComponent ? (JComponent)jComponent.getParent() : null;
            }
            if (jComponent != null) {
                this.browser = (JBrowser)jComponent;
                TreePath[] treePathArray = this.browser.getSelectionPaths();
                if (treePathArray == null || treePathArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<ul>\n");
                TreeModel treeModel = this.browser.getModel();
                Object var6_6 = null;
                TreePath[] treePathArray2 = this.getDisplayOrderPaths(treePathArray);
                for (int i = 0; i < treePathArray2.length; ++i) {
                    TreePath treePath = treePathArray2[i];
                    Object object = treePath.getLastPathComponent();
                    boolean bl = treeModel.isLeaf(object);
                    String string = this.getDisplayString(treePath, true, bl);
                    stringBuffer.append(string + "\n");
                    stringBuffer2.append("  <li>" + string + "\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</ul>\n</body>\n</html>");
                this.browser = null;
                CompositeTransferable compositeTransferable = new CompositeTransferable();
                compositeTransferable.add(new DefaultTransferable(stringBuffer2.toString(), "text/html", "HTML"));
                compositeTransferable.add(new DefaultTransferable(stringBuffer.toString(), "text/plain", "Text"));
                return compositeTransferable;
            }
            return null;
        }

        String getDisplayString(TreePath treePath, boolean bl, boolean bl2) {
            String string;
            Object object = treePath.getLastPathComponent();
            if (object != null && (string = object.toString()) != null) {
                return string;
            }
            return "";
        }

        TreePath[] getDisplayOrderPaths(TreePath[] treePathArray) {
            int n;
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            for (n = 0; n < treePathArray.length; ++n) {
                arrayList.add(treePathArray[n]);
            }
            n = arrayList.size();
            TreePath[] treePathArray2 = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                treePathArray2[i] = (TreePath)arrayList.get(i);
            }
            return treePathArray2;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }
}

