/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.violetlib.aqua.AquaTableHeaderCellRenderer;

public class AquaTableHeaderUI
extends BasicTableHeaderUI {
    protected int borderHeight;
    protected Color borderColor;
    private TableCellRenderer prevRenderer = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTableHeaderUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.borderHeight = UIManager.getInt("TableHeader.borderHeight");
        this.borderColor = UIManager.getColor("TableHeader.borderColor");
        this.prevRenderer = this.header.getDefaultRenderer();
        if (this.prevRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new AquaTableHeaderCellRenderer());
        }
    }

    @Override
    public void uninstallDefaults() {
        if (this.header.getDefaultRenderer() instanceof AquaTableHeaderCellRenderer) {
            this.header.setDefaultRenderer(this.prevRenderer);
        }
        super.uninstallDefaults();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        graphics.setColor(this.borderColor);
        graphics.fillRect(0, jComponent.getHeight() - this.borderHeight, jComponent.getWidth(), this.borderHeight);
    }

    private int getHeaderHeightAqua() {
        int n = 0;
        boolean bl = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (tableColumn.getHeaderRenderer() == null && bl) continue;
            Component component = this.getHeaderRendererAqua(i);
            int n2 = component.getPreferredSize().height;
            n = Math.max(n, n2);
            if (n2 <= 4) continue;
            bl = true;
        }
        return n + this.borderHeight;
    }

    private Component getHeaderRendererAqua(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    private Dimension createHeaderSizeAqua(long l) {
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeightAqua());
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSizeAqua(l);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSizeAqua(l);
    }
}

