/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaComboBoxRenderer;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaListMouseBehavior;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.JListModel;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.GradientConfiguration;

public class AquaListUI
extends BasicListUI {
    public static final String LIST_STYLE_KEY = "JList.style";
    public static final String QUAQUA_LIST_STYLE_KEY = "Quaqua.List.style";
    private boolean isStriped = false;
    protected Color[] stripes = new Color[]{UIManager.getColor("List.evenRowBackground"), UIManager.getColor("List.oddRowBackground")};

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaListUI();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new AquaListMouseBehavior(new JListModel(this.list));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.list.putClientProperty("JComponent.isCellContainer", true);
        this.updateStriped();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.list.getActionMap().put("aquaHome", new AquaHomeEndAction(true));
        this.list.getActionMap().put("aquaEnd", new AquaHomeEndAction(false));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new AquaPropertyChangeHandler();
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    protected void repaintSelection() {
        Rectangle rectangle;
        AquaFocusHandler.swapSelectionColors("List", this.list, (Object)AquaFocusHandler.hasFocus(this.list));
        List list = this.list.getSelectedValuesList();
        if (list.size() > 1) {
            this.list.repaint();
            return;
        }
        int n = this.list.getLeadSelectionIndex();
        if (n != -1 && (rectangle = this.getCellBounds(this.list, n, n)) != null) {
            this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintStripes(graphics, jComponent);
        super.paint(graphics, jComponent);
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Serializable serializable;
        Object e = listModel.getElementAt(n);
        boolean bl = this.list.isEnabled();
        boolean bl2 = bl && AquaFocusHandler.hasFocus(this.list);
        boolean bl3 = bl2 && n == n2;
        boolean bl4 = listSelectionModel.isSelectedIndex(n);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (this.list.isOpaque() || bl4) {
            serializable = bl4 ? this.list.getSelectionBackground() : (this.isStriped ? this.getAlternateColor(n % 2) : this.list.getBackground());
            graphics.setColor((Color)serializable);
            graphics.fillRect(n3, n4, n5, n6);
        }
        serializable = listCellRenderer.getListCellRendererComponent(this.list, e, n, bl4, bl3);
        Color color = this.getOverrideCellBackground(n, bl4);
        if (color != null) {
            ((Component)serializable).setBackground(color);
        }
        this.rendererPane.paintComponent(graphics, (Component)serializable, this.list, n3, n4, n5, n6, true);
    }

    protected Color getOverrideCellBackground(int n, boolean bl) {
        if (!this.isStriped) {
            return null;
        }
        if (bl) {
            return null;
        }
        JList.DropLocation dropLocation = this.list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == n) {
            return null;
        }
        return this.getAlternateColor(n % 2);
    }

    public void paintStripes(Graphics graphics, JComponent jComponent) {
        if (this.isStriped && this.list.getModel() != null) {
            int n;
            Dimension dimension = jComponent.getSize();
            Dimension dimension2 = this.list.getSize();
            Point point = this.list.getLocation();
            int n2 = this.list.getFixedCellHeight();
            int n3 = this.list.getModel().getSize();
            if (n2 <= 0) {
                n2 = n3 == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int n4 = Math.abs(point.y / n2);
            int n5 = n3 * n2 - n4 * n2;
            graphics.setColor(this.getAlternateColor(1));
            graphics.fillRect(0, 0, dimension2.width, dimension2.height);
            graphics.setColor(this.getAlternateColor(0));
            if (dimension2.width < dimension.width) {
                n = point.y + n4 * n2;
                while (n < n5) {
                    if (n4 % 2 == 0) {
                        graphics.fillRect(0, n, dimension.width, n2);
                    }
                    n += n2;
                    ++n4;
                }
            }
            if (n5 < dimension.height) {
                n4 = n3;
                n = n5;
                while (n < dimension.height) {
                    if (n4 % 2 == 0) {
                        graphics.fillRect(0, n, dimension.width, n2);
                    }
                    n += n2;
                    ++n4;
                }
            }
        }
    }

    private Color getAlternateColor(int n) {
        return this.stripes[n];
    }

    private void updateStriped() {
        String string = this.getStyleProperty();
        this.isStriped = string != null && string.equals("striped") && this.list.getLayoutOrientation() == 0;
    }

    protected void repaintCell(Object object, int n, boolean bl) {
        AquaComboBoxRenderer aquaComboBoxRenderer;
        Rectangle rectangle = this.getCellBounds(this.list, n, n);
        if (rectangle == null) {
            return;
        }
        ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
        if (listCellRenderer == null) {
            return;
        }
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl, true);
        if (component == null) {
            return;
        }
        AquaComboBoxRenderer aquaComboBoxRenderer2 = aquaComboBoxRenderer = listCellRenderer instanceof AquaComboBoxRenderer ? (AquaComboBoxRenderer)listCellRenderer : null;
        if (aquaComboBoxRenderer != null) {
            aquaComboBoxRenderer.setDrawCheckedItem(false);
        }
        this.rendererPane.paintComponent(this.list.getGraphics().create(), component, this.list, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        if (aquaComboBoxRenderer != null) {
            aquaComboBoxRenderer.setDrawCheckedItem(true);
        }
    }

    public static Border getSourceListBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_SIDE_BAR);
    }

    public static Border getSourceListSelectionBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_SIDE_BAR_SELECTION);
    }

    public static Border getSourceListFocusedSelectionBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_SIDE_BAR_SELECTION);
    }

    public static Border getListEvenBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_LIST_BACKGROUND_EVEN);
    }

    public static Border getListOddBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_LIST_BACKGROUND_ODD);
    }

    static class GradientPainter
    extends AquaBorder {
        protected final AquaUIPainter.GradientWidget gw;

        public GradientPainter(AquaUIPainter.GradientWidget gradientWidget) {
            this.gw = gradientWidget;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
            AquaUIPainter.State state = jComponent != null && !AquaFocusHandler.isActive(jComponent) ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
            this.painter.configure(n3, n4);
            GradientConfiguration gradientConfiguration = new GradientConfiguration(this.gw, state);
            this.painter.getPainter(gradientConfiguration).paint(graphics, n, n2);
        }
    }

    class AquaPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        AquaPropertyChangeHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("Frame.active".equals(string) || "enabled".equals(string)) {
                AquaListUI.this.repaintSelection();
            } else {
                if (AquaListUI.this.isStyleProperty(string)) {
                    AquaListUI.this.updateStriped();
                } else if ("layoutOrientation".equals(string)) {
                    AquaListUI.this.updateStriped();
                }
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    protected class FocusHandler
    implements FocusListener {
        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AquaListUI.this.repaintSelection();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AquaListUI.this.repaintSelection();
        }
    }

    static class AquaHomeEndAction
    extends AbstractAction {
        private boolean fHomeAction = false;

        protected AquaHomeEndAction(boolean bl) {
            this.fHomeAction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            if (this.fHomeAction) {
                jList.ensureIndexIsVisible(0);
            } else {
                int n = jList.getModel().getSize();
                jList.ensureIndexIsVisible(n - 1);
            }
        }
    }
}

