/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.violetlib.aqua.AnimationController;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaDefaultFocusRingProvider;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.FocusRingPainter;
import org.violetlib.aqua.OutlineFocusRingPainter;
import org.violetlib.aqua.OverlayPainterComponent;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.geom.GeneralRoundRectangle;

public class AquaFocusRingPainter {
    protected static final int ANIMATION_DURATION = 100;
    protected static final float DEFAULT_CORNER = 6.0f;
    private JComponent currentDisplayedFocusOwner;
    private FocusRingOutlineProvider currentFocusRingProvider;
    private float animationState;
    private OverlayPainterComponent painterComponent = new MyFocusRingPainterComponent();
    private AnimationController animationController = new AnimationController(new MyAnimation(), 100);
    private FocusRingOutlineProvider defaultFocusRingProvider = new AquaDefaultFocusRingProvider();
    private AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    private final PropertyChangeListener myActiveChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("Frame.active".equals(string)) {
                AquaFocusRingPainter.this.painterComponent.repaint();
            }
        }
    };

    public void setFocusOwner(JComponent jComponent) {
        if (jComponent == null) {
            this.clear();
        } else {
            FocusRingOutlineProvider focusRingOutlineProvider = this.getFocusRingProvider(jComponent);
            if (focusRingOutlineProvider == null) {
                this.clear();
            } else {
                this.currentDisplayedFocusOwner = jComponent;
                this.currentDisplayedFocusOwner.addPropertyChangeListener(this.myActiveChangeListener);
                this.currentFocusRingProvider = focusRingOutlineProvider;
                this.painterComponent.attach(jComponent);
                this.animationState = 0.0f;
                this.animationController.start();
            }
        }
    }

    public void update() {
        if (this.currentDisplayedFocusOwner != null) {
            this.painterComponent.repaint();
        }
    }

    protected void clear() {
        if (this.currentDisplayedFocusOwner != null) {
            this.currentDisplayedFocusOwner.removePropertyChangeListener(this.myActiveChangeListener);
            this.currentDisplayedFocusOwner = null;
            this.currentFocusRingProvider = null;
            this.animationState = 0.0f;
            this.animationController.stop();
            this.painterComponent.attach(null);
        }
    }

    protected FocusRingOutlineProvider getFocusRingProvider(JComponent jComponent) {
        FocusRingOutlineProvider focusRingOutlineProvider = AquaUtils.getUI(jComponent, FocusRingOutlineProvider.class);
        return focusRingOutlineProvider;
    }

    protected FocusRingPainter getFocusRingPainter(Shape shape) {
        Shape shape2;
        Shape shape3;
        boolean bl = this.isCellEditor(this.currentDisplayedFocusOwner);
        float f = bl ? 2.0f : 3.0f;
        float f2 = bl ? 0.0f : -0.5f;
        ExpandableOutline expandableOutline = ExpandableOutline.fromShape(shape);
        float f3 = f + (1.0f - this.animationState) * 10.0f;
        boolean bl2 = false;
        if (shape instanceof Rectangle2D) {
            bl2 = !bl;
        } else if (shape instanceof GeneralRoundRectangle) {
            bl2 = true;
        }
        if (bl2) {
            shape3 = shape;
            Rectangle2D rectangle2D = shape.getBounds2D();
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), 6.0, 6.0);
            expandableOutline = ExpandableOutline.fromShape(double_);
            shape2 = expandableOutline.getShape(f3);
        } else {
            shape2 = expandableOutline.getShape(f3);
            shape3 = expandableOutline.getShape(f2);
        }
        return new OutlineFocusRingPainter(shape3, shape2);
    }

    protected boolean isCellEditor(JComponent jComponent) {
        return this.cellEditorPolicy.isCellEditor(jComponent);
    }

    private class MyAnimation
    implements AnimationController.Animation {
        private MyAnimation() {
        }

        @Override
        public void setAnimationState(float f) {
            AquaFocusRingPainter.this.animationState = f;
            AquaFocusRingPainter.this.painterComponent.repaint();
        }
    }

    protected class MyFocusRingPainterComponent
    extends OverlayPainterComponent {
        public MyFocusRingPainterComponent() {
            super(new Insets(100, 100, 100, 100), 1);
        }

        @Override
        protected void internalPaint(Graphics2D graphics2D) {
            Shape shape;
            if (AquaFocusRingPainter.this.currentDisplayedFocusOwner != null && AquaFocusHandler.isActive(AquaFocusRingPainter.this.currentDisplayedFocusOwner) && AquaFocusRingPainter.this.currentFocusRingProvider != null && (shape = AquaFocusRingPainter.this.currentFocusRingProvider.getFocusRingOutline(AquaFocusRingPainter.this.currentDisplayedFocusOwner)) != null) {
                Color color = UIManager.getColor("Focus.color");
                FocusRingPainter focusRingPainter = AquaFocusRingPainter.this.getFocusRingPainter(shape);
                focusRingPainter.paint(graphics2D, color);
            }
        }
    }
}

