/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;

public class AquaCellEditorPolicy {
    public static final String IS_COMBO_BOX_CELL_EDITOR_PROPERTY = "JComboBox.isTableCellEditor";
    public static final String IS_CELL_EDITOR_PROPERTY = "JComponent.isCellEditor";
    public static final String IS_CELL_CONTAINER_PROPERTY = "JComponent.isCellContainer";
    private static AquaCellEditorPolicy INSTANCE = new AquaCellEditorPolicy();

    public static AquaCellEditorPolicy getInstance() {
        return INSTANCE;
    }

    public static boolean isCellEditorProperty(String string) {
        return IS_COMBO_BOX_CELL_EDITOR_PROPERTY.equals(string) || IS_CELL_EDITOR_PROPERTY.equals(string);
    }

    public boolean isCellEditor(JComponent jComponent) {
        Object object = jComponent.getClientProperty(IS_CELL_EDITOR_PROPERTY);
        if (Boolean.TRUE.equals(object)) {
            return true;
        }
        if (Boolean.FALSE.equals(object)) {
            return false;
        }
        if (Boolean.TRUE.equals(jComponent.getClientProperty(IS_COMBO_BOX_CELL_EDITOR_PROPERTY))) {
            return true;
        }
        return this.isContainedInCellContainer(jComponent);
    }

    protected boolean isContainedInCellContainer(Component component) {
        Container container;
        while ((container = component.getParent()) != null) {
            if (this.isCellContainer(container)) {
                return true;
            }
            component = container;
        }
        return false;
    }

    protected boolean isCellContainer(Container container) {
        Object object;
        JComponent jComponent = container instanceof JComponent ? (JComponent)container : null;
        Object object2 = object = jComponent != null ? jComponent.getClientProperty(IS_CELL_CONTAINER_PROPERTY) : null;
        if (Boolean.TRUE.equals(object)) {
            return true;
        }
        if (container instanceof CellEditorListener && !Boolean.FALSE.equals(object)) {
            return true;
        }
        return jComponent != null && Boolean.TRUE.equals(jComponent.getClientProperty(IS_COMBO_BOX_CELL_EDITOR_PROPERTY));
    }
}

