/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.BasicImageSupport;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.PainterExtension;

public class ReusableCompositor {
    @Nullable
    private int[] data;
    @Nullable
    private BufferedImage b;
    private boolean isConfigured;
    private boolean isEmpty;
    private int rasterWidth;
    private int rasterHeight;
    private int scaleFactor;

    @NotNull
    public static ColorModel getColorModel() {
        return BasicImageSupport.getColorModel();
    }

    public int getRasterWidth() {
        return this.rasterWidth;
    }

    public int getRasterHeight() {
        return this.rasterHeight;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public float getWidth() {
        return (float)this.rasterWidth / (float)this.scaleFactor;
    }

    public float getHeight() {
        return (float)this.rasterHeight / (float)this.scaleFactor;
    }

    public void reset(int n, int n2, int n3) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid negative raster width and/or height");
        }
        if (n3 < 1 || n3 > 8) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        this.rasterWidth = n;
        this.rasterHeight = n2;
        this.scaleFactor = n3;
        this.isEmpty = true;
    }

    protected void ensureConfigured() {
        if (!this.isConfigured) {
            this.isConfigured = true;
            int n = this.rasterWidth * this.rasterHeight;
            if (n > 0) {
                if (this.data == null || this.data.length < n) {
                    this.data = new int[n];
                    this.b = null;
                } else {
                    Arrays.fill(this.data, 0);
                }
            }
        }
    }

    public void render(@NotNull BasicRenderer basicRenderer, int n, int n2, int n3) {
        this.reset(n, n2, n3);
        this.ensureConfigured();
        if (this.data != null) {
            float f = (float)n / (float)n3;
            float f2 = (float)n2 / (float)n3;
            basicRenderer.render(this.data, n, n2, f, f2);
            this.isEmpty = false;
        }
    }

    public void compose(@NotNull Object object) {
        if (object instanceof BasicRenderer) {
            BasicRenderer basicRenderer = (BasicRenderer)object;
            this.composeRenderer(basicRenderer);
        } else if (object instanceof PainterExtension) {
            PainterExtension painterExtension = (PainterExtension)object;
            this.composePainter(painterExtension, 0.0f, 0.0f);
        } else if (object instanceof ReusableCompositor) {
            ReusableCompositor reusableCompositor = (ReusableCompositor)object;
            this.composeFrom(reusableCompositor, 0, 0, this.rasterWidth, this.rasterHeight);
        } else if (object instanceof PixelSource) {
            PixelSource pixelSource = (PixelSource)object;
            pixelSource.composeTo(this);
        } else {
            throw new UnsupportedOperationException("Unsupported pixel source");
        }
    }

    public void composeRenderer(@NotNull BasicRenderer basicRenderer) {
        this.ensureConfigured();
        if (this.data != null) {
            if (this.isEmpty) {
                float f = (float)this.rasterWidth / (float)this.scaleFactor;
                float f2 = (float)this.rasterHeight / (float)this.scaleFactor;
                basicRenderer.render(this.data, this.rasterWidth, this.rasterHeight, f, f2);
                this.isEmpty = false;
            } else {
                this.composeRenderer(basicRenderer, 0, 0, this.rasterWidth, this.rasterHeight);
            }
        }
    }

    public void composeRenderer(@NotNull BasicRenderer basicRenderer, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            ReusableCompositor reusableCompositor = new ReusableCompositor();
            reusableCompositor.render(basicRenderer, n3, n4, this.scaleFactor);
            this.composeFrom(reusableCompositor, n, n2, n3, n4);
        }
    }

    public void composePainter(@NotNull PainterExtension painterExtension, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            ReusableCompositor reusableCompositor = new ReusableCompositor();
            reusableCompositor.reset(n3, n4, this.scaleFactor);
            reusableCompositor.composePainter(painterExtension, 0.0f, 0.0f);
            this.composeFrom(reusableCompositor, n, n2, n3, n4);
        }
    }

    public void composeFrom(@NotNull ReusableCompositor reusableCompositor, int n, int n2, int n3, int n4) {
        int[] nArray;
        this.ensureConfigured();
        if (this.data != null && (nArray = reusableCompositor.data) != null) {
            this.isEmpty = false;
            int n5 = reusableCompositor.getRasterWidth();
            for (int i = 0; i < n4; ++i) {
                int n6 = n2 + i;
                if (n6 < 0 || n6 >= this.rasterHeight) continue;
                for (int j = 0; j < n3; ++j) {
                    int n7;
                    int n8;
                    int n9 = n + j;
                    if (n9 < 0 || n9 >= this.rasterWidth || (n8 = (n7 = nArray[i * n5 + j]) >> 24 & 0xFF) == 0) continue;
                    if (n8 != 255) {
                        n7 = ReusableCompositor.combine(this.data[n6 * this.rasterWidth + n9], n7);
                    }
                    this.data[n6 * this.rasterWidth + n9] = n7;
                }
            }
        }
    }

    public void composeFrom(@NotNull ReusableCompositor reusableCompositor, int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray;
        this.ensureConfigured();
        if (this.data != null && (nArray = reusableCompositor.data) != null) {
            this.isEmpty = false;
            int n7 = reusableCompositor.getRasterWidth();
            int n8 = reusableCompositor.getRasterHeight();
            for (int i = 0; i < n6; ++i) {
                int n9 = n2 + i;
                int n10 = n4 + i;
                if (n10 < 0 || n10 >= this.rasterHeight || n9 < 0 || n9 >= n8) continue;
                for (int j = 0; j < n5; ++j) {
                    int n11;
                    int n12;
                    int n13 = n + j;
                    int n14 = n3 + j;
                    if (n14 < 0 || n14 >= this.rasterWidth || n13 < 0 || n13 >= n7 || (n12 = (n11 = nArray[n9 * n7 + n13]) >> 24 & 0xFF) == 0) continue;
                    if (n12 != 255) {
                        n11 = ReusableCompositor.combine(this.data[n10 * this.rasterWidth + n14], n11);
                    }
                    this.data[n10 * this.rasterWidth + n14] = n11;
                }
            }
        }
    }

    public void composePainter(@NotNull PainterExtension painterExtension, float f, float f2) {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            this.isEmpty = false;
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.scale(this.scaleFactor, this.scaleFactor);
            graphics2D.translate(f, f2);
            float f3 = (float)this.rasterWidth / (float)this.scaleFactor;
            float f4 = (float)this.rasterHeight / (float)this.scaleFactor;
            painterExtension.paint(graphics2D, f3, f4);
        }
    }

    public void renderFrom(@NotNull BasicRenderer basicRenderer) {
        this.ensureConfigured();
        if (this.data != null) {
            this.isEmpty = false;
            float f = (float)this.rasterWidth / (float)this.scaleFactor;
            float f2 = (float)this.rasterHeight / (float)this.scaleFactor;
            basicRenderer.render(this.data, this.rasterWidth, this.rasterHeight, f, f2);
        }
    }

    public void erase(int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            this.ensureConfigured();
            if (this.data != null) {
                for (int i = 0; i < n4; ++i) {
                    int n5 = n2 + i;
                    if (n5 < 0 || n5 >= this.rasterHeight) continue;
                    for (int j = 0; j < n3; ++j) {
                        int n6 = n + j;
                        if (n6 < 0 || n6 >= this.rasterWidth) continue;
                        this.data[n5 * this.rasterWidth + n6] = 0;
                    }
                }
            }
        }
    }

    @Nullable
    public BufferedImage getImage() {
        this.ensureConfigured();
        if (this.b == null && this.data != null) {
            this.b = BasicImageSupport.createImage(this.data, this.rasterWidth, this.rasterHeight);
        }
        return this.b;
    }

    public void paint(@NotNull Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            graphics2D.drawImage(bufferedImage, null, null);
        }
    }

    public static void compose(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 >> 24 & 0xFF;
        if (n6 != 0 && n3 >= 0 && n3 < n && n4 >= 0 && n4 < n2) {
            int n7;
            int n8 = n4 * n + n3;
            int n9 = nArray[n8];
            nArray[n8] = n7 = n6 != 255 ? ReusableCompositor.combine(n9, n5) : n5;
        }
    }

    private static int combine(int n, int n2) {
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n >> 0 & 0xFF;
        int n7 = n2 >> 24 & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n2 >> 8 & 0xFF;
        int n10 = n2 >> 0 & 0xFF;
        int n11 = 255 - n7;
        int n12 = n8 + (n4 * n11 >> 8) & 0xFF;
        int n13 = n9 + (n5 * n11 >> 8) & 0xFF;
        int n14 = n10 + (n6 * n11 >> 8) & 0xFF;
        int n15 = (255 * n7 + n3 * n11) / 255 & 0xFF;
        int n16 = (n15 << 24) + (n12 << 16) + (n13 << 8) + n14;
        return n16;
    }

    public static interface PixelSource {
        public void composeTo(@NotNull ReusableCompositor var1);
    }
}

