/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.JNR18MultiResolutionImage;

public class JNRPlatformUtils {
    @Nullable
    private static String platformVersionString;
    private static int platformVersion;
    @NotNull
    private static final WeakHashMap<Graphics, Integer> scaleMap;

    public static synchronized int getPlatformVersion() {
        if (platformVersionString == null) {
            boolean bl;
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("os.version");
            boolean bl2 = bl = string.equals("Mac OS X") || string.equals("macOS");
            if (bl) {
                platformVersionString = string2;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
                if (stringTokenizer.hasMoreTokens()) {
                    n = JNRPlatformUtils.parseComponent(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        n2 = JNRPlatformUtils.parseComponent(stringTokenizer.nextToken());
                        if (stringTokenizer.hasMoreTokens()) {
                            n3 = JNRPlatformUtils.parseComponent(stringTokenizer.nextToken());
                        }
                    }
                }
                platformVersion = n * 10000 + n2 * 100 + n3;
                return platformVersion;
            }
        }
        return platformVersion;
    }

    private static int parseComponent(@NotNull String string) {
        try {
            int n = Integer.parseInt(string);
            if (n > 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    @Nullable
    public static Graphics2D toGraphics2D(@NotNull Graphics graphics) {
        try {
            return (Graphics2D)graphics;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static int getScaleFactor(@NotNull Graphics graphics) {
        int n;
        Integer n2 = scaleMap.get(graphics);
        if (n2 != null) {
            return n2;
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            n = JNRPlatformUtils.getScaleFactor(graphicsConfiguration);
        } else {
            n = 1;
        }
        scaleMap.put(graphics, n);
        return n;
    }

    public static int getScaleFactor(@NotNull GraphicsConfiguration graphicsConfiguration) {
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        Object object = null;
        try {
            Field field = graphicsDevice.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                object = field.get(graphicsDevice);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 1;
    }

    @NotNull
    public static Image createMultiResolutionImage(int n, int n2, @NotNull BufferedImage bufferedImage) {
        return new JNR18MultiResolutionImage(n, n2, bufferedImage);
    }

    static {
        platformVersion = 0;
        scaleMap = new WeakHashMap();
    }
}

