/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.fc.AquaFileSystemView;
import org.violetlib.aqua.fc.BrowserPreviewRenderer;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.JBrowser;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.OverlayContainer;

public class FilePreview
extends JComponent
implements BrowserPreviewRenderer {
    private JFileChooser fileChooser;
    private JPanel emptyPreview;
    private FileInfo info;
    private JLabel nameView;
    private JTable attributeView;
    private Font labelFont;
    private Font valueFont;
    private Font typeSizeFont;
    private String labelDelimiter;
    private ScaledImageView previewImageView;
    private JProgressBar imageLoadingIndicator;
    private boolean imageIsLoading;
    private Timer imageLoadingTimer;
    private static final Object LABEL_COLUMN_ID = new Object();

    public FilePreview(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
        this.previewImageView = new ScaledImageView();
        this.previewImageView.setMinimumSize(new Dimension(128, 128));
        this.previewImageView.setPreferredSize(new Dimension(128, 128));
        this.imageLoadingIndicator = this.createImageLoadingIndicator();
        this.imageLoadingTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FilePreview.this.imageIsLoading) {
                    FilePreview.this.imageLoadingIndicator.setVisible(true);
                }
            }
        });
        this.imageLoadingTimer.setRepeats(false);
        this.setBorder(BorderFactory.createEmptyBorder(3, 4, 4, 4));
        this.setLayout(new BorderLayout());
        Color color = UIManager.getColor("List.background");
        Color color2 = UIManager.getColor("FileChooser.previewLabelForeground");
        Color color3 = UIManager.getColor("FileChooser.previewValueForeground");
        this.labelFont = UIManager.getFont("FileChooser.previewLabelFont");
        this.valueFont = UIManager.getFont("FileChooser.previewValueFont");
        this.typeSizeFont = UIManager.getFont("FileChooser.previewTypeSizeFont");
        this.emptyPreview = new JPanel();
        this.emptyPreview.setBackground(color);
        this.emptyPreview.setOpaque(true);
        Insets insets = UIManager.getInsets("FileChooser.previewLabelInsets");
        this.labelDelimiter = UIManager.getString("FileChooser.previewLabelDelimiter");
        if (this.labelDelimiter == null) {
            this.labelDelimiter = "";
        }
        int n = 5;
        Serializable serializable = new DefaultTableColumnModel();
        Serializable serializable2 = new TableColumn();
        ((TableColumn)serializable2).setIdentifier(LABEL_COLUMN_ID);
        Object object = new SimpleTableCellRenderer(this.labelFont, color2);
        ((JLabel)object).setHorizontalAlignment(4);
        Component[] componentArray = new Insets(0, 0, 0, 0);
        ((JComponent)object).putClientProperty("Quaqua.Component.visualMargin", componentArray);
        ((TableColumn)serializable2).setCellRenderer((TableCellRenderer)object);
        ((TableColumn)serializable2).setModelIndex(0);
        serializable.addColumn((TableColumn)serializable2);
        serializable2 = new TableColumn();
        object = new SimpleTableCellRenderer(this.valueFont, color3);
        ((JLabel)object).setHorizontalAlignment(2);
        ((TableColumn)serializable2).setCellRenderer((TableCellRenderer)object);
        ((TableColumn)serializable2).setModelIndex(1);
        serializable.addColumn((TableColumn)serializable2);
        if (OSXSystemProperties.OSVersion >= 1010) {
            ((SimpleTableCellRenderer)object).setRowZeroFont(this.typeSizeFont);
            ((SimpleTableCellRenderer)object).setRowZeroColor(color2);
        }
        this.attributeView = new JTable(null, (TableColumnModel)((Object)serializable));
        this.attributeView.setIntercellSpacing(new Dimension(n, 0));
        this.attributeView.setAutoResizeMode(0);
        this.attributeView.setFocusable(false);
        this.setBackground(color);
        this.attributeView.setBackground(color);
        this.setOpaque(true);
        serializable = new OverlayContainer();
        ((Container)serializable).add(this.imageLoadingIndicator);
        ((Container)serializable).add(this.previewImageView);
        ((JComponent)serializable).setMinimumSize(new Dimension(128, 128));
        ((JComponent)serializable).setPreferredSize(new Dimension(128, 128));
        this.add((Component)serializable);
        serializable2 = new Box(1);
        this.add((Component)serializable2, "South");
        if (OSXSystemProperties.OSVersion < 1010) {
            object = new GrayLine();
            ((JComponent)object).setBorder(new EmptyBorder(5, 25, 5, 25));
            ((Container)serializable2).add((Component)object);
        } else {
            this.nameView = new JLabel();
            this.nameView.setFont(UIManager.getFont("FileChooser.previewNameFont"));
            object = new Box(0);
            ((Container)object).add(Box.createHorizontalGlue());
            ((Container)object).add(this.nameView);
            ((Container)object).add(Box.createHorizontalGlue());
            ((JComponent)object).setBorder(new EmptyBorder(0, 0, 20, 0));
            ((Container)serializable2).add((Component)object);
        }
        object = new Box(0);
        ((Container)object).add(Box.createHorizontalGlue());
        ((Container)object).add(this.attributeView);
        ((Container)object).add(Box.createHorizontalGlue());
        ((JComponent)object).setBorder(new EmptyBorder(0, 0, 40, 0));
        ((Container)serializable2).add((Component)object);
        object = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    FilePreview.this.fileChooser.approveSelection();
                }
            }
        };
        this.addMouseListener((MouseListener)object);
        componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener((MouseListener)object);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            Color color = this.getBackground();
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected JProgressBar createImageLoadingIndicator() {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.putClientProperty("JProgressBar.style", "circular");
        return jProgressBar;
    }

    private String toOSXPath(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        AquaFileSystemView aquaFileSystemView = AquaFileSystemView.getAquaFileSystemView();
        if (file != null && file.isDirectory()) {
            stringBuffer.append(':');
        }
        while (file != null) {
            stringBuffer.insert(0, this.fileChooser.getName(file));
            if ((file = ((FileSystemView)aquaFileSystemView).getParentDirectory(file)) == null) continue;
            stringBuffer.insert(0, ':');
        }
        return stringBuffer.toString();
    }

    @Override
    public Component getPreviewRendererComponent(JBrowser jBrowser, TreePath[] treePathArray) {
        Object object;
        if (treePathArray.length > 1) {
            return this.emptyPreview;
        }
        Locale locale = Locale.getDefault();
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(1);
        this.info = (FileInfo)treePathArray[0].getLastPathComponent();
        if (!this.info.isAcceptable()) {
            return this.emptyPreview;
        }
        File file = this.info.getFile();
        String string = this.info.getUserName();
        String string2 = OSXFile.getKindString(file);
        String string3 = this.getLengthString(this.info.getFileLength());
        Date date = OSXFile.getLastUsedDate(file);
        String string4 = this.getModifiedString(file);
        if (this.nameView != null) {
            this.nameView.setText(string);
        }
        AttributeTableModel attributeTableModel = new AttributeTableModel();
        if (OSXSystemProperties.OSVersion < 1010) {
            attributeTableModel.add("name", string);
            attributeTableModel.add("kind", string2);
            if (string3 != null) {
                attributeTableModel.add("size", string3);
            }
            attributeTableModel.add("modified", string4);
            if (date != null) {
                attributeTableModel.add("lastUsed", this.getLastUsedString(date));
            }
        } else {
            object = string2;
            if (string3 != null) {
                object = (String)object + " - " + string3;
            }
            attributeTableModel.add("", (String)object);
            attributeTableModel.add("modified", string4);
            if (date != null) {
                attributeTableModel.add("lastUsed", this.getLastUsedString(date));
            }
        }
        if (this.info.isAlias() && (object = this.info.lazyGetResolvedFile()) != null) {
            attributeTableModel.add("original", this.toOSXPath((File)object));
        }
        this.attributeView.setModel(attributeTableModel);
        attributeTableModel.updatePreferredWidths();
        this.attributeView.revalidate();
        this.attributeView.repaint();
        this.updatePreviewImage();
        return this;
    }

    protected String getLengthString(long l) {
        float f;
        String string;
        if (l < 0L) {
            return null;
        }
        if (l >= 1000000000L) {
            string = "FileChooser.sizeGBytesOnly";
            f = (float)l / 1.0E9f;
        } else if (l >= 1000000L) {
            string = "FileChooser.sizeMBytesOnly";
            f = (float)l / 1000000.0f;
        } else if (l >= 1024L) {
            string = "FileChooser.sizeKBytesOnly";
            f = (float)l / 1000.0f;
        } else {
            string = "FileChooser.sizeBytesOnly";
            f = l;
        }
        String string2 = UIManager.getString(string);
        if (string2 != null) {
            return MessageFormat.format(string2, Float.valueOf(f), l);
        }
        return "" + l;
    }

    protected String getModifiedString(File file) {
        if (file != null) {
            return DateFormat.getInstance().format(new Date(file.lastModified()));
        }
        return null;
    }

    protected String getLastUsedString(Date date) {
        return DateFormat.getInstance().format(date);
    }

    private void updatePreviewImage() {
        File file;
        this.imageLoadingIndicator.setVisible(false);
        this.previewImageView.setVisible(false);
        this.previewImageView.setImage(null);
        this.imageIsLoading = false;
        if (this.info != null && (file = this.info.lazyGetResolvedFile()) != null) {
            this.imageIsLoading = true;
            boolean bl = UIManager.getBoolean("FileChooser.quickLookEnabled");
            PreviewWorker previewWorker = new PreviewWorker(file, bl);
            previewWorker.execute();
            this.imageLoadingTimer.start();
        }
    }

    protected void installPreviewImage(Image image) {
        this.imageLoadingTimer.stop();
        this.imageIsLoading = false;
        this.imageLoadingIndicator.setVisible(false);
        this.previewImageView.setImage(image);
        if (image != null) {
            this.previewImageView.setVisible(true);
        }
    }

    public static int getTextWidth(String string, Font font, JComponent jComponent) {
        Dimension dimension = FilePreview.getTextSize(string, font, jComponent);
        return dimension != null ? dimension.width : 0;
    }

    public static Dimension getTextSize(String string, Font font, JComponent jComponent) {
        if (font == null && (font = jComponent.getFont()) == null) {
            return null;
        }
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = jComponent.getFontMetrics(font);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (fontMetrics == null) {
            return null;
        }
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        return new Dimension(n, n2);
    }

    private static class ScaledImageView
    extends JComponent {
        private Image im;

        private ScaledImageView() {
        }

        public void setImage(Image image) {
            this.im = image;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.im != null) {
                Insets insets = this.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = this.getWidth() - insets.left - insets.right;
                int n4 = this.getHeight() - insets.top - insets.bottom;
                float f = this.im.getWidth(null);
                float f2 = this.im.getHeight(null);
                if (f > 0.0f && f2 > 0.0f) {
                    int n5 = Math.min(n3, n4);
                    float f3 = Math.min((float)n3 / f, (float)n4 / f2);
                    int n6 = (int)Math.max(0.0f, ((float)n3 - f * f3) / 2.0f);
                    int n7 = (int)Math.max(0.0f, ((float)n4 - f2 * f3) / 2.0f);
                    graphics.drawImage(this.im, n + n6, n2 + n7, n5, n5, null);
                }
            }
        }
    }

    private static class GrayLine
    extends JComponent {
        private GrayLine() {
        }

        @Override
        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(0, insets.top + insets.bottom + 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            Insets insets = this.getInsets();
            return new Dimension(100000, insets.top + insets.bottom + 1);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Insets insets = this.getInsets();
            graphics.setColor(new Color(0xD9D9D9));
            graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, 1);
        }
    }

    private static class SimpleTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private Font f;
        private Color fg;
        private Font rowZeroFont;
        private Color rowZeroColor;

        public SimpleTableCellRenderer(Font font, Color color) {
            this.f = font;
            this.fg = color;
            this.setOpaque(false);
        }

        public void setRowZeroFont(Font font) {
            this.rowZeroFont = font;
        }

        public void setRowZeroColor(Color color) {
            this.rowZeroColor = color;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object == null ? "" : object.toString());
            this.setFont(n == 0 && this.rowZeroFont != null ? this.rowZeroFont : this.f);
            this.setForeground(n == 0 && this.rowZeroColor != null ? this.rowZeroColor : this.fg);
            return this;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text" || string == "labelFor" || string == "displayedMnemonic" || (string == "font" || string == "foreground") && object != object2 && this.getClientProperty("html") != null) {
                super.firePropertyChange(string, object, object2);
            }
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    protected class PreviewWorker
    extends SwingWorker<Image, Image> {
        private final File file;
        private final boolean useQuickLook;

        public PreviewWorker(File file, boolean bl) {
            this.file = file;
            this.useQuickLook = bl;
        }

        @Override
        protected Image doInBackground() throws Exception {
            Object object;
            if (this.useQuickLook) {
                object = new QuickLookPreviewWorker(this.file);
                ((SwingWorker)object).execute();
                Image image = (Image)((SwingWorker)object).get(10L, TimeUnit.SECONDS);
                ((SwingWorker)object).cancel(true);
                if (image != null) {
                    this.publish(image);
                    return image;
                }
            }
            object = OSXFile.getIconImage(this.file, 512, false);
            this.publish(object);
            return object;
        }

        @Override
        protected void process(List<Image> list) {
            FilePreview.this.installPreviewImage(list.get(0));
        }
    }

    protected class QuickLookPreviewWorker
    extends SwingWorker<Image, Image> {
        private final File file;

        public QuickLookPreviewWorker(File file) {
            this.file = file;
        }

        @Override
        protected Image doInBackground() throws Exception {
            try {
                return OSXFile.getIconImage(this.file, 1600, true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return null;
            }
        }
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private List<String> names = new ArrayList<String>();
        private List<String> values = new ArrayList<String>();
        private int nameWidth;
        private int valueWidth;

        private AttributeTableModel() {
        }

        public void add(String string, String string2) {
            if (string2 != null && !string2.isEmpty()) {
                String string3 = UIManager.getString("FileChooser." + string);
                String string4 = (string3 != null ? string3 : string) + FilePreview.this.labelDelimiter;
                this.names.add(string4);
                this.values.add(string2);
                this.nameWidth = Math.max(this.nameWidth, FilePreview.getTextWidth(string4, FilePreview.this.labelFont, FilePreview.this.attributeView));
                this.valueWidth = Math.max(this.valueWidth, FilePreview.getTextWidth(string2, FilePreview.this.valueFont, FilePreview.this.attributeView));
            }
        }

        public void updatePreferredWidths() {
            int n = 15;
            FilePreview.this.attributeView.getColumnModel().getColumn(0).setPreferredWidth(this.nameWidth + n);
            FilePreview.this.attributeView.getColumnModel().getColumn(1).setPreferredWidth(this.valueWidth + n);
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Attribute";
            }
            if (n == 1) {
                return "Value";
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.names.get(n);
            }
            if (n2 == 1) {
                return this.values.get(n);
            }
            return null;
        }
    }
}

