/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.violetlib.aqua.AquaNativeSupport;

public class OSXSystemProperties {
    public static final int OSVersion = OSXSystemProperties.getOSVersion();
    private static boolean hasBeenSynchronized;
    private static boolean isFullKeyboardAccessEnabled;
    private static boolean useOverlayScrollBars;
    private static boolean reduceTransparency;
    private static final List<ChangeListener> changeListeners;

    private static int getOSVersion() {
        String string = System.getProperty("os.version");
        int n = string.indexOf(46);
        int n2 = Integer.parseInt(string.substring(0, n));
        int n3 = Integer.parseInt((n = (string = string.substring(n + 1)).indexOf(46)) >= 0 ? string.substring(0, n) : string);
        return n2 * 100 + n3;
    }

    public static boolean isFullKeyboardAccessEnabled() {
        OSXSystemProperties.ensureSynchronized();
        return isFullKeyboardAccessEnabled;
    }

    public static boolean isReduceTransparency() {
        OSXSystemProperties.ensureSynchronized();
        return reduceTransparency;
    }

    public static boolean doScrollPanesSupportRTL() {
        return false;
    }

    public static boolean isShowAllFiles() {
        if (AquaNativeSupport.load()) {
            return OSXSystemProperties.nativeGetShowAllFiles();
        }
        return false;
    }

    public static boolean useOverlayScrollBars() {
        OSXSystemProperties.ensureSynchronized();
        return useOverlayScrollBars;
    }

    public static boolean isScrollToClick() {
        if (AquaNativeSupport.load()) {
            return OSXSystemProperties.nativeGetScrollToClick();
        }
        return false;
    }

    public static synchronized void addChangeListener(ChangeListener changeListener) {
        if (!changeListeners.contains(changeListener)) {
            changeListeners.add(changeListener);
        }
    }

    public static synchronized void removeChangeListener(ChangeListener changeListener) {
        changeListeners.remove(changeListener);
    }

    private static void fireChangeEvent() {
        if (!changeListeners.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangeEvent changeEvent = new ChangeEvent(OSXSystemProperties.class);
                    for (ChangeListener changeListener : changeListeners) {
                        changeListener.stateChanged(changeEvent);
                    }
                }
            });
        }
    }

    private static void ensureSynchronized() {
        if (!hasBeenSynchronized) {
            if (AquaNativeSupport.load()) {
                OSXSystemProperties.synchronize();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        OSXSystemProperties.synchronize();
                    }
                };
                OSXSystemProperties.enableCallback(runnable);
            } else {
                hasBeenSynchronized = true;
            }
        }
    }

    private static synchronized void synchronize() {
        boolean bl = isFullKeyboardAccessEnabled;
        isFullKeyboardAccessEnabled = OSXSystemProperties.nativeGetFullKeyboardAccessEnabled();
        boolean bl2 = useOverlayScrollBars;
        useOverlayScrollBars = OSXSystemProperties.nativeGetUseOverlayScrollBars();
        boolean bl3 = reduceTransparency;
        reduceTransparency = OSXSystemProperties.nativeGetReduceTransparency();
        if (hasBeenSynchronized && isFullKeyboardAccessEnabled != bl || useOverlayScrollBars != bl2 || reduceTransparency != bl3) {
            OSXSystemProperties.fireChangeEvent();
        }
        hasBeenSynchronized = true;
    }

    private static native boolean nativeGetFullKeyboardAccessEnabled();

    private static native boolean nativeGetShowAllFiles();

    private static native boolean nativeGetScrollToClick();

    private static native boolean nativeGetUseOverlayScrollBars();

    private static native boolean nativeGetReduceTransparency();

    private static native void enableCallback(Runnable var0);

    static {
        changeListeners = new ArrayList<ChangeListener>();
    }
}

