/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Border2D;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insets2DUIResource;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;

public class AquaTextFieldBorder
extends AquaBorder
implements FocusRingOutlineProvider,
Border2D {
    protected static final AquaUtils.RecyclableSingleton<AquaTextFieldBorder> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaTextFieldBorder>(AquaTextFieldBorder.class);

    public static AquaTextFieldBorder getTextFieldBorder() {
        return instance.get();
    }

    public AquaTextFieldBorder() {
    }

    public AquaTextFieldBorder(AquaTextFieldBorder aquaTextFieldBorder) {
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintBackground(JComponent jComponent, Graphics graphics) {
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            int n = jTextComponent.getWidth();
            int n2 = jTextComponent.getHeight();
            graphics.setColor(jTextComponent.getBackground());
            if (jTextComponent.isOpaque()) {
                graphics.fillRect(0, 0, n, n2);
                return;
            }
            Painter painter = this.getConfiguredPainter(jTextComponent);
            painter.paint(graphics, 0.0f, 0.0f);
        }
    }

    public LayoutInfo getLayoutInfo(JTextComponent jTextComponent) {
        TextFieldLayoutConfiguration textFieldLayoutConfiguration = this.getLayoutConfiguration(jTextComponent);
        return this.painter.getLayoutInfo().getLayoutInfo(textFieldLayoutConfiguration);
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            TextFieldLayoutConfiguration textFieldLayoutConfiguration = this.getLayoutConfiguration(jTextComponent);
            this.painter.configure(jTextComponent.getWidth(), jTextComponent.getHeight());
            return this.painter.getOutline(textFieldLayoutConfiguration);
        }
        return null;
    }

    public int getTextMargin(JTextComponent jTextComponent) {
        if (AquaCellEditorPolicy.getInstance().isCellEditor(jTextComponent)) {
            return 1;
        }
        AquaUIPainter.TextFieldWidget textFieldWidget = this.getWidget(jTextComponent);
        int n = textFieldWidget == AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND ? 11 : 3;
        Insets insets = this.getBorderInsets(jTextComponent);
        int n2 = (insets.left + insets.right) / 2;
        return Math.max(0, n - n2);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (component instanceof JTextComponent) {
            Insets2D insets2D;
            JTextComponent jTextComponent = (JTextComponent)component;
            if (AquaCellEditorPolicy.getInstance().isCellEditor(jTextComponent)) {
                return new InsetsUIResource(0, 0, 0, 0);
            }
            Insetter insetter = this.getTextInsets(jTextComponent);
            if (insetter != null && (insets2D = insetter.asInsets2D()) != null) {
                int n = (int)Math.ceil(insets2D.getLeft());
                int n2 = (int)Math.ceil(insets2D.getRight());
                int n3 = (int)Math.floor(insets2D.getTop());
                int n4 = (int)Math.ceil(insets2D.getBottom());
                return new InsetsUIResource(n3, n, n4, n2);
            }
        }
        return new InsetsUIResource(3, 3, 3, 3);
    }

    @Override
    public Insets2D getBorderInsets2D(Component component) {
        if (component instanceof JTextComponent) {
            Insets2D insets2D;
            JTextComponent jTextComponent = (JTextComponent)component;
            if (AquaCellEditorPolicy.getInstance().isCellEditor(jTextComponent)) {
                return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
            }
            Insetter insetter = this.getTextInsets(jTextComponent);
            if (insetter != null && (insets2D = insetter.asInsets2D()) != null) {
                return new Insets2DUIResource(insets2D);
            }
        }
        return new Insets2DUIResource(3.0f, 3.0f, 3.0f, 3.0f);
    }

    public Insetter getTextInsets(JTextComponent jTextComponent) {
        TextFieldLayoutConfiguration textFieldLayoutConfiguration = this.getLayoutConfiguration(jTextComponent);
        return this.painter.getLayoutInfo().getTextFieldTextInsets(textFieldLayoutConfiguration);
    }

    public int getExtraHeight(JTextComponent jTextComponent) {
        TextFieldLayoutConfiguration textFieldLayoutConfiguration = this.getLayoutConfiguration(jTextComponent);
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldLayoutConfiguration.getWidget();
        switch (textFieldWidget) {
            case TEXT_FIELD: 
            case TEXT_FIELD_ROUND: {
                return 3;
            }
        }
        return 0;
    }

    protected Painter getConfiguredPainter(JTextComponent jTextComponent) {
        int n = jTextComponent.getWidth();
        int n2 = jTextComponent.getHeight();
        this.painter.configure(n, n2);
        TextFieldConfiguration textFieldConfiguration = this.getConfiguration(jTextComponent);
        return this.painter.getPainter(textFieldConfiguration);
    }

    protected TextFieldLayoutConfiguration getLayoutConfiguration(JTextComponent jTextComponent) {
        AquaUIPainter.TextFieldWidget textFieldWidget = this.getWidget(jTextComponent);
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(jTextComponent);
        AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(jTextComponent);
        return new TextFieldLayoutConfiguration(textFieldWidget, size, uILayoutDirection);
    }

    protected TextFieldConfiguration getConfiguration(JTextComponent jTextComponent) {
        AquaUIPainter.TextFieldWidget textFieldWidget = this.getWidget(jTextComponent);
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(jTextComponent);
        AquaUIPainter.State state = this.getStateFor(jTextComponent);
        boolean bl = AquaUIPainter.State.ACTIVE == state && jTextComponent.hasFocus();
        AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(jTextComponent);
        return new TextFieldConfiguration(textFieldWidget, size, state, bl, uILayoutDirection);
    }

    protected AquaUIPainter.TextFieldWidget getWidget(JTextComponent jTextComponent) {
        Object object = jTextComponent.getClientProperty("JTextField.style");
        if ("round".equals(object)) {
            return AquaTextFieldBorder.isOnToolbar(jTextComponent) ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND;
        }
        if (AquaTextFieldBorder.isOnToolbar(jTextComponent)) {
            return AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND_TOOLBAR;
        }
        return AquaUIPainter.TextFieldWidget.TEXT_FIELD;
    }

    public static boolean isOnToolbar(JTextComponent jTextComponent) {
        return AquaUtils.isOnToolbar(jTextComponent);
    }

    protected AquaUIPainter.State getStateFor(JTextComponent jTextComponent) {
        if (!AquaFocusHandler.isActive(jTextComponent)) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (!jTextComponent.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (!jTextComponent.isEditable()) {
            return AquaUIPainter.State.DISABLED;
        }
        return AquaUIPainter.State.ACTIVE;
    }
}

