/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.violetlib.aqua.AquaCustomStyledWindow;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;

public class AquaRootPaneUI
extends BasicRootPaneUI
implements AncestorListener,
WindowListener,
ContainerListener {
    public static final String AQUA_WINDOW_STYLE_KEY = "Aqua.windowStyle";
    public static final String AQUA_WINDOW_TOP_MARGIN_KEY = "Aqua.windowTopMargin";
    public static final String AQUA_WINDOW_BOTTOM_MARGIN_KEY = "Aqua.windowBottomMargin";
    private static boolean forceActiveWindowDisplay;
    protected JRootPane rootPane;
    protected WindowHierarchyListener hierarchyListener;
    protected AncestorChangeListener ancestorChangeListener;
    protected PropertyChangeListener windowStylePropertyChangeListener;
    protected boolean isInitialized;
    protected AquaCustomStyledWindow customStyledWindow;
    protected int vibrantStyle = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaRootPaneUI();
    }

    public static void setForceActiveWindowDisplay(boolean bl) {
        if (bl != forceActiveWindowDisplay) {
            Window[] windowArray;
            forceActiveWindowDisplay = bl;
            for (Window window : windowArray = Window.getWindows()) {
                boolean bl2;
                boolean bl3;
                RootPaneContainer rootPaneContainer;
                JRootPane jRootPane;
                AquaRootPaneUI aquaRootPaneUI;
                if (!(window instanceof RootPaneContainer) || (aquaRootPaneUI = AquaUtils.getUI(jRootPane = (rootPaneContainer = (RootPaneContainer)((Object)window)).getRootPane(), AquaRootPaneUI.class)) == null || (bl3 = bl || window.isActive()) == (bl2 = Boolean.TRUE.equals(jRootPane.getClientProperty("Frame.active")))) continue;
                jRootPane.repaint();
                AquaRootPaneUI.updateComponentTreeUIActivation(jRootPane, bl3);
            }
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        JFrame jFrame;
        Color color;
        Container container;
        this.rootPane = (JRootPane)jComponent;
        super.installUI(jComponent);
        jComponent.addAncestorListener(this);
        this.ancestorChangeListener = new AncestorChangeListener();
        if (jComponent.isShowing() && jComponent.isEnabled()) {
            this.updateDefaultButton(this.rootPane);
        }
        if ((container = jComponent.getParent()) != null && container instanceof JFrame && ((color = (jFrame = (JFrame)container).getBackground()) == null || color instanceof UIResource)) {
            jFrame.setBackground(UIManager.getColor("Panel.background"));
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removeAncestorListener(this);
        this.uninstallCustomWindowStyle();
        this.removeVisualEffectView();
        this.isInitialized = false;
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installListeners(JRootPane jRootPane) {
        super.installListeners(jRootPane);
        this.hierarchyListener = new WindowHierarchyListener();
        jRootPane.addHierarchyListener(this.hierarchyListener);
    }

    @Override
    protected void uninstallListeners(JRootPane jRootPane) {
        jRootPane.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        jRootPane.removePropertyChangeListener("ancestor", this.ancestorChangeListener);
        this.ancestorChangeListener = null;
        super.uninstallListeners(jRootPane);
        if (this.windowStylePropertyChangeListener != null) {
            jRootPane.removePropertyChangeListener(this.windowStylePropertyChangeListener);
            this.windowStylePropertyChangeListener = null;
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getContainer() instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)containerEvent.getContainer();
            if (containerEvent.getChild() == jRootPane.getLayeredPane()) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.addContainerListener(this);
            }
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getContainer() instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)containerEvent.getContainer();
            if (containerEvent.getChild() == jRootPane.getLayeredPane()) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.removeContainerListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("defaultButton".equals(string) || "temporaryDefaultButton".equals(string)) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            if (jRootPane.isShowing() && jRootPane.isEnabled()) {
                this.updateDefaultButton(jRootPane);
            }
        } else if ("enabled".equals(string) || "Frame.active".equals(string)) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            if (jRootPane.isShowing() && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.updateDefaultButton((JRootPane)propertyChangeEvent.getSource());
            }
        } else if ("Aqua.backgroundStyle".equals(string)) {
            Object object = propertyChangeEvent.getNewValue();
            this.setupBackgroundStyle(object, true);
        } else if (AQUA_WINDOW_STYLE_KEY.equals(string) || AQUA_WINDOW_TOP_MARGIN_KEY.equals(string) || AQUA_WINDOW_BOTTOM_MARGIN_KEY.equals(string)) {
            this.uninstallCustomWindowStyle();
            this.installCustomWindowStyle();
        }
    }

    protected void refreshWindowStyleMask() {
        if (this.customStyledWindow != null) {
            this.customStyledWindow.refreshWindowStyleMask();
        }
    }

    synchronized void updateDefaultButton(JRootPane jRootPane) {
        JButton jButton = jRootPane.getDefaultButton();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        JRootPane jRootPane;
        JComponent jComponent = ancestorEvent.getComponent();
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        JRootPane jRootPane2 = jRootPane = jComponent instanceof JRootPane ? (JRootPane)jComponent : null;
        if (window != null) {
            window.removeWindowListener(this);
            window.addWindowListener(this);
        }
        if (jRootPane != null && jRootPane.isEnabled() && jRootPane.getDefaultButton() != null) {
            this.updateDefaultButton(jRootPane);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        AquaRootPaneUI.updateWindowActivation(windowEvent, Boolean.TRUE);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        AquaRootPaneUI.updateWindowActivation(windowEvent, Boolean.FALSE);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        window.removeWindowListener(this);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowStateChanged(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    private static void updateWindowActivation(WindowEvent windowEvent, Object object) {
        if (forceActiveWindowDisplay) {
            object = Boolean.TRUE;
        }
        Component component = (Component)windowEvent.getSource();
        component.repaint();
        AquaRootPaneUI.updateComponentTreeUIActivation(component, object);
    }

    private static void updateComponentTreeUIActivation(Component component, Object object) {
        if (component instanceof JInternalFrame) {
            Object object2 = object = ((JInternalFrame)component).isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("Frame.active", object);
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray == null) {
            return;
        }
        for (Component component2 : componentArray) {
            AquaRootPaneUI.updateComponentTreeUIActivation(component2, object);
        }
    }

    @Override
    public final void update(Graphics graphics, JComponent jComponent) {
        if (this.customStyledWindow != null) {
            this.customStyledWindow.paintBackground(graphics);
        } else if (jComponent.isOpaque() || this.vibrantStyle >= 0) {
            AquaUtils.fillRect(graphics, jComponent, 3);
        }
        this.paint(graphics, jComponent);
    }

    public void configure() {
        if (this.rootPane.getParent() != null && this.rootPane.getParent().isDisplayable()) {
            this.isInitialized = true;
            this.updatePopupStyle(this.rootPane);
            this.installCustomWindowStyle();
            this.updateVisualEffectView();
        }
    }

    protected void updatePopupStyle(JRootPane jRootPane) {
        Component component;
        int n;
        Container container;
        Window window = SwingUtilities.getWindowAncestor(jRootPane);
        if (window != null && window.getType() == Window.Type.POPUP && (container = jRootPane.getContentPane()) != null && (n = container.getComponentCount()) == 1 && (component = container.getComponent(0)) instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Object object = jComponent.getClientProperty("AquaPopup.backgroundStyle");
            this.setupBackgroundStyle(object, false);
            object = jComponent.getClientProperty("AquaPopup.cornerRadius");
            this.setupCornerRadius(object);
        }
    }

    protected void setupBackgroundStyle(Object object, boolean bl) {
        int n = AquaVibrantSupport.parseVibrantStyle(object, false);
        if (n != this.vibrantStyle) {
            this.vibrantStyle = n;
            this.rootPane.setBackground(this.vibrantStyle >= 0 ? new Color(0, 0, 0, 0) : null);
            if (this.isInitialized && bl) {
                this.updateVisualEffectView();
            }
        }
    }

    protected void setupCornerRadius(Object object) {
        Object object2;
        float f = 0.0f;
        if (object != null) {
            if (object instanceof String) {
                object2 = (String)object;
                if (((String)object2).equals("default")) {
                    f = 6.0f;
                }
            } else if (object instanceof Number) {
                f = ((Number)object).floatValue();
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
        }
        object2 = SwingUtilities.getWindowAncestor(this.rootPane);
        AquaUtils.setCornerRadius((Window)object2, f);
    }

    protected void updateVisualEffectView() {
        Window window = SwingUtilities.getWindowAncestor(this.rootPane);
        if (window != null) {
            if (this.vibrantStyle >= 0) {
                try {
                    AquaVibrantSupport.addFullWindowVibrantView(window, this.vibrantStyle);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Unable to install visual effect view: " + illegalArgumentException.getMessage());
                }
            } else {
                AquaVibrantSupport.removeFullWindowVibrantView(window);
            }
        }
    }

    protected void removeVisualEffectView() {
        Window window = SwingUtilities.getWindowAncestor(this.rootPane);
        if (window != null) {
            AquaVibrantSupport.removeFullWindowVibrantView(window);
        }
    }

    protected void installCustomWindowStyle() {
        Window window;
        int n;
        if (this.customStyledWindow == null && (n = this.getCustomWindowStyle()) >= 0 && (window = SwingUtilities.getWindowAncestor(this.rootPane)) != null) {
            try {
                this.customStyledWindow = new AquaCustomStyledWindow(window, n);
            }
            catch (AquaCustomStyledWindow.RequiredToolBarNotFoundException requiredToolBarNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AquaUtils.syslog("Unable to install custom window style: " + illegalArgumentException.getMessage());
            }
        }
    }

    protected void uninstallCustomWindowStyle() {
        if (this.customStyledWindow != null) {
            this.customStyledWindow.dispose();
            this.customStyledWindow = null;
        }
    }

    public AquaCustomStyledWindow getCustomStyledWindow() {
        return this.customStyledWindow;
    }

    protected int getCustomWindowStyle() {
        Object object = this.rootPane.getClientProperty(AQUA_WINDOW_STYLE_KEY);
        if (object instanceof String) {
            if ("unifiedToolBar".equals(object)) {
                return 3;
            }
            if ("texturedToolBar".equals(object)) {
                return 4;
            }
            if ("combinedToolBar".equals(object)) {
                return 5;
            }
            if ("overlayTitleBar".equals(object)) {
                return 0;
            }
            if ("transparentTitleBar".equals(object)) {
                return 1;
            }
            if ("noTitleBar".equals(object)) {
                return 2;
            }
        }
        return -1;
    }

    protected class WindowHierarchyListener
    implements HierarchyListener {
        protected WindowHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (!AquaRootPaneUI.this.isInitialized && hierarchyEvent.getChangeFlags() == 2L) {
                AquaRootPaneUI.this.rootPane.addPropertyChangeListener("ancestor", AquaRootPaneUI.this.ancestorChangeListener);
                AquaRootPaneUI.this.configure();
            }
        }
    }

    protected class WindowStylePropertyChangeListener
    implements PropertyChangeListener {
        protected WindowStylePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null && (string.equals("Window.closeable") || string.equals("Window.minimizable"))) {
                AquaRootPaneUI.this.refreshWindowStyleMask();
            }
        }
    }

    protected class AncestorChangeListener
    implements PropertyChangeListener {
        protected AncestorChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getNewValue() != null) {
                AquaRootPaneUI.this.refreshWindowStyleMask();
                if (AquaRootPaneUI.this.windowStylePropertyChangeListener == null) {
                    AquaRootPaneUI.this.windowStylePropertyChangeListener = new WindowStylePropertyChangeListener();
                    AquaRootPaneUI.this.rootPane.addPropertyChangeListener(AquaRootPaneUI.this.windowStylePropertyChangeListener);
                }
            }
        }
    }
}

