/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ImageIconUIResource;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AbstractComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

class AquaComboBoxButton
extends JButton {
    public static final String BUTTON_TYPE = "JButton.buttonType";
    public static final String LAYOUT_CONFIGURATION_PROPERTY = "Aqua.ComboBox.LayoutConfiguration";
    private static AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    private static AquaComboBoxHierarchyListener hierarchyListener = new AquaComboBoxHierarchyListener();
    protected final JComboBox<Object> comboBox;
    protected final JList<?> list;
    protected final CellRendererPane rendererPane;
    protected final AquaComboBoxUI ui;
    protected final AquaButtonExtendedTypes.ColorDefaults colorDefaults;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected boolean isPopDown;
    protected String style;
    protected AquaUIPainter.Size sizeVariant;
    protected boolean isRollover;
    protected ImageIcon lastTestedIcon;
    protected boolean lastTestedIconIsTemplate;

    protected AquaComboBoxButton(AquaComboBoxUI aquaComboBoxUI, JComboBox<Object> jComboBox, CellRendererPane cellRendererPane, JList<?> jList) {
        super("");
        this.putClientProperty(BUTTON_TYPE, "comboboxInternal");
        this.ui = aquaComboBoxUI;
        this.comboBox = jComboBox;
        this.rendererPane = cellRendererPane;
        this.list = jList;
        this.colorDefaults = new AquaButtonExtendedTypes.ColorDefaults();
        this.colorDefaults.disabledTextColor = UIManager.getColor("ComboBox.disabledForeground");
        this.colorDefaults.enabledTextColor = UIManager.getColor("ComboBox.foreground");
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() ? true : bl);
            }
        });
        this.setEnabled(jComboBox.isEnabled());
        this.addMouseListener(new RolloverMouseListener());
        this.addHierarchyListener(hierarchyListener);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox == null ? true : this.comboBox.isEnabled();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void configure(AquaUIPainter.Size size) {
        Object object;
        Object object2 = this.comboBox.getClientProperty("JComboBox.isPopDown");
        this.isPopDown = Boolean.TRUE.equals(object2);
        object2 = null;
        Object object3 = this.comboBox.getClientProperty("JComboBox.style");
        if (object3 instanceof String) {
            object2 = (String)object3;
        } else {
            object3 = this.comboBox.getClientProperty("JComboBox.isSquare");
            if (Boolean.TRUE.equals(object3)) {
                object2 = "old_square";
            }
        }
        if ("textured".equals(object2) && AquaComboBoxButton.isOnToolbar(this.comboBox)) {
            object2 = "textured-onToolbar";
        }
        this.style = object2;
        if (size != null) {
            this.sizeVariant = size;
        }
        if (this.sizeVariant == null) {
            this.sizeVariant = AquaUIPainter.Size.REGULAR;
        }
        boolean bl = this.comboBox.isEditable();
        AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(this.comboBox);
        if (bl) {
            object = this.getComboBoxWidget();
            object2 = new ComboBoxLayoutConfiguration((AquaUIPainter.ComboBoxWidget)((Object)object), this.sizeVariant, uILayoutDirection);
            ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
            if (comboBoxEditor instanceof AquaComboBoxUI.AquaComboBoxEditor) {
                AquaComboBoxUI.AquaComboBoxEditor aquaComboBoxEditor = (AquaComboBoxUI.AquaComboBoxEditor)comboBoxEditor;
                aquaComboBoxEditor.configure((AquaUIPainter.ComboBoxWidget)((Object)object));
            }
        } else {
            object = this.getPopupButtonWidget();
            this.sizeVariant = this.canonicalize(this.sizeVariant, (AquaUIPainter.PopupButtonWidget)((Object)object));
            object2 = new PopupButtonLayoutConfiguration((AquaUIPainter.PopupButtonWidget)((Object)object), this.sizeVariant, uILayoutDirection);
        }
        this.comboBox.putClientProperty(LAYOUT_CONFIGURATION_PROPERTY, object2);
        if (AquaUtilControlSize.isOKToInstallDefaultFont(this.comboBox)) {
            object = this.getDefaultFont((LayoutConfiguration)object2);
            AquaUtilControlSize.installDefaultFont(this.comboBox, (Font)object);
        }
        this.comboBox.revalidate();
        this.comboBox.repaint();
    }

    public AbstractComboBoxLayoutConfiguration getLayoutConfiguration() {
        return (AbstractComboBoxLayoutConfiguration)this.comboBox.getClientProperty(LAYOUT_CONFIGURATION_PROPERTY);
    }

    protected AquaUIPainter.Size canonicalize(AquaUIPainter.Size size, AquaUIPainter.PopupButtonWidget popupButtonWidget) {
        switch (popupButtonWidget) {
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_DOWN_SQUARE: 
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_DOWN_GRADIENT: {
                return AquaUIPainter.Size.REGULAR;
            }
        }
        return size;
    }

    protected Font getDefaultFont(LayoutConfiguration layoutConfiguration) {
        Font font = this.comboBox.getFont();
        Object object = this.getWidget(layoutConfiguration);
        if (object != null) {
            return AquaButtonExtendedTypes.getFont(font, object, this.sizeVariant);
        }
        return font;
    }

    protected Object getWidget(LayoutConfiguration layoutConfiguration) {
        if (layoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            ComboBoxLayoutConfiguration comboBoxLayoutConfiguration = (ComboBoxLayoutConfiguration)layoutConfiguration;
            return comboBoxLayoutConfiguration.getWidget();
        }
        if (layoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)layoutConfiguration;
            return popupButtonLayoutConfiguration.getPopupButtonWidget();
        }
        return null;
    }

    protected AquaUIPainter.ComboBoxWidget getComboBoxWidget() {
        if (cellEditorPolicy.isCellEditor(this.comboBox)) {
            return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL;
        }
        if (this.style != null) {
            switch (this.style) {
                case "tableHeader": 
                case "cell": 
                case "borderless": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL;
                }
                case "textured": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED;
                }
                case "textured-onToolbar": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR;
                }
            }
        }
        if (AquaComboBoxButton.isOnToolbar(this.comboBox)) {
            return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR;
        }
        return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX;
    }

    protected AquaUIPainter.PopupButtonWidget getPopupButtonWidget() {
        if (cellEditorPolicy.isCellEditor(this.comboBox)) {
            return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL;
        }
        if (this.style != null) {
            switch (this.style) {
                case "tableHeader": 
                case "cell": 
                case "borderless": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL;
                }
                case "square": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT;
                }
                case "old_square": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE;
                }
                case "bevel": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_BEVEL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL;
                }
                case "roundRect": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_ROUND_RECT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_ROUND_RECT;
                }
                case "recessed": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED;
                }
                case "textured": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED;
                }
                case "textured-onToolbar": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR;
                }
                case "gradient": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT;
                }
            }
        }
        if (AquaComboBoxButton.isOnToolbar(this.comboBox)) {
            return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR;
        }
        return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP;
    }

    public static boolean isOnToolbar(JComboBox jComboBox) {
        return AquaUtils.isOnToolbar(jComboBox);
    }

    @Override
    public Color getForeground() {
        return this.getForeground(false);
    }

    protected Color getForeground(boolean bl) {
        AquaUIPainter.State state;
        Object object;
        AquaButtonExtendedTypes.WidgetInfo widgetInfo;
        Color color;
        if (this.comboBox == null) {
            return super.getForeground();
        }
        Color color2 = this.comboBox.getForeground();
        if ((color2 == null || color2 instanceof UIResource) && (color = (widgetInfo = AquaButtonExtendedTypes.getWidgetInfo(object = this.getWidget(this.getLayoutConfiguration()))).getForeground(state = this.getState(), AquaUIPainter.ButtonState.STATELESS, this.colorDefaults, false, bl)) != null) {
            return color;
        }
        return color2;
    }

    public Icon getIcon(Icon icon) {
        Color color;
        ImageIcon imageIcon;
        AquaUIPainter.State state = this.getState();
        if (icon instanceof ImageIcon && this.isTemplateIconEnabled(imageIcon = (ImageIcon)icon) && (color = this.getForeground(true)) != null) {
            Image image = imageIcon.getImage();
            if ((image = AquaImageFactory.createImageFromTemplate(image, color)) != null) {
                return new ImageIconUIResource(image);
            }
        }
        if (state == AquaUIPainter.State.PRESSED) {
            return AquaIcon.createPressedDarkIcon(icon);
        }
        if (state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE) {
            return AquaIcon.createDisabledLightIcon(icon);
        }
        return icon;
    }

    private boolean isTemplateIconEnabled(ImageIcon imageIcon) {
        if (imageIcon == this.lastTestedIcon) {
            return this.lastTestedIconIsTemplate;
        }
        this.lastTestedIcon = imageIcon;
        this.lastTestedIconIsTemplate = AquaImageFactory.isTemplateImage(imageIcon.getImage());
        return this.lastTestedIconIsTemplate;
    }

    protected AquaUIPainter.State getState() {
        boolean bl = AquaFocusHandler.isActive(this.comboBox);
        if (!this.comboBox.isEnabled()) {
            return bl ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (!bl) {
            return AquaUIPainter.State.INACTIVE;
        }
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            return AquaUIPainter.State.PRESSED;
        }
        if (this.isRollover) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Configuration configuration;
        boolean bl = AquaCellEditorPolicy.getInstance().isCellEditor(this.comboBox);
        boolean bl2 = this.comboBox.isEditable();
        if (bl2 && !bl) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n2 <= 0 || n <= 0) {
            return;
        }
        if (this.comboBox.isOpaque() || bl && !bl2 && !(this.comboBox.getParent() instanceof CellRendererPane)) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        if ((configuration = this.getConfiguration()) != null) {
            this.painter.configure(n, n2);
            Painter painter = this.painter.getPainter(configuration);
            painter.paint(graphics, 0.0f, 0.0f);
            if (!bl2) {
                this.ui.paintValue(graphics);
            }
        }
    }

    public Configuration getConfiguration() {
        AquaUIPainter.State state = this.getState();
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        if (abstractComboBoxLayoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)abstractComboBoxLayoutConfiguration;
            return new PopupButtonConfiguration(popupButtonLayoutConfiguration, state);
        }
        if (abstractComboBoxLayoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            ComboBoxLayoutConfiguration comboBoxLayoutConfiguration = (ComboBoxLayoutConfiguration)abstractComboBoxLayoutConfiguration;
            boolean bl = false;
            return new ComboBoxConfiguration(comboBoxLayoutConfiguration, state, bl);
        }
        return null;
    }

    private class RolloverMouseListener
    extends MouseAdapter {
        private RolloverMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AquaComboBoxButton.this.isRollover = true;
            AquaComboBoxButton.this.comboBox.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AquaComboBoxButton.this.isRollover = false;
            AquaComboBoxButton.this.comboBox.repaint();
        }
    }

    static class AquaComboBoxHierarchyListener
    implements HierarchyListener {
        AquaComboBoxHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Object object;
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && (object = hierarchyEvent.getSource()) instanceof AquaComboBoxButton) {
                AquaComboBoxButton aquaComboBoxButton = (AquaComboBoxButton)object;
                aquaComboBoxButton.configure(null);
            }
        }
    }
}

