/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class WindowDraggingMouseListener
extends MouseInputAdapter {
    private Window w;
    private int xOffset;
    private int yOffset;

    public void attach(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.addMouseListener(this);
            jComponent.addMouseMotionListener(this);
        }
    }

    public void detach(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.removeMouseListener(this);
            jComponent.removeMouseMotionListener(this);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point;
        Component component = mouseEvent.getComponent();
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null && this.isDragArea(component, point = mouseEvent.getPoint())) {
            this.w = window;
            this.xOffset = mouseEvent.getX();
            this.yOffset = mouseEvent.getY();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.w != null) {
            this.w = null;
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.w != null) {
            Point point = MouseInfo.getPointerInfo().getLocation();
            int n = point.x - this.xOffset;
            int n2 = point.y - this.yOffset;
            this.w.setLocation(n, n2);
            mouseEvent.consume();
        }
    }

    protected boolean isDragArea(Component component, Point point) {
        return true;
    }
}

