/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OverlayScrollPaneHack {
    protected JScrollPane scrollPane;
    protected AquaOverlayViewportHolder holder;
    protected JViewport lastKnownViewport;
    protected Component lastKnownView;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener viewportChangeListener;

    public OverlayScrollPaneHack(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
        this.lastKnownViewport = jScrollPane.getViewport();
        this.lastKnownView = this.lastKnownViewport != null ? SwingUtilities.getUnwrappedView(this.lastKnownViewport) : null;
        this.propertyChangeListener = new MyPropertyChangeListener();
        this.viewportChangeListener = new MyViewportChangeListener();
        this.holder = new AquaOverlayViewportHolder();
        this.holder.setBounds(0, 0, jScrollPane.getWidth(), jScrollPane.getHeight());
        jScrollPane.add(this.holder);
        jScrollPane.repaint();
        this.sync(true);
        jScrollPane.addPropertyChangeListener(this.propertyChangeListener);
        if (this.lastKnownViewport != null) {
            this.lastKnownViewport.addChangeListener(this.viewportChangeListener);
        }
    }

    public void dispose() {
        if (this.propertyChangeListener != null) {
            this.scrollPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.viewportChangeListener != null) {
            if (this.lastKnownViewport != null) {
                this.lastKnownViewport.removeChangeListener(this.viewportChangeListener);
            }
            this.viewportChangeListener = null;
        }
        if (this.lastKnownView instanceof JTable) {
            this.scrollPane.setColumnHeaderView(null);
        }
        if (this.holder != null) {
            JScrollBar jScrollBar;
            JScrollBar jScrollBar2;
            JViewport jViewport = this.scrollPane.getViewport();
            if (jViewport != null && jViewport.getParent() == this.holder) {
                this.scrollPane.add(jViewport);
            }
            if ((jScrollBar2 = this.scrollPane.getHorizontalScrollBar()) != null) {
                this.scrollPane.add(jScrollBar2);
            }
            if ((jScrollBar = this.scrollPane.getVerticalScrollBar()) != null) {
                this.scrollPane.add(jScrollBar);
            }
            this.scrollPane.remove(this.holder);
            this.holder = null;
        }
    }

    protected void sync(boolean bl) {
        Component component;
        JViewport jViewport = this.scrollPane.getViewport();
        if (jViewport != this.lastKnownViewport) {
            if (this.lastKnownViewport != null) {
                this.lastKnownViewport.removeChangeListener(this.viewportChangeListener);
                if (this.holder != null) {
                    this.holder.remove(this.lastKnownViewport);
                }
            }
            if (jViewport != null) {
                jViewport.addChangeListener(this.viewportChangeListener);
            }
            this.lastKnownViewport = jViewport;
        }
        if (this.holder != null && jViewport != null && jViewport.getParent() != this.holder) {
            this.holder.add(jViewport);
            this.scrollPane.revalidate();
        }
        Component component2 = component = jViewport != null ? SwingUtilities.getUnwrappedView(jViewport) : null;
        if (this.holder != null && (bl || component != this.lastKnownView)) {
            if (component instanceof JTable) {
                JTable jTable = (JTable)component;
                this.scrollPane.setColumnHeaderView(jTable.getTableHeader());
            } else if (this.lastKnownView instanceof JTable) {
                this.scrollPane.setColumnHeaderView(null);
            }
        }
        this.lastKnownView = component;
    }

    public void syncScrollPaneSize() {
        if (this.holder != null) {
            this.holder.setBounds(0, 0, this.scrollPane.getWidth(), this.scrollPane.getHeight());
        }
    }

    public void reconfigure(JScrollBar jScrollBar, String string) {
        if (this.holder != null) {
            this.scrollPane.remove(jScrollBar);
            this.holder.remove(jScrollBar);
            this.holder.add((Component)jScrollBar, 0);
        }
    }

    protected class AquaOverlayViewportHolder
    extends JComponent {
        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    }

    protected class MyViewportChangeListener
    implements ChangeListener {
        private Component lastKnownView;

        protected MyViewportChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Component component;
            JViewport jViewport = OverlayScrollPaneHack.this.scrollPane.getViewport();
            if (jViewport != null && (component = SwingUtilities.getUnwrappedView(jViewport)) != this.lastKnownView) {
                OverlayScrollPaneHack.this.sync(false);
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null && string.equals("viewport")) {
                OverlayScrollPaneHack.this.sync(false);
            }
        }
    }
}

