/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.FileChooserUI;
import org.violetlib.aqua.AquaUtils;

public class AquaSheetSupport {
    public static void showOptionPaneAsSheet(JDialog jDialog, final JOptionPane jOptionPane, final Consumer<Integer> consumer) throws UnsupportedOperationException {
        Runnable runnable = null;
        if (consumer != null) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    consumer.accept(AquaSheetSupport.getOption(jOptionPane));
                }
            };
        }
        AquaSheetSupport.displayAsSheet(jDialog, runnable);
    }

    private static int getOption(JOptionPane jOptionPane) {
        Object object = jOptionPane.getValue();
        if (object == null) {
            return -1;
        }
        Object[] objectArray = jOptionPane.getOptions();
        if (objectArray == null) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return -1;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static void showFileChooserAsSheet(Window window, final JFileChooser jFileChooser, final Consumer<Integer> consumer) throws UnsupportedOperationException {
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        String string = fileChooserUI.getDialogTitle(jFileChooser);
        jFileChooser.putClientProperty("AccessibleDescription", string);
        final JDialog jDialog = window instanceof Frame ? new JDialog((Window)((Frame)window), string, Dialog.ModalityType.MODELESS) : new JDialog((Window)((Dialog)window), string, Dialog.ModalityType.MODELESS);
        jDialog.setComponentOrientation(jFileChooser.getComponentOrientation());
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jFileChooser, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(window);
        final FileChooserActionListener fileChooserActionListener = new FileChooserActionListener(jDialog);
        jFileChooser.addActionListener(fileChooserActionListener);
        jFileChooser.rescanCurrentDirectory();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = fileChooserActionListener.returnValue;
                jFileChooser.removeActionListener(fileChooserActionListener);
                jDialog.getContentPane().removeAll();
                jDialog.dispose();
                if (consumer != null) {
                    consumer.accept(n);
                }
            }
        };
        try {
            AquaSheetSupport.displayAsSheet(jDialog, runnable);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            jDialog.getContentPane().removeAll();
            jDialog.dispose();
            throw unsupportedOperationException;
        }
    }

    public static void displayAsSheet(Window window, Runnable runnable) throws UnsupportedOperationException {
        int n;
        Object object;
        Window window2;
        Window window3 = window.getOwner();
        if (window3 == null) {
            throw new UnsupportedOperationException("Unable to display as sheet: no owner window");
        }
        if (!window3.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: owner window is not visible");
        }
        if (window.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: the window must not be visible");
        }
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            dialog.setModalityType(Dialog.ModalityType.MODELESS);
        }
        AquaUtils.ensureWindowPeer(window);
        boolean bl = false;
        if (window instanceof Dialog) {
            window2 = (Dialog)window;
            if (!((Dialog)window2).isUndecorated()) {
                bl = true;
            }
        } else if (window instanceof Frame && !((Frame)(window2 = (Frame)window)).isUndecorated()) {
            bl = true;
        }
        int n2 = 0;
        if (bl) {
            n2 = AquaUtils.unsetTitledWindowStyle(window);
        }
        JRootPane jRootPane = null;
        if (window instanceof RootPaneContainer) {
            object = (RootPaneContainer)((Object)window);
            jRootPane = object.getRootPane();
        }
        object = null;
        if (jRootPane != null) {
            object = jRootPane.getClientProperty("Aqua.backgroundStyle");
            jRootPane.putClientProperty("Aqua.backgroundStyle", "vibrantSheet");
            window.validate();
            AquaUtils.paintImmediately(jRootPane);
        }
        SheetCloser sheetCloser = new SheetCloser(window, runnable, object);
        if ("true".equals(System.getProperty("VAqua.injectSheetDisplayFailure"))) {
            System.err.println("Injected failure to display sheet");
            n = -1;
        } else {
            n = AquaSheetSupport.nativeDisplayAsSheet(window);
        }
        if (n != 0) {
            sheetCloser.dispose();
            if (n2 > 0) {
                AquaUtils.restoreTitledWindowStyle(window, n2);
                AquaUtils.syncAWTView(window);
            }
            throw new UnsupportedOperationException("Unable to display as sheet");
        }
        window.setVisible(true);
    }

    private static native int nativeDisplayAsSheet(Window var0);

    private static class SheetCloser
    extends WindowAdapter
    implements HierarchyListener {
        private final Window w;
        private final Runnable closeHandler;
        private final Object oldBackgroundStyle;
        private boolean hasClosed = false;

        public SheetCloser(Window window, Runnable runnable, Object object) {
            this.w = window;
            this.closeHandler = runnable;
            this.oldBackgroundStyle = object;
            window.addWindowListener(this);
            window.addHierarchyListener(this);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (hierarchyEvent.getChangeFlags() == 4L && !this.w.isVisible()) {
                this.completed();
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.completed();
        }

        private void completed() {
            if (!this.hasClosed) {
                this.hasClosed = true;
                this.dispose();
                if (this.closeHandler != null) {
                    this.closeHandler.run();
                }
            }
        }

        public void dispose() {
            RootPaneContainer rootPaneContainer;
            JRootPane jRootPane;
            this.w.removeWindowListener(this);
            this.w.removeHierarchyListener(this);
            if (this.w instanceof RootPaneContainer && (jRootPane = (rootPaneContainer = (RootPaneContainer)((Object)this.w)).getRootPane()) != null) {
                jRootPane.putClientProperty("Aqua.backgroundStyle", this.oldBackgroundStyle);
            }
        }
    }

    private static class FileChooserActionListener
    implements ActionListener {
        private JDialog d;
        int returnValue = -1;

        public FileChooserActionListener(JDialog jDialog) {
            this.d = jDialog;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ApproveSelection")) {
                this.returnValue = 0;
                this.d.setVisible(false);
            } else if (string.equals("CancelSelection")) {
                this.returnValue = 1;
                this.d.setVisible(false);
            }
        }
    }
}

