/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorLayoutConfiguration;

public class AquaProgressBarUI
extends ProgressBarUI
implements ChangeListener,
PropertyChangeListener,
AncestorListener,
AquaUtilControlSize.Sizeable {
    public static final String PROGRESS_BAR_STYLE_KEY = "JProgressBar.style";
    private static final boolean ADJUSTTIMER = true;
    protected AquaUIPainter.Size sizeVariant = AquaUIPainter.Size.REGULAR;
    protected Color selectionForeground;
    private Animator animator;
    protected boolean isAnimating;
    protected boolean isCircular;
    protected int repaintInterval;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected JProgressBar progressBar;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaProgressBarUI();
    }

    protected AquaProgressBarUI() {
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.progressBar = (JProgressBar)jComponent;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.stopAnimationTimer();
        this.progressBar = null;
    }

    protected void installDefaults() {
        LookAndFeel.installProperty(this.progressBar, "opaque", false);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void installListeners() {
        this.progressBar.addChangeListener(this);
        this.progressBar.addPropertyChangeListener(this);
        this.progressBar.addAncestorListener(this);
        AquaUtilControlSize.addSizePropertyListener(this.progressBar);
    }

    protected void uninstallListeners() {
        AquaUtilControlSize.removeSizePropertyListener(this.progressBar);
        this.progressBar.removeAncestorListener(this);
        this.progressBar.removePropertyChangeListener(this);
        this.progressBar.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.progressBar.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("Frame.active".equals(string)) {
            this.progressBar.repaint();
        } else if ("indeterminate".equals(string)) {
            this.stopAnimationTimer();
            this.progressBar.repaint();
        } else if (this.isStyleProperty(string)) {
            String string2 = this.getStyleProperty();
            this.isCircular = "circular".equalsIgnoreCase(string2 + "");
            this.repaintInterval = this.isCircular ? UIManager.getInt("ProgressBar.circularRepaintInterval") : UIManager.getInt("ProgressBar.repaintInterval");
            this.stopAnimationTimer();
            this.progressBar.revalidate();
            this.progressBar.repaint();
        } else if ("orientation".equals(string)) {
            this.progressBar.revalidate();
            this.progressBar.repaint();
        }
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, PROGRESS_BAR_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.progressBar, PROGRESS_BAR_STYLE_KEY);
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.stopAnimationTimer();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (!this.progressBar.isIndeterminate()) {
            return;
        }
        this.startAnimationTimer();
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.revalidateAnimationTimers();
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.bottom + insets.top);
        int n3 = insets.left;
        int n4 = insets.top;
        this.painter.configure(n, n2);
        Configuration configuration = this.getConfiguration();
        this.painter.getPainter(configuration).paint(graphics, n3, n4);
        if (this.isCircular) {
            return;
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, insets.left, insets.top, n, n2);
        }
    }

    protected ProgressIndicatorLayoutConfiguration getLayoutConfiguration() {
        AquaUIPainter.Orientation orientation;
        AquaUIPainter.Orientation orientation2 = orientation = this.isHorizontal() ? AquaUIPainter.Orientation.HORIZONTAL : AquaUIPainter.Orientation.VERTICAL;
        if (this.progressBar.isIndeterminate()) {
            AquaUIPainter.ProgressWidget progressWidget = this.isCircular ? AquaUIPainter.ProgressWidget.SPINNER : AquaUIPainter.ProgressWidget.INDETERMINATE_BAR;
            return new ProgressIndicatorLayoutConfiguration(progressWidget, this.sizeVariant, orientation);
        }
        return new ProgressIndicatorLayoutConfiguration(AquaUIPainter.ProgressWidget.BAR, this.sizeVariant, orientation);
    }

    protected Configuration getConfiguration() {
        AquaUIPainter.Orientation orientation;
        AquaUIPainter.State state = this.getState(this.progressBar);
        AquaUIPainter.Orientation orientation2 = orientation = this.isHorizontal() ? AquaUIPainter.Orientation.HORIZONTAL : AquaUIPainter.Orientation.VERTICAL;
        if (this.progressBar.isIndeterminate()) {
            int n = this.isCircular ? 15 : 90;
            long l = System.currentTimeMillis() / (long)(this.repaintInterval > 0 ? this.repaintInterval : 100);
            int n2 = this.isCircular ? 1 : 4;
            int n3 = (int)((long)n2 * l % (long)n);
            AquaUIPainter.ProgressWidget progressWidget = this.isCircular ? AquaUIPainter.ProgressWidget.SPINNER : AquaUIPainter.ProgressWidget.INDETERMINATE_BAR;
            return new IndeterminateProgressIndicatorConfiguration(progressWidget, this.sizeVariant, state, orientation, n3);
        }
        double d = AquaProgressBarUI.checkValue(this.progressBar.getPercentComplete());
        AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(this.progressBar);
        return new ProgressIndicatorConfiguration(AquaUIPainter.ProgressWidget.BAR, this.sizeVariant, state, orientation, d, uILayoutDirection);
    }

    static double checkValue(double d) {
        return Double.isNaN(d) ? 0.0 : d;
    }

    protected AquaUIPainter.State getState(JComponent jComponent) {
        if (!jComponent.isEnabled()) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (!AquaFocusHandler.isActive(jComponent)) {
            return AquaUIPainter.State.INACTIVE;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    protected void paintString(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics2D.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics2D, string, n, n2, n3, n4);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.isHorizontal()) {
            graphics2D.setColor(this.selectionForeground);
            AquaUtils.drawString(this.progressBar, graphics2D, string, point.x, point.y);
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(AffineTransform.getRotateInstance(-1.5707963267948966, 0.0, 0.0));
            graphics2D.translate(-this.progressBar.getHeight(), 0);
            graphics2D.setColor(this.selectionForeground);
            AquaUtils.drawString(this.progressBar, graphics2D, string, point.x, point.y);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setClip(rectangle);
    }

    protected Point getStringPlacement(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int n5 = fontMetrics.stringWidth(string);
        if (!this.isHorizontal()) {
            int n6 = n4;
            n4 = n3;
            n3 = n6;
            int n7 = n;
            n = n2;
            n2 = n7;
        }
        return new Point(n + Math.round(n3 / 2 - n5 / 2), n2 + (n4 + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2 - 1);
    }

    protected Dimension getCircularPreferredSize() {
        ProgressIndicatorLayoutConfiguration progressIndicatorLayoutConfiguration = this.getLayoutConfiguration();
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(progressIndicatorLayoutConfiguration);
        int n = (int)layoutInfo.getFixedVisualWidth();
        int n2 = (int)layoutInfo.getFixedVisualHeight();
        if (n == 0) {
            n = 32;
        }
        if (n2 == 0) {
            n2 = 32;
        }
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.isCircular) {
            return this.getCircularPreferredSize();
        }
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        ProgressIndicatorLayoutConfiguration progressIndicatorLayoutConfiguration = this.getLayoutConfiguration();
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(progressIndicatorLayoutConfiguration);
        Dimension dimension = this.isHorizontal() ? this.getPreferredHorizontalSize(layoutInfo, fontMetrics) : this.getPreferredVerticalSize(layoutInfo, fontMetrics);
        Insets insets = this.progressBar.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    protected Dimension getPreferredHorizontalSize(LayoutInfo layoutInfo, FontMetrics fontMetrics) {
        int n;
        int n2 = this.sizeVariant == AquaUIPainter.Size.REGULAR ? 146 : 140;
        int n3 = this.sizeVariant == AquaUIPainter.Size.REGULAR ? 20 : 14;
        n3 = (int)Math.max((float)n3, layoutInfo.getMinimumVisualHeight());
        Dimension dimension = new Dimension(n2, n3);
        if (!this.progressBar.isStringPainted()) {
            return dimension;
        }
        String string = this.progressBar.getString();
        int n4 = fontMetrics.stringWidth(string);
        if (n4 > dimension.width) {
            dimension.width = n4;
        }
        if ((n = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
            dimension.height = n;
        }
        return dimension;
    }

    protected Dimension getPreferredVerticalSize(LayoutInfo layoutInfo, FontMetrics fontMetrics) {
        int n;
        int n2 = this.sizeVariant == AquaUIPainter.Size.REGULAR ? 20 : 14;
        int n3 = this.sizeVariant == AquaUIPainter.Size.REGULAR ? 146 : 140;
        n2 = (int)Math.max((float)n2, layoutInfo.getMinimumVisualWidth());
        Dimension dimension = new Dimension(n2, n3);
        if (!this.progressBar.isStringPainted()) {
            return dimension;
        }
        String string = this.progressBar.getString();
        int n4 = fontMetrics.getHeight() + fontMetrics.getDescent();
        if (n4 > dimension.width) {
            dimension.width = n4;
        }
        if ((n = fontMetrics.stringWidth(string)) > dimension.height) {
            dimension.height = n;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.isCircular) {
            return this.getCircularPreferredSize();
        }
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.isHorizontal()) {
            dimension.width = 10;
        } else {
            dimension.height = 10;
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.isCircular) {
            return this.getCircularPreferredSize();
        }
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.isHorizontal()) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    @Override
    public void applySizeFor(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        this.sizeVariant = size;
        AquaUtilControlSize.configureFontFromSize(jComponent, size);
        this.progressBar.revalidate();
        this.progressBar.repaint();
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator();
        }
        this.animator.start();
        this.isAnimating = true;
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            this.animator.stop();
        }
        this.isAnimating = false;
    }

    protected boolean isHorizontal() {
        return this.progressBar.getOrientation() == 0;
    }

    protected void revalidateAnimationTimers() {
        if (!this.progressBar.isIndeterminate() || this.getState(this.progressBar) == AquaUIPainter.State.INACTIVE) {
            this.stopAnimationTimer();
        } else if (!this.isAnimating) {
            this.startAnimationTimer();
        }
    }

    protected class Animator
    implements ActionListener {
        private static final int MINIMUM_DELAY = 5;
        private Timer timer;
        private long previousDelay;
        private long lastCall;
        private final int repaintInterval;

        public Animator() {
            this.repaintInterval = AquaProgressBarUI.this.repaintInterval > 0 ? AquaProgressBarUI.this.repaintInterval : 100;
        }

        protected void start() {
            this.previousDelay = this.repaintInterval;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(this.repaintInterval, this);
            } else {
                this.timer.setDelay(this.repaintInterval);
            }
            this.timer.setRepeats(false);
            this.timer.setCoalesce(false);
            this.timer.start();
        }

        protected void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l = System.currentTimeMillis();
            if (this.lastCall > 0L) {
                int n = (int)(this.previousDelay - l + this.lastCall + (long)this.repaintInterval);
                if (n < 5) {
                    n = 5;
                }
                this.timer.setInitialDelay(n);
                this.previousDelay = n;
            }
            this.timer.start();
            this.lastCall = l;
            AquaProgressBarUI.this.progressBar.repaint();
        }
    }
}

